/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.DataColumn;
import com.intellij.database.extractors.DataColumnImpl;
import com.intellij.database.extractors.DataRow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataRowImpl
implements DataRow {
    private final DataConsumer.Row myRow;
    private final boolean myFirst;
    private final boolean myLast;

    public DataRowImpl(@NotNull DataConsumer.Row row, boolean first, boolean last) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/extractors/DataRowImpl", "<init>"));
        }
        this.myRow = row;
        this.myFirst = first;
        this.myLast = last;
    }

    public int rowNumber() {
        return this.myRow.rowNum;
    }

    public boolean first() {
        return this.myFirst;
    }

    public boolean last() {
        return this.myLast;
    }

    @NotNull
    public List<Object> data() {
        ImmutableList immutableList = ContainerUtil.immutableList((Object[])this.myRow.values);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataRowImpl", "data"));
        }
        return immutableList;
    }

    @Nullable
    public Object value(@NotNull DataColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/DataRowImpl", "value"));
        }
        return ((DataColumnImpl)column).getColumn().getValue(this.myRow);
    }

    @NotNull
    DataConsumer.Row getRow() {
        DataConsumer.Row row = this.myRow;
        if (row == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataRowImpl", "getRow"));
        }
        return row;
    }
}

