/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.coding.CompositeText;
import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.introspection.PostgresIntroQueries;
import com.intellij.database.introspection.PostgresIntrospector$SchemaRetriever$retrieveFunSources$;
import com.intellij.database.introspection.PostgresIntrospector$SchemaRetriever$retrieveRulesSources$;
import com.intellij.database.introspection.PostgresIntrospector$SchemaRetriever$retrieveViewSources$;
import com.intellij.database.introspection.PostgresIntrospectorKt;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMateDatabase;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresDatabase;
import com.intellij.database.model.postgres.PostgresForeignKey;
import com.intellij.database.model.postgres.PostgresModArgument;
import com.intellij.database.model.postgres.PostgresModCheck;
import com.intellij.database.model.postgres.PostgresModDatabase;
import com.intellij.database.model.postgres.PostgresModDefType;
import com.intellij.database.model.postgres.PostgresModDefTypeAttribute;
import com.intellij.database.model.postgres.PostgresModForeignKey;
import com.intellij.database.model.postgres.PostgresModIndex;
import com.intellij.database.model.postgres.PostgresModKey;
import com.intellij.database.model.postgres.PostgresModLikeColumn;
import com.intellij.database.model.postgres.PostgresModLikeStoredTable;
import com.intellij.database.model.postgres.PostgresModLikeTable;
import com.intellij.database.model.postgres.PostgresModMatView;
import com.intellij.database.model.postgres.PostgresModModel;
import com.intellij.database.model.postgres.PostgresModOperator;
import com.intellij.database.model.postgres.PostgresModRoot;
import com.intellij.database.model.postgres.PostgresModRoutine;
import com.intellij.database.model.postgres.PostgresModRule;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresModSequence;
import com.intellij.database.model.postgres.PostgresModTable;
import com.intellij.database.model.postgres.PostgresModTableColumn;
import com.intellij.database.model.postgres.PostgresModTrigger;
import com.intellij.database.model.postgres.PostgresModView;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.PostgresCheckOption;
import com.intellij.database.model.properties.PostgresDataTypeSubCategory;
import com.intellij.database.model.properties.PostgresDataTypeSubKind;
import com.intellij.database.model.properties.PostgresFireMode;
import com.intellij.database.model.properties.PostgresOperatorKind;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NumbersFun;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import gnu.trove.TLongHashSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransaction;
import org.jetbrains.dekaf.sql.SqlQuery;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001:\u0001(B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0014J!\u0010 \u001a\u00020\u00122\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\"\"\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010%\u001a\u00020\u0012H\u0002J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/database/introspection/PostgresIntrospector;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/postgres/PostgresModModel;", "Lcom/intellij/database/model/postgres/PostgresModRoot;", "Lcom/intellij/database/model/postgres/PostgresSchema;", "Lcom/intellij/database/model/postgres/PostgresModSchema;", "facade", "Lorg/jetbrains/dekaf/core/DBFacade;", "(Lorg/jetbrains/dekaf/core/DBFacade;)V", "myQueries", "Lcom/intellij/database/introspection/PostgresIntroQueries;", "kotlin.jvm.PlatformType", "unresolvedForeignReferences", "", "Lkotlin/Pair;", "Lcom/intellij/database/model/postgres/PostgresForeignKey;", "Lcom/intellij/database/introspection/PostgresIntroQueries$OneConstraint;", "applyDatabasesAndSchemas", "", "dbs", "", "Lcom/intellij/database/introspection/LongIdName;", "scs", "applySchemas", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "introspectAutoInTran", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "introspectDatabaseSchemas", "databases", "", "([Lcom/intellij/database/model/basic/BasicDatabase;)V", "introspectNamespacesInTran", "postRetrieving", "retrieveAndApplyOneDatabaseSchemas", "retrieveOneDatabaseSchemas", "SchemaRetriever", "database-introspection"})
public final class PostgresIntrospector
extends BaseIntrospector<PostgresModModel, PostgresModRoot, PostgresSchema, PostgresModSchema> {
    private final PostgresIntroQueries myQueries;
    private final Collection<Pair<PostgresForeignKey, PostgresIntroQueries.OneConstraint>> unresolvedForeignReferences;

    @Override
    public void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        List dbs = (List)tran.query(this.myQueries.listDatabases).run();
        List scs = (List)tran.query(this.myQueries.listSchemas).run();
        List list = dbs;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dbs");
        List list2 = scs;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"scs");
        this.applyDatabasesAndSchemas(list, list2);
    }

    private final void applyDatabasesAndSchemas(List<LongIdName> dbs, List<LongIdName> scs) {
        ((PostgresModModel)this.getModel()).modify(PostgresModRoot.class, new ModelModifier<PostgresModRoot>(dbs){
            final /* synthetic */ List $dbs;

            public final void perform(PostgresModRoot r) {
                NamingIdentifyingFamily databases = r.getDatabases();
                databases.markChildrenAsSyncPending();
                boolean first = true;
                for (LongIdName db : this.$dbs) {
                    if (db.id == 0L || db.name == null) continue;
                    PostgresModDatabase database = (PostgresModDatabase)databases.renew(db.id, db.name);
                    if (!first) continue;
                    first = false;
                    PostgresModDatabase currentDatabase2 = database;
                    currentDatabase2.setVisible(true);
                    currentDatabase2.setCurrent(true);
                }
                databases.removeSyncPendingChildren();
            }
            {
                this.$dbs = list;
            }
        });
        BasicMateDatabase currentDatabase2 = ((PostgresModModel)this.getModel()).getRoot().getCurrentDatabase();
        if (currentDatabase2 != null) {
            this.applySchemas(currentDatabase2, scs);
        }
    }

    @Override
    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)databases, (String)"databases");
        Object[] objectArray2 = objectArray = (Object[])databases;
        if (!(objectArray2.length == 0)) {
            for (int j = 0; j < databases.length; ++j) {
                BasicDatabase database = databases[j];
                this.retrieveAndApplyOneDatabaseSchemas(database);
            }
        } else {
            BasicMateDatabase currentDatabase2;
            BasicMateDatabase basicMateDatabase = ((PostgresModModel)this.getModel()).getRoot().getCurrentDatabase();
            if (basicMateDatabase == null) {
                return;
            }
            BasicMateDatabase basicMateDatabase2 = currentDatabase2 = basicMateDatabase;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicMateDatabase2, (String)"currentDatabase");
            this.retrieveAndApplyOneDatabaseSchemas(basicMateDatabase2);
        }
    }

    private final void retrieveAndApplyOneDatabaseSchemas(BasicDatabase database) {
        boolean bl = Intrinsics.areEqual((Object)database.getDbParent(), (Object)((PostgresModModel)this.getModel()).getRoot());
        if (_Assertions.ENABLED && !bl) {
            String string = "Alien database.";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List<LongIdName> scs = this.retrieveOneDatabaseSchemas(database);
        this.applySchemas(database, scs);
    }

    private final List<LongIdName> retrieveOneDatabaseSchemas(BasicDatabase database) {
        if (database.isCurrent()) {
            Object object = this.getDbFacade().inTransaction((InTransaction)new InTransaction<List<? extends LongIdName>>(this){
                final /* synthetic */ PostgresIntrospector this$0;

                public final List<LongIdName> run(@NotNull DBTransaction tran) {
                    Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                    return (List)tran.query(PostgresIntrospector.access$getMyQueries$p((PostgresIntrospector)this.this$0).listSchemas).run();
                }
                {
                    this.this$0 = postgresIntrospector;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dbFacade.inTransaction<L\u2026ries.listSchemas).run() }");
            return (List)object;
        }
        return CollectionsKt.emptyList();
    }

    private final void applySchemas(BasicDatabase database, List<LongIdName> scs) {
        ((PostgresModModel)this.getModel()).modify(database, PostgresModDatabase.class, new ModelModifier<PostgresModDatabase>(scs){
            final /* synthetic */ List $scs;

            public final void perform(PostgresModDatabase db) {
                NamingIdentifyingFamily schemas2 = db.getSchemas();
                boolean noSchemas = schemas2.isEmpty();
                schemas2.markChildrenAsSyncPending();
                boolean first = true;
                for (LongIdName sc : this.$scs) {
                    if (sc.id == 0L || sc.name == null) continue;
                    PostgresModSchema schema = (PostgresModSchema)schemas2.renew(sc.id, sc.name);
                    if (!first) continue;
                    first = false;
                    schema.setCurrent(true);
                    if (!noSchemas) continue;
                    schema.setVisible(true);
                }
                schemas2.removeSyncPendingChildren();
            }
            {
                this.$scs = list;
            }
        });
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected void introspectAutoInTran(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces) {
        block11: {
            block10: {
                block9: {
                    Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                    v0 = toList = namespaces == null || namespaces.isEmpty() != false || JBIterable.of(namespaces).filter(PostgresDatabase.class).isEmpty() == false;
                    if (toList) {
                        this.introspectNamespacesInTran(tran);
                    }
                    $receiver$iv = ((PostgresModModel)this.getModel()).getRoot().getDatabases();
                    var6_5 = $receiver$iv.iterator();
                    while (var6_5.hasNext()) {
                        element$iv /* !! */  = var6_5.next();
                        it = (PostgresDatabase)element$iv /* !! */ ;
                        if (!it.isCurrent()) continue;
                        v1 = element$iv /* !! */ ;
                        break block9;
                    }
                    v1 = null;
                }
                currentDatabase = v1;
                if (namespaces == null || !((var6_5 = namespaces).isEmpty() == false)) break block10;
                $receiver$iv = namespaces;
                element$iv /* !! */  = $receiver$iv;
                destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    it /* !! */  = (BasicNamespace)element$iv$iv;
                    if (!(it /* !! */  instanceof PostgresSchema)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    it /* !! */  = (BasicNamespace)item$iv$iv;
                    var15_12 = destination$iv$iv;
                    if (it /* !! */  == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.postgres.PostgresSchema");
                    }
                    var15_12.add(var16_13 /* !! */ );
                }
                v2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                break block11;
            }
            v3 = currentDatabase;
            if (v3 == null || (v3 = v3.getSchemas()) == null) ** GOTO lbl-1000
            $receiver$iv$iv = $receiver$iv = (Iterable)v3;
            destination$iv$iv = new ArrayList<E>();
            for (T element$iv$iv : $receiver$iv$iv) {
                it /* !! */  = (PostgresSchema)element$iv$iv;
                if (!it /* !! */ .isVisible()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v3 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            if (v3 != null) {
                v2 = (Iterable)v3;
            } else lbl-1000:
            // 2 sources

            {
                v2 = SetsKt.emptySet();
            }
        }
        schemasToIntrospect = v2;
        for (PostgresSchema schema : schemasToIntrospect) {
            retriever = new SchemaRetriever(tran, schema);
            retriever.retrieve$database_introspection();
        }
        this.postRetrieving();
    }

    /*
     * WARNING - void declaration
     */
    private final void postRetrieving() {
        Collection<Pair<PostgresForeignKey, PostgresIntroQueries.OneConstraint>> collection = this.unresolvedForeignReferences;
        if (!collection.isEmpty()) {
            Iterator<Pair<PostgresForeignKey, PostgresIntroQueries.OneConstraint>> iter = this.unresolvedForeignReferences.iterator();
            while (iter.hasNext()) {
                void con;
                void fkey;
                Pair<PostgresForeignKey, PostgresIntroQueries.OneConstraint> pair = iter.next();
                PostgresForeignKey postgresForeignKey = (PostgresForeignKey)pair.component1();
                PostgresIntroQueries.OneConstraint oneConstraint = (PostgresIntroQueries.OneConstraint)pair.component2();
                pair = null;
                BasicIdentifiedElement basicIdentifiedElement = fkey.getTable();
                if (basicIdentifiedElement == null || (basicIdentifiedElement = basicIdentifiedElement.getSchema()) == null) {
                    continue;
                }
                BasicIdentifiedElement schema = basicIdentifiedElement;
                BasicIdentifiedElement basicIdentifiedElement2 = schema.getDatabase();
                if (basicIdentifiedElement2 == null || (basicIdentifiedElement2 = PostgresIntrospectorKt.findTableByObjectId$default(basicIdentifiedElement2, con.ref_table_id, null, 2, null)) == null) {
                    continue;
                }
                BasicIdentifiedElement refTable = basicIdentifiedElement2;
                ((PostgresModModel)this.getModel()).modify((BasicElement)fkey, PostgresModForeignKey.class, new ModelModifier<PostgresModForeignKey>((PostgresTable)refTable, (PostgresIntroQueries.OneConstraint)con){
                    final /* synthetic */ PostgresTable $refTable;
                    final /* synthetic */ PostgresIntroQueries.OneConstraint $con;

                    public final void perform(PostgresModForeignKey fk) {
                        PostgresIntrospectorKt.access$applyReferencingInfo(fk, this.$refTable, this.$con.index_id);
                    }
                    {
                        this.$refTable = postgresTable;
                        this.$con = oneConstraint;
                    }
                });
                iter.remove();
            }
        }
    }

    public PostgresIntrospector(@NotNull DBFacade facade) {
        Intrinsics.checkParameterIsNotNull((Object)facade, (String)"facade");
        super(facade, PostgresModModel.class, PostgresModRoot.class, PostgresModSchema.class);
        this.myQueries = PostgresIntroQueries.QUERIES;
        this.unresolvedForeignReferences = new ArrayList();
    }

    @NotNull
    public static final /* synthetic */ Collection access$getUnresolvedForeignReferences$p(PostgresIntrospector $this) {
        return $this.unresolvedForeignReferences;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002B\u0017\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002J\r\u0010\"\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020\u001cH\u0002J\b\u0010%\u001a\u00020\u001cH\u0002J\b\u0010&\u001a\u00020\u001cH\u0002J\b\u0010'\u001a\u00020\u001cH\u0002J\b\u0010(\u001a\u00020\u001cH\u0002J\b\u0010)\u001a\u00020\u001cH\u0002J\b\u0010*\u001a\u00020\u001cH\u0002J\b\u0010+\u001a\u00020\u001cH\u0003J\b\u0010,\u001a\u00020\u001cH\u0002J\b\u0010-\u001a\u00020\u001cH\u0002J\b\u0010.\u001a\u00020\u001cH\u0002J\b\u0010/\u001a\u00020\u001cH\u0002J\b\u00100\u001a\u00020\u001cH\u0002J\b\u00101\u001a\u00020\u001cH\u0002J\b\u00102\u001a\u00020\u001cH\u0002J\b\u00103\u001a\u00020\u001cH\u0002J$\u00104\u001a\u00020\u001c*\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020!H\u0002J\u001c\u00104\u001a\u00020\u001c*\u0002052\u0006\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020!H\u0002J\u001c\u0010:\u001a\u00020\u001c*\u00020\u00062\u0006\u0010;\u001a\u00020!2\u0006\u0010<\u001a\u00020!H\u0002J&\u0010=\u001a\u0004\u0018\u000105*\u00020\u00062\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\f2\u0006\u0010A\u001a\u00020!H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/database/introspection/PostgresIntrospector$SchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$SchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/postgres/PostgresModModel;", "Lcom/intellij/database/model/postgres/PostgresModRoot;", "Lcom/intellij/database/model/postgres/PostgresSchema;", "Lcom/intellij/database/model/postgres/PostgresModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/PostgresIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/postgres/PostgresSchema;)V", "myBeginIntrospectionSchemaStateNumber", "", "myBeginIntrospectionTimestamp", "Ljava/sql/Timestamp;", "myFromStateNumber", "myIncremental", "", "myTypes", "", "Lcom/intellij/database/model/DataType;", "srcFromTx", "wasEnums", "wasMatViews", "wasStructures", "wasTables", "wasViews", "determineAndRemoveDroppedClasses", "", "obtainSchemaState", "obtainUsedTypes", "progress", "what", "", "retrieve", "retrieve$database_introspection", "retrieveConstraints", "retrieveDataTypes", "retrieveDescriptions", "retrieveEnumLabels", "retrieveFunSources", "retrieveIndices", "retrieveOperators", "retrieveRoutines", "retrieveRules", "retrieveRulesSources", "retrieveSequences", "retrieveStructAttributes", "retrieveTableColumns", "retrieveTables", "retrieveTriggers", "retrieveViewSources", "handleColumnRenaming", "Lcom/intellij/database/model/postgres/PostgresModLikeStoredTable;", "childrenKind", "Lcom/intellij/database/model/ObjectKind;", "oldName", "newName", "handleTableRenaming", "old", "new", "renewTableOrView", "relKind", "", "objectId", "objectName", "database-introspection"})
    private final class SchemaRetriever
    extends BaseIntrospector.SchemaRetriever {
        private long myFromStateNumber;
        private long myBeginIntrospectionSchemaStateNumber;
        private Timestamp myBeginIntrospectionTimestamp;
        private boolean myIncremental;
        private Map<Long, DataType> myTypes;
        private boolean wasEnums;
        private boolean wasStructures;
        private boolean wasTables;
        private boolean wasViews;
        private boolean wasMatViews;
        private final long srcFromTx;

        private final void progress(String what) {
            String mode = this.myIncremental ? "incrementally" : "completely";
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Introspecting schema %s (%s)";
            Object[] objectArray = new Object[]{((PostgresSchema)this.getSchema()).getName(), mode};
            PostgresIntrospector postgresIntrospector = PostgresIntrospector.this;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            postgresIntrospector.updateStatus(string3, what);
        }

        public final void retrieve$database_introspection() {
            this.obtainSchemaState();
            if (this.myIncremental) {
                boolean somethingNew;
                this.determineAndRemoveDroppedClasses();
                boolean bl = somethingNew = ((PostgresSchema)this.getSchema()).getIntrospectionStateNumber() != this.myBeginIntrospectionSchemaStateNumber || this.getWithSources() && this.srcFromTx < ((PostgresSchema)this.getSchema()).getIntrospectionStateNumber();
                if (!somethingNew) {
                    return;
                }
            } else {
                SchemaRetriever this_$iv = this;
                BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(){

                    /*
                     * WARNING - void declaration
                     */
                    public final void perform(MS schema) {
                        MS MS = schema;
                        Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                        PostgresModSchema schema2 = (PostgresModSchema)MS;
                        List<? extends ModFamily<? extends BasicModElement>> families = schema2.getFamilies();
                        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)families)));
                        int n = intProgression.getFirst();
                        int n2 = intProgression.getLast();
                        int n3 = intProgression.getStep();
                        int n4 = n;
                        int n5 = n2;
                        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                            while (true) {
                                void i2;
                                families.get((int)i2).clear();
                                if (i2 == n2) break;
                                i2 += n3;
                            }
                        }
                    }
                });
            }
            this.retrieveSequences();
            this.retrieveDataTypes();
            this.retrieveTables();
            this.obtainUsedTypes();
            this.retrieveRoutines();
            this.retrieveOperators();
            this.retrieveStructAttributes();
            this.retrieveEnumLabels();
            this.retrieveTableColumns();
            this.retrieveIndices();
            this.retrieveConstraints();
            this.retrieveRules();
            this.retrieveTriggers();
            this.retrieveDescriptions();
            this.retrieveViewSources();
            this.retrieveRulesSources();
            this.retrieveFunSources();
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ SchemaRetriever this$0;
                {
                    this.this$0 = schemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    schema2.setIntrospectionStateNumber(SchemaRetriever.access$getMyBeginIntrospectionSchemaStateNumber$p(this.this$0));
                    schema2.setIntrospectionTimestamp(SchemaRetriever.access$getMyBeginIntrospectionTimestamp$p(this.this$0));
                }
            });
            if (this.getWithSources()) {
                ((PostgresModModel)this.getModel()).setSchemaSourcesVersion((BasicSchema)this.getSchema(), this.myBeginIntrospectionSchemaStateNumber);
            }
        }

        private final void obtainSchemaState() {
            Long currentSchemaTX;
            Timestamp currentTimestamp = (Timestamp)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.now).run();
            long schemaId = ((PostgresSchema)this.getSchema()).getObjectId();
            Long l = currentSchemaTX = (Long)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.countSchemaStateNumber).withParams(new Object[]{schemaId, schemaId, schemaId, schemaId, schemaId, schemaId, schemaId, schemaId, schemaId, schemaId}).run();
            long currentSchemaStateNumber = l != null ? l : 0L;
            long knownSchemaStateNumber = ((PostgresSchema)this.getSchema()).getIntrospectionStateNumber();
            this.myIncremental = knownSchemaStateNumber >= (long)0 && currentSchemaStateNumber >= knownSchemaStateNumber && ((PostgresSchema)this.getSchema()).hasChildren();
            this.myFromStateNumber = this.myIncremental ? knownSchemaStateNumber : 0L;
            this.myBeginIntrospectionSchemaStateNumber = currentSchemaStateNumber;
            this.myBeginIntrospectionTimestamp = currentTimestamp;
        }

        private final void determineAndRemoveDroppedClasses() {
            long schemaId = ((PostgresSchema)this.getSchema()).getObjectId();
            long[] existentIdsArray = (long[])this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.listExistentClasses).withParams(new Object[]{schemaId, schemaId, schemaId, schemaId, schemaId, schemaId, schemaId, schemaId}).run();
            TLongHashSet existentIds = new TLongHashSet(existentIdsArray);
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(existentIds){
                final /* synthetic */ TLongHashSet $existentIds$inlined;
                {
                    this.$existentIds$inlined = tLongHashSet;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    ModIdentifyingFamily[] modIdentifyingFamilyArray = new ModIdentifyingFamily[7];
                    NamingIdentifyingFamily namingIdentifyingFamily = schema2.getSequences();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.sequences");
                    modIdentifyingFamilyArray[0] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily);
                    NamingIdentifyingFamily namingIdentifyingFamily2 = schema2.getDefTypes();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.defTypes");
                    modIdentifyingFamilyArray[1] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily2);
                    NamingIdentifyingFamily namingIdentifyingFamily3 = schema2.getTables();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"schema.tables");
                    modIdentifyingFamilyArray[2] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily3);
                    NamingIdentifyingFamily namingIdentifyingFamily4 = schema2.getMatViews();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"schema.matViews");
                    modIdentifyingFamilyArray[3] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily4);
                    NamingIdentifyingFamily namingIdentifyingFamily5 = schema2.getViews();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily5, (String)"schema.views");
                    modIdentifyingFamilyArray[4] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily5);
                    NamingIdentifyingFamily namingIdentifyingFamily6 = schema2.getRoutines();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily6, (String)"schema.routines");
                    modIdentifyingFamilyArray[5] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily6);
                    NamingIdentifyingFamily namingIdentifyingFamily7 = schema2.getOperators();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily7, (String)"schema.operators");
                    modIdentifyingFamilyArray[6] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily7);
                    PostgresIntrospectorKt.removeDroppedChildren(this.$existentIds$inlined, modIdentifyingFamilyArray);
                    for (PostgresModTable t : schema2.getTables()) {
                        ModIdentifyingFamily[] modIdentifyingFamilyArray2 = new ModIdentifyingFamily[6];
                        NamingIdentifyingFamily namingIdentifyingFamily8 = t.getIndices();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily8, (String)"t.indices");
                        modIdentifyingFamilyArray2[0] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily8);
                        NamingIdentifyingFamily namingIdentifyingFamily9 = t.getKeys();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily9, (String)"t.keys");
                        modIdentifyingFamilyArray2[1] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily9);
                        NamingIdentifyingFamily namingIdentifyingFamily10 = t.getForeignKeys();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily10, (String)"t.foreignKeys");
                        modIdentifyingFamilyArray2[2] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily10);
                        NamingIdentifyingFamily namingIdentifyingFamily11 = t.getChecks();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily11, (String)"t.checks");
                        modIdentifyingFamilyArray2[3] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily11);
                        NamingIdentifyingFamily namingIdentifyingFamily12 = t.getRules();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily12, (String)"t.rules");
                        modIdentifyingFamilyArray2[4] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily12);
                        NamingIdentifyingFamily namingIdentifyingFamily13 = t.getTriggers();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily13, (String)"t.triggers");
                        modIdentifyingFamilyArray2[5] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily13);
                        PostgresIntrospectorKt.removeDroppedChildren(this.$existentIds$inlined, modIdentifyingFamilyArray2);
                    }
                    for (PostgresModMatView m : schema2.getMatViews()) {
                        ModIdentifyingFamily[] modIdentifyingFamilyArray3 = new ModIdentifyingFamily[3];
                        NamingIdentifyingFamily namingIdentifyingFamily14 = m.getIndices();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily14, (String)"m.indices");
                        modIdentifyingFamilyArray3[0] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily14);
                        NamingIdentifyingFamily namingIdentifyingFamily15 = m.getRules();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily15, (String)"m.rules");
                        modIdentifyingFamilyArray3[1] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily15);
                        NamingIdentifyingFamily namingIdentifyingFamily16 = m.getTriggers();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily16, (String)"m.triggers");
                        modIdentifyingFamilyArray3[2] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily16);
                        PostgresIntrospectorKt.removeDroppedChildren(this.$existentIds$inlined, modIdentifyingFamilyArray3);
                    }
                    for (PostgresModView v : schema2.getViews()) {
                        ModIdentifyingFamily[] modIdentifyingFamilyArray4 = new ModIdentifyingFamily[2];
                        NamingIdentifyingFamily namingIdentifyingFamily17 = v.getRules();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily17, (String)"v.rules");
                        modIdentifyingFamilyArray4[0] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily17);
                        NamingIdentifyingFamily namingIdentifyingFamily18 = v.getTriggers();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily18, (String)"v.triggers");
                        modIdentifyingFamilyArray4[1] = (ModIdentifyingFamily)((Object)namingIdentifyingFamily18);
                        PostgresIntrospectorKt.removeDroppedChildren(this.$existentIds$inlined, modIdentifyingFamilyArray4);
                    }
                }
            });
        }

        private final void retrieveSequences() {
            this.progress("sequences");
            SqlQuery<List<PostgresIntroQueries.OneSequence>> query = PostgresIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 1}) ? ((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveSequences91 : ((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveSequences90;
            List sqs = (List)this.getTransaction().query(query).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber}).run();
            if (sqs.isEmpty()) {
                return;
            }
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(sqs){
                final /* synthetic */ List $sqs$inlined;
                {
                    this.$sqs$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    for (PostgresIntroQueries.OneSequence sq : this.$sqs$inlined) {
                        PostgresModSequence sequence = (PostgresModSequence)schema2.getSequences().renew(sq.sequence_id, sq.sequence_name);
                        sequence.setStateNumber(sq.sequence_state_number);
                        String sequenceParams = sq.sequence_params;
                        if (StringUtil.isEmptyOrSpaces((String)sequenceParams)) continue;
                        PostgresModSequence postgresModSequence = sequence;
                        Intrinsics.checkExpressionValueIsNotNull((Object)postgresModSequence, (String)"sequence");
                        String string = sequenceParams;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sequenceParams");
                        PostgresIntrospectorKt.access$assignSequenceParams(postgresModSequence, string);
                    }
                    schema2.getSequences().sort();
                }
            });
        }

        private final void retrieveDataTypes() {
            this.progress("data types");
            List dts = (List)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveDataTypes).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber}).run();
            if (dts.isEmpty()) {
                return;
            }
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, dts){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $dts$inlined;
                {
                    this.this$0 = schemaRetriever;
                    this.$dts$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    for (PostgresIntroQueries.OneDataType dt : this.$dts$inlined) {
                        PostgresDataTypeSubKind subKind = PostgresDataTypeSubKind.of(dt.type_sub_kind);
                        PostgresModDefType dataType = (PostgresModDefType)schema2.getDefTypes().renew(dt.type_id, dt.type_name);
                        dataType.setStateNumber(dt.type_state_number);
                        dataType.setSubKind(subKind);
                        dataType.setSubCategory(PostgresDataTypeSubCategory.of(dt.type_category));
                        dataType.setDefinition(PostgresIntrospectorKt.access$normalizeDataTypeSpec(dt.type_def));
                        dataType.getAttributes().clear();
                        dataType.setLabels(CollectionsKt.emptyList());
                        SchemaRetriever.access$setWasEnums$p(this.this$0, SchemaRetriever.access$getWasEnums$p(this.this$0) | Intrinsics.areEqual((Object)((Object)subKind), (Object)((Object)PostgresDataTypeSubKind.ENUM)));
                        SchemaRetriever.access$setWasStructures$p(this.this$0, SchemaRetriever.access$getWasStructures$p(this.this$0) | Intrinsics.areEqual((Object)((Object)subKind), (Object)((Object)PostgresDataTypeSubKind.COMPOSITE)));
                    }
                }
            });
        }

        private final void retrieveTables() {
            this.progress("tables and views");
            List ts2 = (List)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveTables).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber}).run();
            if (ts2.isEmpty()) {
                return;
            }
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, ts2){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $ts$inlined;
                {
                    this.this$0 = schemaRetriever;
                    this.$ts$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    for (PostgresIntroQueries.OneTable t : this.$ts$inlined) {
                        PostgresModLikeStoredTable table;
                        char c = t.table_kind;
                        long l = t.table_id;
                        String string = t.table_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"t.table_name");
                        if (SchemaRetriever.access$renewTableOrView(this.this$0, schema2, c, l, string) == null) {
                            continue;
                        }
                        table.setStateNumber(t.table_state_number);
                        PostgresModLikeStoredTable postgresModLikeStoredTable = table;
                        if (postgresModLikeStoredTable instanceof PostgresModTable) {
                            if (t.table_with_oids) {
                                ((PostgresModTable)table).setWithOids(true);
                            }
                            boolean bl = t.tablespace_id > (long)0;
                        } else if (postgresModLikeStoredTable instanceof PostgresModView) {
                            String string2 = t.options;
                            if (string2 == null) {
                                string2 = "";
                            }
                            String o = string2;
                            ((PostgresModView)table).setCheckOption(StringsKt.contains$default((CharSequence)o, (CharSequence)"check_option=local", (boolean)false, (int)2, null) ? PostgresCheckOption.LOCAL : (StringsKt.contains$default((CharSequence)o, (CharSequence)"check_option=cascaded", (boolean)false, (int)2, null) ? PostgresCheckOption.CASCADED : PostgresCheckOption.NONE));
                        }
                        SchemaRetriever.access$setWasTables$p(this.this$0, SchemaRetriever.access$getWasTables$p(this.this$0) | t.table_kind == PostgresIntrospectorKt.access$getREL_TABLE$p());
                        SchemaRetriever.access$setWasViews$p(this.this$0, SchemaRetriever.access$getWasViews$p(this.this$0) | t.table_kind == PostgresIntrospectorKt.access$getREL_VIEW$p());
                        SchemaRetriever.access$setWasMatViews$p(this.this$0, SchemaRetriever.access$getWasMatViews$p(this.this$0) | t.table_kind == PostgresIntrospectorKt.access$getREL_MAT_VIEW$p());
                    }
                    if (SchemaRetriever.access$getWasTables$p(this.this$0)) {
                        schema2.getTables().sort();
                    }
                    if (SchemaRetriever.access$getWasViews$p(this.this$0)) {
                        schema2.getViews().sort();
                    }
                    if (SchemaRetriever.access$getWasMatViews$p(this.this$0)) {
                        schema2.getMatViews().sort();
                    }
                }
            });
        }

        private final void retrieveStructAttributes() {
            if (!this.wasStructures) {
                return;
            }
            this.progress("struct attributes");
            List ats = (List)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveStructAttributes).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber}).run();
            if (ats.isEmpty()) {
                return;
            }
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ats){
                final /* synthetic */ List $ats$inlined;
                {
                    this.$ats$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    for (PostgresIntroQueries.OneStructAttribute at : this.$ats$inlined) {
                        PostgresModDefType dataType;
                        if ((PostgresModDefType)schema2.getDefTypes().getByObjectId(at.type_id) == null) {
                            continue;
                        }
                        PostgresModDefTypeAttribute attribute = (PostgresModDefTypeAttribute)dataType.getAttributes().createOrGetAt(at.att_position);
                        attribute.setName(at.att_name);
                        if (at.att_type == null) continue;
                        String string = PostgresIntrospectorKt.access$normalizeDataTypeSpec(at.att_type);
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        DataType attributeType = DataTypeFactory.of(string);
                        attribute.setDataType(attributeType);
                    }
                }
            });
        }

        private final void retrieveEnumLabels() {
            if (!this.wasEnums) {
                return;
            }
            this.progress("enums");
            SqlQuery<Map<Long, String[]>> query = PostgresIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 1}) ? ((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveEnumLabels91 : ((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveEnumLabels90;
            Map els = (Map)this.getTransaction().query(query).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber}).run();
            if (els.isEmpty()) {
                return;
            }
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(els){
                final /* synthetic */ Map $els$inlined;
                {
                    this.$els$inlined = map;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    Map map = this.$els$inlined;
                    Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Object[] objectArray;
                        Object[] objectArray2 = objectArray = iterator.next();
                        Long type_id = (Long)objectArray2.getKey();
                        objectArray2 = objectArray;
                        String[] labels2 = (String[])objectArray2.getValue();
                        if (Intrinsics.areEqual((Object)type_id, (Object)0L) || labels2 == null || (objectArray2 = (Object[])labels2).length == 0) continue;
                        NamingIdentifyingFamily namingIdentifyingFamily = schema2.getDefTypes();
                        Long l = type_id;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"type_id");
                        PostgresModDefType defType = (PostgresModDefType)namingIdentifyingFamily.getByObjectId(l);
                        if (defType == null) continue;
                        defType.setLabels(CollectionsKt.listOf((Object[])Arrays.copyOf(labels2, labels2.length)));
                    }
                }
            });
        }

        private final void obtainUsedTypes() {
            Map typeSpecs = (Map)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveUsedArgumentTypes).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber, ((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber}).run();
            this.myTypes = new HashMap(typeSpecs.size());
            for (Map.Entry entry : typeSpecs.entrySet()) {
                Long typeId = (Long)entry.getKey();
                String typeSpec = (String)entry.getValue();
                typeSpec = PostgresIntrospectorKt.access$normalizeDataTypeSpec(typeSpec);
                DataType type = DataTypeFactory.of(typeSpec);
                Map<Long, DataType> map = this.myTypes;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myTypes");
                }
                Long l = typeId;
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"typeId");
                DataType dataType = type;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"type");
                map.put(l, dataType);
            }
        }

        private final void retrieveRoutines() {
            this.progress("routines");
            List rs = (List)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveRoutines).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber}).run();
            if (rs.isEmpty()) {
                return;
            }
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, rs){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $rs$inlined;
                {
                    this.this$0 = schemaRetriever;
                    this.$rs$inlined = list;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    for (PostgresIntroQueries.OneRoutine r : this.$rs$inlined) {
                        String retTypeSpec;
                        PostgresModRoutine routine2 = (PostgresModRoutine)schema2.getRoutines().renew(r.r_id, r.r_name);
                        routine2.setLanguageName(r.lang);
                        routine2.setStateNumber(r.r_state_number);
                        routine2.setRoutineKind(r.ret_type_id == 0L ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.FUNCTION);
                        routine2.setReturnsSet(r.ret_set);
                        String[] argNames = r.arg_names;
                        char[] argDirections = PostgresIntrospectorKt.access$stringsToChars(r.arg_modes);
                        long[] argTypeIds = PostgresIntrospectorKt.access$isNotEmpty(r.all_arg_types) ? r.all_arg_types : r.in_arg_types;
                        int argNamesCount = PostgresIntrospectorKt.access$getLength$p(argNames);
                        int n = Math.max(Math.max(argNamesCount, argDirections.length), PostgresIntrospectorKt.access$getLength$p(argTypeIds));
                        String resultType = null;
                        StringBuilder resultArguments = null;
                        int n2 = 0;
                        int n3 = n - 1;
                        if (n2 <= n3) {
                            while (true) {
                                DataType dt;
                                DasArgument.Direction direction;
                                void i2;
                                if (i2 < argDirections.length) {
                                    char d = argDirections[i2];
                                    switch (d) {
                                        case 'b': {
                                            direction = DasArgument.Direction.INOUT;
                                            break;
                                        }
                                        case 'o': {
                                            direction = DasArgument.Direction.OUT;
                                            break;
                                        }
                                        case 't': {
                                            direction = DasArgument.Direction.RESULT;
                                            break;
                                        }
                                        default: {
                                            direction = DasArgument.Direction.IN;
                                            break;
                                        }
                                    }
                                } else {
                                    direction = DasArgument.Direction.IN;
                                }
                                String argName = i2 < argNamesCount ? argNames[i2] : null;
                                DataType dataType2 = DataType.UNKNOWN;
                                if (i2 < argTypeIds.length && (dt = (DataType)SchemaRetriever.access$getMyTypes$p(this.this$0).get(argTypeIds[i2])) != null) {
                                    dataType2 = dt;
                                }
                                if (r.ret_set && Intrinsics.areEqual((Object)direction, (Object)DasArgument.Direction.RESULT)) {
                                    if (resultType == null || resultArguments == null) {
                                        resultType = "table";
                                        resultArguments = new StringBuilder();
                                    } else {
                                        resultArguments.append(", ");
                                    }
                                    if (argName != null) {
                                        resultArguments.append(argName).append(' ');
                                    }
                                    resultArguments.append(dataType2.getSpecification());
                                } else {
                                    short position = (short)(i2 + true);
                                    PostgresModArgument argument = (PostgresModArgument)routine2.getArguments().getByNaturalPosition(position);
                                    if (argument == null) {
                                        argument = (PostgresModArgument)routine2.getArguments().createNewOne();
                                        argument.setPosition(position);
                                        if (argument == null) {
                                            Intrinsics.throwNpe();
                                        }
                                    } else {
                                        argument.resetSyncPending();
                                    }
                                    argument.setRealName(argName);
                                    argument.setArgumentDirection(direction);
                                    argument.setDataType(dataType2);
                                }
                                if (i2 == n3) break;
                                ++i2;
                            }
                        }
                        if (resultType != null) {
                            StringBuilder stringBuilder = resultArguments;
                            if (stringBuilder == null) {
                                Intrinsics.throwNpe();
                            }
                            DataType resultDataType = DataTypeFactory.of(null, resultType, stringBuilder.toString(), null);
                            BasicModArgument returns = routine2.createOrGetReturnArgument();
                            returns.setArgumentDirection(DasArgument.Direction.RESULT);
                            returns.setDataType(resultDataType);
                        } else if (r.ret_type_id != 0L) {
                            DataType retType;
                            BasicModArgument returns = routine2.createOrGetReturnArgument();
                            returns.setArgumentDirection(DasArgument.Direction.RETURN);
                            DataType dataType = (DataType)SchemaRetriever.access$getMyTypes$p(this.this$0).get(r.ret_type_id);
                            if (dataType == null) {
                                dataType = retType = DataType.UNKNOWN;
                            }
                            if (r.ret_set) {
                                retTypeSpec = "setof " + retType.getSpecification();
                                retType = DataTypeFactory.of(null, retTypeSpec, null, null);
                            }
                            returns.setDataType(retType);
                        }
                        if (r.arg_defaults != null) {
                            List list;
                            Collection<E> $receiver$iv;
                            CharSequence retType = r.arg_defaults;
                            retTypeSpec = ",\\s+";
                            retTypeSpec = new Regex(retTypeSpec);
                            int argName = 0;
                            int dataType2 = 2;
                            Object position = null;
                            if ((dataType2 & 2) != 0) {
                                argName = 0;
                            }
                            if (!($receiver$iv = retTypeSpec.split(retType, argName)).isEmpty()) {
                                ListIterator<E> iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                                while (iterator$iv.hasPrevious()) {
                                    String p1 = (String)iterator$iv.previous();
                                    CharSequence dataType2 = p1;
                                    if (dataType2.length() == 0) continue;
                                    list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                                    break;
                                }
                            } else {
                                list = CollectionsKt.emptyList();
                            }
                            $receiver$iv = list;
                            Collection<E> collection = $receiver$iv;
                            if (collection == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                            }
                            Collection thisCollection$iv = collection;
                            String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
                            if (stringArray == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                            }
                            String[] defaults = (String[])((Object[])stringArray);
                            List<E> arguments = BaseIntrospectionFunctions.toList(routine2.getArguments());
                            int an = arguments.size();
                            int k = ((Object[])defaults).length;
                            int dataType2 = an - 1;
                            int n4 = 0;
                            if (dataType2 >= n4) {
                                while (true) {
                                    void i3;
                                    PostgresModArgument a;
                                    if ((a = (PostgresModArgument)arguments.get((int)i3)).getArgumentDirection().isIn()) {
                                        if (--k >= 0) {
                                            String theDefaultExpression = PostgresIntrospectorKt.normalizeDefaultExpression(defaults[k]);
                                            a.setDefaultExpression(theDefaultExpression);
                                        } else {
                                            a.setDefaultExpression(null);
                                        }
                                    } else {
                                        a.setDefaultExpression(null);
                                    }
                                    if (i3 != n4) {
                                        --i3;
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else {
                            for (PostgresModArgument a : routine2.getArguments()) {
                                a.setDefaultExpression(null);
                            }
                        }
                        routine2.getArguments().removeSyncPendingChildren();
                    }
                    schema2.getRoutines().sort();
                }
            });
        }

        private final void retrieveOperators() {
            this.progress("operators");
            List ops = (List)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveOperators).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber}).run();
            if (ops.isEmpty()) {
                return;
            }
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, ops){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $ops$inlined;
                {
                    this.this$0 = schemaRetriever;
                    this.$ops$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    for (PostgresIntroQueries.OneOperator op : this.$ops$inlined) {
                        PostgresModOperator operator = (PostgresModOperator)schema2.getOperators().renew(op.op_id, op.op_name);
                        operator.setOperatorKind(PostgresOperatorKind.of(op.op_kind));
                        DataType dataType = op.arg_left_type_id > (long)0 ? (DataType)SchemaRetriever.access$getMyTypes$p(this.this$0).get(op.arg_left_type_id) : null;
                        if (dataType == null) {
                            dataType = DataType.UNKNOWN;
                        }
                        operator.setLeftType(dataType);
                        DataType dataType2 = op.arg_right_type_id > (long)0 ? (DataType)SchemaRetriever.access$getMyTypes$p(this.this$0).get(op.arg_right_type_id) : null;
                        if (dataType2 == null) {
                            dataType2 = DataType.UNKNOWN;
                        }
                        operator.setRightType(dataType2);
                        DataType dataType3 = op.arg_result_type_id > (long)0 ? (DataType)SchemaRetriever.access$getMyTypes$p(this.this$0).get(op.arg_result_type_id) : null;
                        if (dataType3 == null) {
                            dataType3 = DataType.UNKNOWN;
                        }
                        operator.setResultType(dataType3);
                        operator.setCallRoutineName(op.func_main);
                    }
                    schema2.getOperators().sort();
                }
            });
        }

        private final void retrieveTableColumns() {
            boolean toIntrospect;
            boolean bl = toIntrospect = this.wasTables || this.wasMatViews || this.wasViews || this.myIncremental && ((PostgresSchema)this.getSchema()).getTables().hasChildren();
            if (!toIntrospect) {
                return;
            }
            this.progress("table columns");
            List cols3 = (List)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveColumns).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber, ((PostgresSchema)this.getSchema()).getName()}).run();
            if (cols3.isEmpty()) {
                return;
            }
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, cols3){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $cols$inlined;
                {
                    this.this$0 = schemaRetriever;
                    this.$cols$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    HashSet<PostgresModLikeStoredTable> affectedTables = new HashSet<PostgresModLikeStoredTable>();
                    PostgresModLikeStoredTable table = null;
                    long table_id = Long.MIN_VALUE;
                    HashSet<String> belongingSequences = new HashSet<String>();
                    for (PostgresIntroQueries.OneColumn col : this.$cols$inlined) {
                        PostgresModLikeColumn postgresModLikeColumn;
                        if (table == null || col.table_id != table_id) {
                            if (PostgresIntrospectorKt.access$getTableOrView(schema2, PostgresIntrospectorKt.access$getREL_ANY$p(), col.table_id) == null) {
                                continue;
                            }
                            table_id = col.table_id;
                            table.getColumns().markChildrenAsSyncPending();
                            affectedTables.add(table);
                        }
                        PositioningNamingFamily columns = table.getColumns();
                        if (col.column_position >= NumbersFun.__1__) {
                            E e = columns.createOrGetAt(col.column_position);
                            Intrinsics.checkExpressionValueIsNotNull(e, (String)"columns.createOrGetAt(col.column_position)");
                            postgresModLikeColumn = (PostgresModLikeColumn)e;
                        } else {
                            E e = columns.createOrGet(col.column_name);
                            Intrinsics.checkExpressionValueIsNotNull(e, (String)"columns.createOrGet(col.column_name)");
                            postgresModLikeColumn = (PostgresModLikeColumn)e;
                        }
                        PostgresModLikeColumn column = postgresModLikeColumn;
                        column.setPosition(col.column_position);
                        String oldName = column.getName();
                        String string = col.column_name;
                        if (string == null) {
                            String string2 = ModelConsts.NO_NAME;
                            string = string2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"NO_NAME");
                        }
                        String newName = string;
                        if (Intrinsics.areEqual((Object)oldName, (Object)newName) ^ true) {
                            column.setName(newName);
                            if (Intrinsics.areEqual((Object)oldName, (Object)ModelConsts.NO_NAME) ^ true) {
                                String string3 = oldName;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"oldName");
                                SchemaRetriever.access$handleColumnRenaming(this.this$0, table, string3, newName);
                            }
                        }
                        column.resetSyncPending();
                        column.setStateNumber(col.column_state_number);
                        column.setDataType(PostgresIntrospectorKt.access$dataTypeOf(col.type_spec));
                        column.setNotNull(col.mandatory);
                        if (column instanceof PostgresModTableColumn) {
                            String string4 = StringKt.nullize$default((String)col.sequence, (boolean)false, (int)1, null);
                            String belongingSequence = string4 != null ? PostgresIntrospectorKt.access$unquoteSingleName(string4) : null;
                            ((PostgresModTableColumn)column).setSequenceName(belongingSequence);
                            if (belongingSequence != null) {
                                belongingSequences.add(belongingSequence);
                            }
                            ((PostgresModTableColumn)column).setDefaultExpression(StringKt.nullize$default((String)col.column_default_expression, (boolean)false, (int)1, null));
                        }
                        if (col.column_name == null || !StringsKt.startsWith$default((String)col.column_name, (String)"?", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)col.column_name, (String)"?", (boolean)false, (int)2, null)) continue;
                        column.setNameSurrogate(true);
                    }
                    for (PostgresModLikeStoredTable affectedTable : affectedTables) {
                        affectedTable.getColumns().removeSyncPendingChildren();
                        affectedTable.getColumns().sort();
                    }
                    for (PostgresModSequence sequence : schema2.getSequences()) {
                        if (!belongingSequences.contains(sequence.getName())) continue;
                        sequence.setBelongsToColumn(true);
                    }
                }
            });
        }

        private final void handleColumnRenaming(@NotNull PostgresModLikeStoredTable $receiver, String oldName, String newName) {
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.INDEX");
            this.handleColumnRenaming($receiver, objectKind, oldName, newName);
            ObjectKind objectKind2 = ObjectKind.KEY;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"ObjectKind.KEY");
            this.handleColumnRenaming($receiver, objectKind2, oldName, newName);
            ObjectKind objectKind3 = ObjectKind.FOREIGN_KEY;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind3, (String)"ObjectKind.FOREIGN_KEY");
            this.handleColumnRenaming($receiver, objectKind3, oldName, newName);
            ObjectKind objectKind4 = ObjectKind.CHECK;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind4, (String)"ObjectKind.CHECK");
            this.handleColumnRenaming($receiver, objectKind4, oldName, newName);
        }

        /*
         * WARNING - void declaration
         */
        private final void handleColumnRenaming(@NotNull PostgresModLikeStoredTable $receiver, ObjectKind childrenKind, String oldName, String newName) {
            ModFamily f = (ModFamily)$receiver.familyOf(childrenKind);
            if (f != null && f.hasChildren()) {
                for (BasicModElement child : f) {
                    if (!(child instanceof BasicModColumniation)) continue;
                    boolean changed = false;
                    int n = 0;
                    ArrayList<String> names = new ArrayList<String>((Collection)((BasicModColumniation)child).getColNames());
                    int n2 = names.size() - 1;
                    if (n <= n2) {
                        while (true) {
                            void i2;
                            if (Intrinsics.areEqual((Object)((String)names.get((int)i2)), (Object)oldName)) {
                                names.set((int)i2, newName);
                                changed = true;
                            }
                            if (i2 == n2) break;
                            ++i2;
                        }
                    }
                    if (!changed) continue;
                    ((BasicModColumniation)child).setColNames((List<String>)names);
                }
            }
        }

        private final void retrieveIndices() {
            this.progress("indices");
            List inds = (List)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveIndices).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber}).run();
            if (inds.isEmpty()) {
                return;
            }
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(inds){
                final /* synthetic */ List $inds$inlined;
                {
                    this.$inds$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    HashSet<NamingIdentifyingFamily> affectedIndexFamilies = new HashSet<NamingIdentifyingFamily>(this.$inds$inlined.size() / 2);
                    for (PostgresIntroQueries.OneIndex oneIndex : this.$inds$inlined) {
                        PostgresModIndex postgresModIndex;
                        PostgresModLikeStoredTable table;
                        if (PostgresIntrospectorKt.access$getTableOrView(schema2, oneIndex.table_kind, oneIndex.table_id) == null) {
                            continue;
                        }
                        PostgresModLikeStoredTable postgresModLikeStoredTable = table;
                        if (postgresModLikeStoredTable instanceof PostgresModTable) {
                            affectedIndexFamilies.add(((PostgresModTable)table).getIndices());
                            postgresModIndex = (PostgresModIndex)((PostgresModTable)table).getIndices().renew(oneIndex.index_id, oneIndex.index_name);
                        } else {
                            if (!(postgresModLikeStoredTable instanceof PostgresModMatView)) continue;
                            affectedIndexFamilies.add(((PostgresModMatView)table).getIndices());
                            postgresModIndex = (PostgresModIndex)((PostgresModMatView)table).getIndices().renew(oneIndex.index_id, oneIndex.index_name);
                        }
                        PostgresModIndex index = postgresModIndex;
                        index.setUnique(oneIndex.is_unique);
                        index.setFunctionBased(oneIndex.expressions != null);
                        if (oneIndex.expressions == null) {
                            String string = oneIndex.column_positions;
                            String string2 = "Index " + oneIndex.index_name + " column positions";
                            PositioningNamingFamily positioningNamingFamily = table.getColumns();
                            Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"table.columns");
                            index.setColNames(PostgresIntrospectorKt.access$peekColNames(string, string2, positioningNamingFamily));
                            continue;
                        }
                        List items = StringsKt.split$default((CharSequence)oneIndex.expressions, (char[])new char[]{'\u001c'}, (boolean)false, (int)0, (int)6, null);
                        index.setColNames(CollectionsKt.toList((Iterable)items));
                    }
                    for (ModFamily modFamily : affectedIndexFamilies) {
                        modFamily.sort();
                    }
                }
            });
        }

        private final void retrieveConstraints() {
            this.progress("constraints");
            List cons = (List)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveConstraints).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber}).run();
            if (cons.isEmpty()) {
                return;
            }
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, cons){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $cons$inlined;
                {
                    this.this$0 = schemaRetriever;
                    this.$cons$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    HashSet<PostgresModTable> affectedTables = new HashSet<PostgresModTable>(this.$cons$inlined.size() / 3);
                    block5: for (PostgresIntroQueries.OneConstraint con : this.$cons$inlined) {
                        PostgresModTable table;
                        if ((PostgresModTable)schema2.getTables().getByObjectId(con.table_id) == null) {
                            continue;
                        }
                        affectedTables.add(table);
                        switch (con.con_kind) {
                            case 'p': 
                            case 'u': {
                                PostgresModIndex index;
                                PostgresModKey key = (PostgresModKey)table.getKeys().renew(con.con_id, con.con_name);
                                key.setPrimary(con.con_kind == 'p');
                                String string = con.con_columns;
                                String string2 = "Key " + con.con_name + " column positions";
                                PositioningNamingFamily positioningNamingFamily = table.getColumns();
                                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"table.columns");
                                key.setColNames(PostgresIntrospectorKt.access$peekColNames(string, string2, positioningNamingFamily));
                                PostgresModIndex postgresModIndex = index = (PostgresModIndex)table.getIndices().getByObjectId(con.index_id);
                                key.setUnderlyingIndexName(postgresModIndex != null ? postgresModIndex.getRealName() : null);
                                key.setDeferrable(con.is_deferrable);
                                key.setInitiallyDeferred(con.is_init_deferred);
                                break;
                            }
                            case 'f': {
                                PostgresModForeignKey fkey = (PostgresModForeignKey)table.getForeignKeys().renew(con.con_id, con.con_name);
                                String string = con.con_columns;
                                String string3 = "Foreign key " + con.con_name + " domestic column positions";
                                PositioningNamingFamily positioningNamingFamily = table.getColumns();
                                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"table.columns");
                                fkey.setColNames(PostgresIntrospectorKt.access$peekColNames(string, string3, positioningNamingFamily));
                                if (con.ref_table_id <= (long)0 || con.index_id <= (long)0) continue block5;
                                PostgresTable refTable = PostgresIntrospectorKt.access$findTableByObjectId(schema2.getDatabase(), con.ref_table_id, schema2);
                                if (refTable != null) {
                                    PostgresIntrospectorKt.access$applyReferencingInfo(fkey, refTable, con.index_id);
                                } else {
                                    PostgresIntrospector.access$getUnresolvedForeignReferences$p(this.this$0.PostgresIntrospector.this).add(new Pair((Object)fkey, (Object)con));
                                }
                                fkey.setDeferrable(con.is_deferrable);
                                fkey.setInitiallyDeferred(con.is_init_deferred);
                                fkey.setOnUpdate(PostgresIntrospectorKt.access$cascadeRule(con.on_update));
                                fkey.setOnDelete(PostgresIntrospectorKt.access$cascadeRule(con.on_delete));
                                break;
                            }
                            case 'c': {
                                PostgresModCheck check = (PostgresModCheck)table.getChecks().renew(con.con_id, con.con_name);
                                String string = con.con_columns;
                                String string4 = "Check " + con.con_name + " column positions";
                                PositioningNamingFamily positioningNamingFamily = table.getColumns();
                                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"table.columns");
                                check.setColNames(PostgresIntrospectorKt.access$peekColNames(string, string4, positioningNamingFamily));
                                String predicate = con.con_expression;
                                int len = predicate.length();
                                if (len > 2 && predicate.charAt(0) == '(' && predicate.charAt(len - 1) == ')') {
                                    String $receiver$iv;
                                    String string5 = predicate;
                                    int n = 1;
                                    int n2 = len - 1;
                                    String string6 = string5;
                                    if (string6 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string6.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    String string7 = $receiver$iv;
                                    if (string7 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                    }
                                    CharSequence $receiver$iv$iv = string7;
                                    int startIndex$iv$iv = 0;
                                    int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                                    boolean startFound$iv$iv = false;
                                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                                        boolean match$iv$iv;
                                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                        char it = $receiver$iv$iv.charAt(index$iv$iv);
                                        boolean bl = match$iv$iv = it <= ' ';
                                        if (!startFound$iv$iv) {
                                            if (!match$iv$iv) {
                                                startFound$iv$iv = true;
                                                continue;
                                            }
                                            ++startIndex$iv$iv;
                                            continue;
                                        }
                                        if (!match$iv$iv) break;
                                        --endIndex$iv$iv;
                                    }
                                    predicate = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                                }
                                check.setPredicate(predicate);
                                check.setDeferrable(con.is_deferrable);
                                check.setInitiallyDeferred(con.is_init_deferred);
                            }
                        }
                    }
                    for (PostgresModTable table : affectedTables) {
                        table.getKeys().sort();
                        table.getForeignKeys().sort();
                        table.getChecks().sort();
                    }
                }
            });
        }

        private final void retrieveRules() {
            boolean toIntrospect;
            boolean bl = toIntrospect = this.wasTables || this.wasMatViews || this.wasViews || this.myIncremental && (((PostgresSchema)this.getSchema()).getTables().hasChildren() || ((PostgresSchema)this.getSchema()).getMatViews().hasChildren() || ((PostgresSchema)this.getSchema()).getViews().hasChildren());
            if (!toIntrospect) {
                return;
            }
            this.progress("rules");
            List rs = (List)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveRules).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber}).run();
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(rs){
                final /* synthetic */ List $rs$inlined;
                {
                    this.$rs$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    HashSet<PostgresModLikeStoredTable> affectedTables = new HashSet<PostgresModLikeStoredTable>();
                    for (PostgresIntroQueries.OneRule r : this.$rs$inlined) {
                        PostgresModLikeStoredTable table;
                        if (PostgresIntrospectorKt.access$getTableOrView(schema2, PostgresIntrospectorKt.access$getREL_ANY$p(), r.table_id) == null) {
                            continue;
                        }
                        PostgresModRule rule = (PostgresModRule)table.getRules().renew(r.rule_id, r.rule_name);
                        rule.setStateNumber(r.rule_state_number);
                        rule.setEvents(Collections.singleton(TrigEvent.of(r.rule_event_code)));
                        rule.setTurn(r.rule_is_instead ? TrigTurn.INSTEAD_OF : TrigTurn.ALSO);
                        PostgresFireMode postgresFireMode = PostgresFireMode.of(r.rule_fire_mode);
                        if (postgresFireMode == null) {
                            postgresFireMode = PostgresFireMode.ORIGIN;
                        }
                        rule.setFireMode(postgresFireMode);
                        affectedTables.add(table);
                    }
                    for (PostgresModLikeStoredTable affectedTable : affectedTables) {
                        affectedTable.getRules().sort();
                    }
                }
            });
        }

        private final void retrieveTriggers() {
            boolean toIntrospect;
            boolean bl = toIntrospect = this.wasTables || this.myIncremental && ((PostgresSchema)this.getSchema()).getTables().hasChildren();
            if (!toIntrospect) {
                return;
            }
            this.progress("triggers");
            List ts2 = (List)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveTriggers).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber}).run();
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ts2){
                final /* synthetic */ List $ts$inlined;
                {
                    this.$ts$inlined = list;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    HashSet<PostgresModTable> affectedTables = new HashSet<PostgresModTable>();
                    for (PostgresIntroQueries.OneTrigger oneTrigger : this.$ts$inlined) {
                        TrigTurn trigTurn;
                        void that$iv;
                        void $receiver$iv;
                        PostgresModTable table;
                        if ((PostgresModTable)schema2.getTables().getByObjectId(oneTrigger.table_id) == null) {
                            continue;
                        }
                        PostgresModTrigger trigger2 = (PostgresModTrigger)table.getTriggers().renew(oneTrigger.trigger_id, oneTrigger.trigger_name);
                        trigger2.setCallRoutineId(oneTrigger.function_id);
                        trigger2.setStateNumber(oneTrigger.trigger_state_number);
                        byte by = oneTrigger.bits;
                        int n = 28;
                        PostgresModTrigger postgresModTrigger = trigger2;
                        void $receiver$iv$iv = $receiver$iv;
                        byte by2 = (byte)(Byte.toUnsignedInt((byte)$receiver$iv$iv) & that$iv);
                        postgresModTrigger.setEvents(PostgresIntrospectorKt.access$makeTrigEvents(by2));
                        switch (oneTrigger.bits & 3) {
                            case 0: {
                                trigTurn = TrigTurn.AFTER_STMT;
                                break;
                            }
                            case 1: {
                                trigTurn = TrigTurn.AFTER_ROW;
                                break;
                            }
                            case 2: {
                                trigTurn = TrigTurn.BEFORE_STMT;
                                break;
                            }
                            case 3: {
                                trigTurn = TrigTurn.BEFORE_ROW;
                                break;
                            }
                            default: {
                                trigTurn = null;
                            }
                        }
                        trigger2.setTurn(trigTurn);
                        PostgresFireMode postgresFireMode = PostgresFireMode.of(oneTrigger.trigger_fire_mode);
                        if (postgresFireMode == null) {
                            postgresFireMode = PostgresFireMode.ORIGIN;
                        }
                        trigger2.setFireMode(postgresFireMode);
                        affectedTables.add(table);
                    }
                    for (PostgresModLikeStoredTable postgresModLikeStoredTable : affectedTables) {
                        postgresModLikeStoredTable.getTriggers().sort();
                    }
                }
            });
        }

        private final void retrieveDescriptions() {
            boolean toIntrospect;
            boolean bl = toIntrospect = this.wasTables || this.wasMatViews || this.wasViews || this.myIncremental && (((PostgresSchema)this.getSchema()).getTables().hasChildren() || ((PostgresSchema)this.getSchema()).getMatViews().hasChildren() || ((PostgresSchema)this.getSchema()).getViews().hasChildren());
            if (!toIntrospect) {
                return;
            }
            this.progress("descriptions");
            List ds = (List)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveDescriptions).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.myFromStateNumber}).run();
            if (ds.isEmpty()) {
                return;
            }
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ds){
                final /* synthetic */ List $ds$inlined;
                {
                    this.$ds$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    PostgresModSchema schema2 = (PostgresModSchema)MS;
                    PostgresModLikeTable table = null;
                    long table_id = Long.MIN_VALUE;
                    for (PostgresIntroQueries.OneDescription d : this.$ds$inlined) {
                        PositioningNamingFamily columns;
                        PostgresModLikeColumn column;
                        if (d.table_id != table_id) {
                            PostgresModLikeStoredTable postgresModLikeStoredTable = PostgresIntrospectorKt.access$getTableOrView(schema2, d.table_kind, d.table_id);
                            if (postgresModLikeStoredTable == null) {
                                continue;
                            }
                            table = postgresModLikeStoredTable;
                            table_id = d.table_id;
                        }
                        if (table == null) {
                            Intrinsics.throwNpe();
                        }
                        if (d.column_position == NumbersFun.__0__) {
                            table.setComment(d.description);
                            continue;
                        }
                        if (d.column_position <= NumbersFun.__0__ || (column = (PostgresModLikeColumn)(columns = table.getColumns()).getByNaturalPosition(d.column_position)) == null) continue;
                        column.setComment(d.description);
                    }
                }
            });
        }

        private final void retrieveViewSources() {
            if (!this.getWithSources()) {
                return;
            }
            this.progress("view sources");
            List viewSources = (List)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveViewSources).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.srcFromTx}).run();
            if (viewSources.isEmpty()) {
                return;
            }
            PostgresIntrospector this_$iv = PostgresIntrospector.this;
            this_$iv.getModel().writeSources(new Runnable(this, viewSources){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $viewSources$inlined;
                {
                    this.this$0 = schemaRetriever;
                    this.$viewSources$inlined = list;
                }

                public final void run() {
                    SchemaRetriever this_$iv = this.this$0;
                    BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), (ModelModifier)new ModelModifier<MS>(this){
                        final /* synthetic */ SchemaRetriever$retrieveViewSources$$inlined$writeSources$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void perform(MS schema) {
                            MS MS = schema;
                            Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                            PostgresModSchema schema2 = (PostgresModSchema)MS;
                            for (PostgresIntroQueries.OneViewSource vs : this.this$0.$viewSources$inlined) {
                                PostgresModLikeStoredTable view2 = PostgresIntrospectorKt.access$getTableOrView(schema2, vs.view_kind, vs.view_id);
                                String sourceText = vs.source_text;
                                PostgresModLikeStoredTable postgresModLikeStoredTable = view2;
                                if (postgresModLikeStoredTable instanceof PostgresModMatView) {
                                    PostgresIntrospectorKt.access$applySourceText((PostgresModMatView)view2, sourceText);
                                    continue;
                                }
                                if (!(postgresModLikeStoredTable instanceof PostgresModView)) continue;
                                PostgresIntrospectorKt.access$applySourceText((PostgresModView)view2, sourceText);
                            }
                        }
                    });
                }
            });
        }

        private final void retrieveRulesSources() {
            if (!this.getWithSources()) {
                return;
            }
            if (((PostgresSchema)this.getSchema()).getTables().isEmpty() && ((PostgresSchema)this.getSchema()).getMatViews().isEmpty() && ((PostgresSchema)this.getSchema()).getViews().isEmpty()) {
                return;
            }
            this.progress("rule and trigger sources");
            List rs = (List)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveRuleSources).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.srcFromTx}).run();
            if (rs.isEmpty()) {
                return;
            }
            PostgresIntrospector this_$iv = PostgresIntrospector.this;
            this_$iv.getModel().writeSources(new Runnable(this, rs){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $rs$inlined;
                {
                    this.this$0 = schemaRetriever;
                    this.$rs$inlined = list;
                }

                public final void run() {
                    SchemaRetriever this_$iv = this.this$0;
                    BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), (ModelModifier)new ModelModifier<MS>(this){
                        final /* synthetic */ SchemaRetriever$retrieveRulesSources$$inlined$writeSources$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void perform(MS schema) {
                            MS MS = schema;
                            Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                            PostgresModSchema schema2 = (PostgresModSchema)MS;
                            for (PostgresIntroQueries.OneRuleSource r : this.this$0.$rs$inlined) {
                                BasicNode basicNode = PostgresIntrospectorKt.access$getTableOrView(schema2, r.table_kind, r.table_id);
                                if (basicNode == null || (basicNode = basicNode.getRules()) == null || (basicNode = (PostgresModRule)basicNode.getByObjectId(r.rule_id)) == null) {
                                    continue;
                                }
                                BasicNode rule = basicNode;
                                rule.setSourceText(BaseIntrospectionFunctions.toCompositeText(r.source_text, CompositeText.Kind.ORIGINAL_TEXT));
                            }
                        }
                    });
                }
            });
        }

        private final void retrieveFunSources() {
            if (!this.getWithSources()) {
                return;
            }
            this.progress("functions' sources");
            List funSources = (List)this.getTransaction().query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveFunctionSources).withParams(new Object[]{((PostgresSchema)this.getSchema()).getObjectId(), this.srcFromTx}).run();
            if (funSources.isEmpty()) {
                return;
            }
            PostgresIntrospector this_$iv = PostgresIntrospector.this;
            this_$iv.getModel().writeSources(new Runnable(this, funSources){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ List $funSources$inlined;
                {
                    this.this$0 = schemaRetriever;
                    this.$funSources$inlined = list;
                }

                public final void run() {
                    SchemaRetriever this_$iv = this.this$0;
                    BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), (ModelModifier)new ModelModifier<MS>(this){
                        final /* synthetic */ SchemaRetriever$retrieveFunSources$$inlined$writeSources$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void perform(MS schema) {
                            MS MS = schema;
                            Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                            PostgresModSchema schema2 = (PostgresModSchema)MS;
                            for (PostgresIntroQueries.OneFunctionSource fs : this.this$0.$funSources$inlined) {
                                String sourceText;
                                PostgresModRoutine function;
                                if (fs.source_text == null) {
                                    continue;
                                }
                                if ((PostgresModRoutine)schema2.getRoutines().getByObjectId(fs.id) == null) {
                                    continue;
                                }
                                function.setArgumentsDefinition(fs.arguments_def);
                                function.setResultsDefinition(fs.result_def);
                                function.setSourceText(BaseIntrospectionFunctions.toCompositeText(sourceText, CompositeText.Kind.ORIGINAL_TEXT));
                            }
                        }
                    });
                }
            });
        }

        private final PostgresModLikeStoredTable renewTableOrView(@NotNull PostgresModSchema $receiver, char relKind, long objectId, String objectName) {
            char c = relKind;
            PostgresModLikeStoredTable table = c == PostgresIntrospectorKt.access$getREL_TABLE$p() ? (PostgresModLikeStoredTable)$receiver.getTables().renew(objectId, objectName, new BiConsumer<String, String>(this, $receiver){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ PostgresModSchema receiver$0;

                public final void accept(String o, String n) {
                    String string = o;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"o");
                    String string2 = n;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"n");
                    SchemaRetriever.access$handleTableRenaming(this.this$0, this.receiver$0, string, string2);
                }
                {
                    this.this$0 = schemaRetriever;
                    this.receiver$0 = postgresModSchema;
                }
            }) : (c == PostgresIntrospectorKt.access$getREL_MAT_VIEW$p() ? (PostgresModLikeStoredTable)$receiver.getMatViews().renew(objectId, objectName) : (c == PostgresIntrospectorKt.access$getREL_VIEW$p() ? (PostgresModLikeStoredTable)$receiver.getViews().renew(objectId, objectName) : (PostgresModLikeStoredTable)null));
            return table;
        }

        private final void handleTableRenaming(@NotNull PostgresModSchema $receiver, String old, String string) {
            for (PostgresModTable table : $receiver.getTables()) {
                for (PostgresModForeignKey fk : table.getForeignKeys()) {
                    if (!Intrinsics.areEqual((Object)fk.getRefTableName(), (Object)old)) continue;
                    fk.setRefTableName(string);
                }
            }
        }

        public SchemaRetriever(@NotNull DBTransaction transaction, PostgresSchema schema) {
            long l;
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)PostgresIntrospector.this, transaction, (BasicSchema)schema);
            this.setWithSources(PostgresIntrospector.this.getOptions().getSources().compareTo((Enum)DBIntrospectionOptions.SourceLoading.USER_SOURCES) >= 0);
            Long existentSourcesTx = ((PostgresModModel)this.getModel()).getSchemaSourcesVersion(schema);
            if (this.myIncremental) {
                Long l2 = existentSourcesTx;
                if (l2 == null) {
                    l2 = 0L;
                }
                l = l2;
            } else {
                l = 0L;
            }
            this.srcFromTx = l;
        }

        public static final /* synthetic */ long access$getMyBeginIntrospectionSchemaStateNumber$p(SchemaRetriever $this) {
            return $this.myBeginIntrospectionSchemaStateNumber;
        }

        public static final /* synthetic */ void access$setMyBeginIntrospectionSchemaStateNumber$p(SchemaRetriever $this, long l) {
            $this.myBeginIntrospectionSchemaStateNumber = l;
        }

        @Nullable
        public static final /* synthetic */ Timestamp access$getMyBeginIntrospectionTimestamp$p(SchemaRetriever $this) {
            return $this.myBeginIntrospectionTimestamp;
        }

        public static final /* synthetic */ void access$setMyBeginIntrospectionTimestamp$p(SchemaRetriever $this, @Nullable Timestamp timestamp) {
            $this.myBeginIntrospectionTimestamp = timestamp;
        }

        public static final /* synthetic */ boolean access$getWasEnums$p(SchemaRetriever $this) {
            return $this.wasEnums;
        }

        public static final /* synthetic */ void access$setWasEnums$p(SchemaRetriever $this, boolean bl) {
            $this.wasEnums = bl;
        }

        public static final /* synthetic */ boolean access$getWasStructures$p(SchemaRetriever $this) {
            return $this.wasStructures;
        }

        public static final /* synthetic */ void access$setWasStructures$p(SchemaRetriever $this, boolean bl) {
            $this.wasStructures = bl;
        }

        @Nullable
        public static final /* synthetic */ PostgresModLikeStoredTable access$renewTableOrView(SchemaRetriever $this, @NotNull PostgresModSchema $receiver, char relKind, long objectId, @NotNull String objectName) {
            return $this.renewTableOrView($receiver, relKind, objectId, objectName);
        }

        public static final /* synthetic */ boolean access$getWasTables$p(SchemaRetriever $this) {
            return $this.wasTables;
        }

        public static final /* synthetic */ void access$setWasTables$p(SchemaRetriever $this, boolean bl) {
            $this.wasTables = bl;
        }

        public static final /* synthetic */ boolean access$getWasViews$p(SchemaRetriever $this) {
            return $this.wasViews;
        }

        public static final /* synthetic */ void access$setWasViews$p(SchemaRetriever $this, boolean bl) {
            $this.wasViews = bl;
        }

        public static final /* synthetic */ boolean access$getWasMatViews$p(SchemaRetriever $this) {
            return $this.wasMatViews;
        }

        public static final /* synthetic */ void access$setWasMatViews$p(SchemaRetriever $this, boolean bl) {
            $this.wasMatViews = bl;
        }

        @NotNull
        public static final /* synthetic */ Map access$getMyTypes$p(SchemaRetriever $this) {
            Map<Long, DataType> map = $this.myTypes;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myTypes");
            }
            return map;
        }

        public static final /* synthetic */ void access$setMyTypes$p(SchemaRetriever $this, @NotNull Map map) {
            $this.myTypes = map;
        }

        public static final /* synthetic */ void access$handleColumnRenaming(SchemaRetriever $this, @NotNull PostgresModLikeStoredTable $receiver, @NotNull String oldName, @NotNull String newName) {
            $this.handleColumnRenaming($receiver, oldName, newName);
        }

        public static final /* synthetic */ void access$handleTableRenaming(SchemaRetriever $this, @NotNull PostgresModSchema $receiver, @NotNull String old, @NotNull String string) {
            $this.handleTableRenaming($receiver, old, string);
        }
    }
}

