/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.JdbcUtil;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.ReverseCharSequence;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaDataUtil {
    @Nullable
    private static String getSpecificName(@Nullable String specificName, @NotNull String curName, @Nullable String pack) {
        if (curName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "curName", "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil", "getSpecificName"));
        }
        if (StringUtil.isEmptyOrSpaces((String)specificName)) {
            specificName = curName;
        }
        specificName = MetaDataUtil.getProcName(specificName, pack);
        return specificName;
    }

    @NotNull
    public static String getProcName(@NotNull String name, @Nullable String packageName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil", "getProcName"));
        }
        String string = packageName == null ? name : packageName + "/" + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil", "getProcName"));
        }
        return string;
    }

    @NotNull
    public static String qName(@Nullable BasicElement obj) {
        StringBuilder res = new StringBuilder();
        while (obj != null && obj.getKind() != ObjectKind.ROOT) {
            if (res.length() != 0) {
                res.append(".");
            }
            res.append((CharSequence)new ReverseCharSequence((CharSequence)obj.getName()));
            obj = obj.getDbParent();
        }
        String string = res.reverse().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil", "qName"));
        }
        return string;
    }

    @NotNull
    public static String qName(String ... s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil", "qName"));
        }
        String string = StringUtil.join((String[])s, (String)".");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil", "qName"));
        }
        return string;
    }

    static class RemoteResultSetWrapper
    extends ResultSetWrapper {
        private RemoteResultSet myResultSet;
        @Nullable
        private List<Object[]> myRows;
        private int myPosition;
        private boolean myFinished;

        public RemoteResultSetWrapper(ResultSet rs, @NotNull RemoteResultSet remoteResultSet) throws SQLException {
            if (remoteResultSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteResultSet", "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil$RemoteResultSetWrapper", "<init>"));
            }
            super(rs);
            this.myResultSet = remoteResultSet;
        }

        @Override
        public boolean next() throws SQLException {
            if (this.myFinished) {
                return false;
            }
            ++this.myPosition;
            if (this.myRows == null || this.myPosition == this.myRows.size()) {
                this.myFinished = this.myRows != null && this.myRows.size() < 100;
                try {
                    this.myRows = this.myFinished ? null : this.myResultSet.getObjects(100, "", 204800);
                }
                catch (RemoteException e) {
                    this.myRows = null;
                    throw new SQLException(e);
                }
                this.myPosition = 0;
            }
            return this.myRows != null && !this.myRows.isEmpty();
        }

        @Override
        @Nullable
        public Object getObject(String column, int colNum) {
            int i2 = this.getColumnIndex(column, colNum);
            return i2 == 0 ? null : this.myRows.get(this.myPosition)[i2 - 1];
        }
    }

    static class LocalResultSetWrapper
    extends ResultSetWrapper {
        public LocalResultSetWrapper(ResultSet rs) throws SQLException {
            super(rs);
        }

        @Override
        public boolean next() throws SQLException {
            return this.myDelegate.next();
        }

        @Override
        @Nullable
        public Object getObject(String column, int colNum) throws SQLException {
            int i2 = this.getColumnIndex(column, colNum);
            return i2 == 0 ? null : this.myDelegate.getObject(i2);
        }
    }

    public static abstract class ResultSetWrapper {
        @Nullable
        protected final ResultSet myDelegate;
        @NotNull
        protected final TObjectIntHashMap<String> myColumnMap;
        protected final int myColumnCount;

        public ResultSetWrapper(@Nullable ResultSet rs) throws SQLException {
            this.myDelegate = rs;
            this.myColumnMap = new TObjectIntHashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            ResultSetMetaData metaData = rs == null ? null : rs.getMetaData();
            this.myColumnCount = metaData == null ? 0 : metaData.getColumnCount();
            for (int i2 = 0; i2 < this.myColumnCount; ++i2) {
                this.myColumnMap.put((Object)metaData.getColumnName(i2 + 1), i2 + 1);
                this.myColumnMap.put((Object)metaData.getColumnLabel(i2 + 1), i2 + 1);
            }
        }

        @Contract(value="!null->!null")
        public static ResultSetWrapper wrap(@Nullable ResultSet rs) throws SQLException {
            if (rs == null) {
                return ResultSetWrapper.createEmpty();
            }
            RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemote((Object)rs, RemoteResultSet.class);
            if (remoteResultSet != null) {
                return new RemoteResultSetWrapper(rs, remoteResultSet);
            }
            return new LocalResultSetWrapper(rs);
        }

        @Nullable
        private static ResultSetWrapper createEmpty() throws SQLException {
            return new ResultSetWrapper(null){

                @Override
                public boolean next() throws SQLException {
                    return false;
                }

                @Override
                @NotNull
                public Object getObject(String column, int colNum) throws SQLException {
                    throw new IllegalStateException();
                }
            };
        }

        public static void close(@Nullable ResultSetWrapper wrapper) {
            try {
                ResultSet delegate;
                ResultSet resultSet = delegate = wrapper == null ? null : wrapper.myDelegate;
                if (delegate != null) {
                    delegate.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public abstract boolean next() throws SQLException;

        @Nullable
        public abstract Object getObject(String var1, int var2) throws SQLException;

        public boolean getBoolean(String column, int colNum) throws SQLException {
            return Boolean.TRUE.equals(this.getObject(column, colNum));
        }

        public int getInt(String column, int colNum, int def) throws SQLException {
            Object o = this.getObject(column, colNum);
            return o instanceof Number ? ((Number)o).intValue() : (o instanceof String ? StringUtil.parseInt((String)((String)o), (int)def) : def);
        }

        public short getShort(String column, int colNum) throws SQLException {
            Object o = this.getObject(column, colNum);
            return o instanceof Number ? ((Number)o).shortValue() : (short)0;
        }

        @Nullable
        public String getString(String column, int colNum) throws SQLException {
            Object o = this.getObject(column, colNum);
            return o instanceof String ? (String)o : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public <T> List<T> list(@NotNull String columnName, int colNum, @Nullable PairConsumer<String, Throwable> errorSink) throws SQLException {
            if (columnName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnName", "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil$ResultSetWrapper", "list"));
            }
            ArrayList<Object> retVal = new ArrayList<Object>();
            try {
                while (this.next()) {
                    retVal.add(this.getObject(columnName, colNum));
                }
            }
            catch (SQLException sQLException) {
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (errorSink != null) {
                    errorSink.consume(message.contains(columnName) ? null : columnName + " unavailable", (Object)e);
                }
            }
            finally {
                JdbcUtil.closeResultSetSafe((ResultSet)this.myDelegate);
            }
            ArrayList<Object> arrayList = retVal;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil$ResultSetWrapper", "list"));
            }
            return arrayList;
        }

        protected int getColumnIndex(String column, int colNum) {
            int i2 = this.myColumnMap.get((Object)column);
            if (i2 == 0) {
                i2 = colNum;
            } else if (i2 != colNum) {
                // empty if block
            }
            return i2 < 1 || i2 > this.myColumnCount ? 0 : i2;
        }
    }

    public static class SpecNamer {
        TObjectIntHashMap<String> counts = new TObjectIntHashMap();

        @NotNull
        public String getSpecName(@Nullable String spec, @NotNull String name, @Nullable String cat) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil$SpecNamer", "getSpecName"));
            }
            if (spec == null || Comparing.equal((String)spec, (String)name)) {
                String nonSpec = MetaDataUtil.getSpecificName(name, name, cat);
                int cnt = 0;
                if (this.counts.containsKey((Object)nonSpec)) {
                    cnt = this.counts.get((Object)nonSpec);
                }
                this.counts.put((Object)nonSpec, cnt);
                spec = name + "&&DG_" + cnt;
            }
            String string = (String)ObjectUtils.assertNotNull((Object)MetaDataUtil.getSpecificName(spec, name, cat));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil$SpecNamer", "getSpecName"));
            }
            return string;
        }

        public void finish(@Nullable String spec, @NotNull String name, @Nullable String cat) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil$SpecNamer", "finish"));
            }
            if (spec == null || Comparing.equal((String)spec, (String)name)) {
                String nonSpec = MetaDataUtil.getSpecificName(name, name, cat);
                int cnt = 0;
                if (this.counts.containsKey((Object)nonSpec)) {
                    cnt = this.counts.get((Object)nonSpec);
                }
                this.counts.put((Object)nonSpec, ++cnt);
            }
        }
    }
}

