/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.coding.CompositeText;
import com.intellij.coding.SimpleCompositeText;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicModelListener;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSourceAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicModModel
extends BasicModel {
    public <R extends BasicModRoot> void modify(@NotNull Class<R> var1, @NotNull ModelModifier<? super R> var2);

    public <E extends BasicElement, M extends E> void modify(@NotNull E var1, @NotNull Class<M> var2, @NotNull ModelModifier<? super M> var3);

    public void addListener(@NotNull BasicModelListener var1);

    public void removeListener(@NotNull BasicModelListener var1);

    default public void clearModel() {
        if (this.getRoot().hasChildren()) {
            this.modify(BasicModRoot.class, BasicModElement::dropChildren);
        }
    }

    public void writeSources(@NotNull Runnable var1);

    public void saveSourceText(@NotNull BasicSourceAware var1, @Nullable CompositeText var2);

    @Deprecated
    default public void saveSourceText(@NotNull BasicSourceAware object, @Nullable String sourceText) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/model/basic/BasicModModel", "saveSourceText"));
        }
        SimpleCompositeText ct = new SimpleCompositeText(sourceText, CompositeText.Kind.ORIGINAL_TEXT);
        this.saveSourceText(object, ct);
    }

    @Nullable
    public CompositeText loadSourceText(@NotNull BasicSourceAware var1);

    public void setSchemaSourcesVersion(@NotNull BasicSchema var1, @Nullable Long var2);

    @Nullable
    public Long getSchemaSourcesVersion(@NotNull BasicSchema var1);

    public void waitForSourcesWritten();

    default public void modifyNamedElement(@NotNull BasicNamedElement namespace, @NotNull ModelModifier<BasicModNamedElement> modifier) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/database/model/basic/BasicModModel", "modifyNamedElement"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/database/model/basic/BasicModModel", "modifyNamedElement"));
        }
        this.modify(namespace, BasicModNamedElement.class, modifier);
    }

    default public void modifyNamespace(@NotNull BasicNamespace namespace, @NotNull ModelModifier<BasicModNamespace> modifier) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/database/model/basic/BasicModModel", "modifyNamespace"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/database/model/basic/BasicModModel", "modifyNamespace"));
        }
        this.modify(namespace, BasicModNamespace.class, modifier);
    }
}

