/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicRoutine;
import org.jetbrains.annotations.NotNull;

public interface BasicOverloadable
extends BasicElement {
    @Override
    @NotNull
    default public String identity(boolean includingSurrogate) {
        String string = BasicOverloadable.calculateIdentity(this, includingSurrogate);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicOverloadable", "identity"));
        }
        return string;
    }

    @NotNull
    public static String calculateIdentity(@NotNull BasicOverloadable o, boolean includingSurrogate) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/model/basic/BasicOverloadable", "calculateIdentity"));
        }
        StringBuilder b = new StringBuilder();
        if (o instanceof BasicNamedElement) {
            String name;
            BasicNamedElement ne = (BasicNamedElement)((Object)o);
            String string = name = includingSurrogate ? ne.getRealName() : ne.getNaturalName();
            if (name != null) {
                b.append(name);
            }
        }
        if (o instanceof BasicRoutine) {
            BasicRoutine r = (BasicRoutine)((Object)o);
            boolean w = false;
            b.append('(');
            for (BasicArgument basicArgument : r.getArguments()) {
                if (!BasicOverloadable.argumentIsIn(basicArgument)) continue;
                if (w) {
                    b.append(',');
                }
                b.append(basicArgument.getDataType().getSpecification());
                w = true;
            }
            b.append(')');
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicOverloadable", "calculateIdentity"));
        }
        return string;
    }

    public static boolean argumentIsIn(BasicArgument a) {
        DasArgument.Direction direction = a.getArgumentDirection();
        return direction == null || direction.isIn();
    }

    @Override
    @NotNull
    default public String calculateDisplayOrder() {
        String string = this.identity();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicOverloadable", "calculateDisplayOrder"));
        }
        return string;
    }
}

