/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.intellij.coding.CompositeText;
import com.intellij.coding.CompositeTextFun;
import com.intellij.coding.SimpleCompositeText;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.impl.MemoryTextStorage;
import com.intellij.database.model.properties.IdentityAndKind;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0017\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0016J\u001f\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\nH\u0016J\u0012\u0010\u001f\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020!0 H\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\""}, d2={"Lcom/intellij/database/model/impl/MemoryTextStorage;", "Lcom/intellij/database/model/ModelTextStorage;", "()V", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/coding/CompositeText;", "getMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "beginWrite", "", "endWrite", "getVersion", "", "object", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/model/basic/BasicElement;)Ljava/lang/Long;", "hasExistingSources", "", "element", "load", "obj", "Lcom/intellij/database/model/basic/BasicSourceAware;", "processDeleteQueue", "queueDelete", "save", "text", "setVersion", "version", "(Lcom/intellij/database/model/basic/BasicElement;Ljava/lang/Long;)V", "waitForWriteFinished", "toKey", "", "Lcom/intellij/database/model/properties/IdentityAndKind;", "database-model-impl"})
public final class MemoryTextStorage
implements ModelTextStorage {
    @NotNull
    private final ConcurrentHashMap<String, CompositeText> map = new ConcurrentHashMap();

    @NotNull
    public final ConcurrentHashMap<String, CompositeText> getMap() {
        return this.map;
    }

    @Override
    public void save(@NotNull BasicSourceAware obj, @Nullable CompositeText text) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        String key = this.toKey(obj.getSourcePath());
        if (text != null) {
            Map map = this.map;
            SimpleCompositeText simpleCompositeText = CompositeTextFun.copy(text);
            map.put(key, simpleCompositeText);
        } else {
            this.map.remove(key);
        }
    }

    @Override
    public void queueDelete(@NotNull BasicSourceAware obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        this.save(obj, null);
    }

    @Override
    public void processDeleteQueue() {
    }

    @Override
    @Nullable
    public CompositeText load(@NotNull BasicSourceAware obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        String key = this.toKey(obj.getSourcePath());
        return this.map.get(key);
    }

    @Override
    public boolean hasExistingSources(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return !(element instanceof BasicSourceAware) || this.map.contains(this.toKey(((BasicSourceAware)element).getSourcePath()));
    }

    @Override
    public void beginWrite() {
    }

    @Override
    public void endWrite() {
    }

    @Override
    @Nullable
    public Long getVersion(@NotNull BasicElement object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"object");
        return null;
    }

    @Override
    public void setVersion(@NotNull BasicElement object, @Nullable Long version) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"object");
    }

    @Override
    public void waitForWriteFinished() {
    }

    private final String toKey(@NotNull List<IdentityAndKind> $receiver) {
        return CollectionsKt.joinToString$default((Iterable)$receiver, (CharSequence)"\u0000", null, null, (int)0, null, (Function1)toKey.1.INSTANCE, (int)30, null);
    }
}

