/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresModCatalogObject;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresSequence;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresModSequence
extends PostgresSequence,
PostgresModCatalogObject,
BasicModNamedElement {
    @Override
    @NotNull
    public PostgresModSchema getSchema();

    @Override
    @NotNull
    default public PostgresModSchema getDbParent() {
        PostgresModSchema postgresModSchema = this.getSchema();
        if (postgresModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModSequence", "getDbParent"));
        }
        return postgresModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModSequence> getParentFamily();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModSequence", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModSequence", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setStateNumber(long var1);

    public void setSequenceIdentity(@Nullable SequenceIdentity var1);

    public void setCycled(boolean var1);

    public void setBelongsToColumn(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/postgres/PostgresModSequence", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String stateNumber = properties.get("StateNumber");
        String sequenceIdentity = properties.get("SequenceIdentity");
        String cycled = properties.get("Cycled");
        String belongsToColumn = properties.get("BelongsToColumn");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (stateNumber != null) {
            this.setStateNumber(PropertyConverter.importLong(stateNumber));
        }
        if (sequenceIdentity != null) {
            this.setSequenceIdentity(PropertyConverter.importSequenceIdentity(sequenceIdentity));
        }
        if (cycled != null) {
            this.setCycled(PropertyConverter.importBoolean(cycled));
        }
        if (belongsToColumn != null) {
            this.setBelongsToColumn(PropertyConverter.importBoolean(belongsToColumn));
        }
    }
}

