/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.settings.DatabaseSettingsConfigurable;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.Consumer;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterator;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleDataRequest
extends DataRequest.QueryRequest {
    private final Shared shared;
    public final int queryIndex;
    public final boolean hasNext;
    public final Object resultType;
    private static final Key<ErrorPanelInfo> ERROR_PANEL_KEY = Key.create((String)"ERROR_PANEL_KEY");

    @NotNull
    public static ConsoleDataRequest newConsoleRequest(@NotNull AbstractQueryLanguageConsole<?> console, @NotNull Editor editor, @NotNull ScriptModel<?> model) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/ConsoleDataRequest", "newConsoleRequest"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/run/ConsoleDataRequest", "newConsoleRequest"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/run/ConsoleDataRequest", "newConsoleRequest"));
        }
        DataRequest.Constraints constraints = ConsoleDataRequest.newConstraints();
        Shared shared = new Shared(editor, model, constraints);
        shared.queries.advance();
        DataRequest.TxMarker batchTx = console.getCurrentTx();
        ConsoleDataRequest consoleDataRequest = new ConsoleDataRequest(console, batchTx, shared, 0);
        if (consoleDataRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleDataRequest", "newConsoleRequest"));
        }
        return consoleDataRequest;
    }

    private ConsoleDataRequest(@NotNull AbstractQueryLanguageConsole<?> console, @NotNull DataRequest.TxMarker txMarker, @NotNull Shared shared, int queryIndex) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/ConsoleDataRequest", "<init>"));
        }
        if (txMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "txMarker", "com/intellij/database/run/ConsoleDataRequest", "<init>"));
        }
        if (shared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shared", "com/intellij/database/run/ConsoleDataRequest", "<init>"));
        }
        super(console, txMarker, ConsoleDataRequest.currentQueryText(console, shared), shared.constraints, null);
        this.shared = shared;
        this.queryIndex = queryIndex;
        this.resultType = ((ScriptModel.StatementIt)shared.queries.current()).resultType(console);
        this.hasNext = shared.queries.hasNext();
    }

    @NotNull
    private static String currentQueryText(@NotNull AbstractQueryLanguageConsole<?> console, @NotNull Shared shared) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/ConsoleDataRequest", "currentQueryText"));
        }
        if (shared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shared", "com/intellij/database/run/ConsoleDataRequest", "currentQueryText"));
        }
        String currentText = ((ScriptModel.StatementIt)shared.queries.current()).text(console.myPStorage, Conditions.alwaysFalse());
        String lineSeparator = (String)ObjectUtils.notNull((Object)console.getLanguageConsole().getVirtualFile().getDetectedLineSeparator(), (Object)LineSeparator.getSystemLineSeparator().getSeparatorString());
        String string = StringUtil.convertLineSeparators((String)currentText, (String)lineSeparator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleDataRequest", "currentQueryText"));
        }
        return string;
    }

    @NotNull
    private AbstractQueryLanguageConsole getConsole() {
        AbstractQueryLanguageConsole abstractQueryLanguageConsole = (AbstractQueryLanguageConsole)this.owner;
        if (abstractQueryLanguageConsole == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleDataRequest", "getConsole"));
        }
        return abstractQueryLanguageConsole;
    }

    @NotNull
    private DataProducer getDataProducer() {
        DataProducer dataProducer = this.getConsole().getMessageBus().getDataProducer();
        if (dataProducer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleDataRequest", "getDataProducer"));
        }
        return dataProducer;
    }

    @NotNull
    public UserDataHolder getSharedDataHolder() {
        Shared shared = this.shared;
        if (shared == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleDataRequest", "getSharedDataHolder"));
        }
        return shared;
    }

    public void onError(@Nullable String message, @Nullable Throwable th) {
        if (message != null) {
            Throwable throwable = new Throwable(message);
            throwable.setStackTrace(th == null ? new StackTraceElement[]{} : th.getStackTrace());
            this.reportError(throwable);
        } else if (th != null) {
            this.reportError(th);
        }
    }

    public void onFinished() {
        if (this.isLastInChain()) {
            return;
        }
        this.getDataProducer().processRequest(this.nextRequest());
    }

    public boolean isLastInChain() {
        return !this.shared.ignoreAll && this.shared.errCount > this.shared.errIgnored || !this.hasNext;
    }

    @NotNull
    private ConsoleDataRequest nextRequest() {
        this.shared.queries.advance();
        AbstractQueryLanguageConsole console = this.getConsole();
        ConsoleDataRequest consoleDataRequest = new ConsoleDataRequest(console, console.getCurrentTx(), this.shared, this.queryIndex + 1);
        if (consoleDataRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleDataRequest", "nextRequest"));
        }
        return consoleDataRequest;
    }

    @NotNull
    private ConsoleDataRequest cloneRequest() {
        AbstractQueryLanguageConsole console = this.getConsole();
        ConsoleDataRequest consoleDataRequest = new ConsoleDataRequest(console, console.getCurrentTx(), this.shared, this.queryIndex);
        if (consoleDataRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleDataRequest", "cloneRequest"));
        }
        return consoleDataRequest;
    }

    public void onStarted() {
        DbUIUtil.invokeLater(() -> {
            if (!this.hasNext || this.shared.lastUpdateTime < 0L || System.currentTimeMillis() - this.shared.lastUpdateTime > 100L) {
                this.updateConsoleUI(false);
            }
        });
        this.shared.lastUpdateTime = System.currentTimeMillis();
    }

    private void updateConsoleUI(boolean scrollToQuery) {
        TextRange range;
        this.closeErrorPanel();
        if (scrollToQuery && (range = this.getRange()) != null) {
            this.scrollToRange(range);
        }
        this.updateHighlighting();
    }

    private void reportError(@NotNull Throwable error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/run/ConsoleDataRequest", "reportError"));
        }
        ++this.shared.errCount;
        DbUIUtil.invokeLater(() -> {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/run/ConsoleDataRequest", "lambda$reportError$2"));
            }
            this.updateConsoleUI(!this.shared.ignoreAll);
            if (!this.hasNext) {
                this.handleQueryError(error, null);
            } else if (!this.shared.ignoreAll) {
                this.handleQueryError(error, (Consumer<Decision>)((Consumer)feedback -> {
                    this.closeErrorPanel();
                    switch (feedback) {
                        case STOP: {
                            break;
                        }
                        case RETRY: {
                            --this.shared.errCount;
                            this.getDataProducer().processRequest(this.cloneRequest());
                            break;
                        }
                        case IGNORE_ALL: {
                            this.shared.ignoreAll = true;
                            this.getDataProducer().processRequest(this.nextRequest());
                            break;
                        }
                        case IGNORE: {
                            ++this.shared.errIgnored;
                            this.getDataProducer().processRequest(this.nextRequest());
                        }
                    }
                }));
            }
        });
    }

    public void closeErrorPanel() {
        ConsoleDataRequest.hideErrorPanel(this.shared.sourceEditor);
    }

    private void handleQueryError(@NotNull Throwable error, @Nullable Consumer<Decision> feedbackListener) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/run/ConsoleDataRequest", "handleQueryError"));
        }
        if (error instanceof ProcessCanceledException) {
            return;
        }
        if (feedbackListener == null && !DatabaseSettings.getSettings().isShowErrorInEditor()) {
            return;
        }
        if (!this.shared.sourceEditor.getContentComponent().isShowing()) {
            return;
        }
        Project project = this.getConsole().getProject();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.shared.sourceEditor.getDocument());
        if (file == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        FileEditor fileEditor = editorManager.getSelectedEditor(file.getVirtualFile());
        if (fileEditor != null) {
            DatabaseDialect databaseDialect;
            ErrorNotificationPanel errorPanel = this.createErrorNotificationPanel(this.shared.sourceEditor, error, feedbackListener);
            editorManager.addBottomComponent(fileEditor, (JComponent)errorPanel);
            Container parent = errorPanel.getParent();
            if (parent instanceof JComponent) {
                ((JComponent)parent).setBorder(IdeBorderFactory.createEmptyBorder());
            }
            ERROR_PANEL_KEY.set((UserDataHolder)this.shared.sourceEditor, (Object)new ErrorPanelInfo(errorPanel, feedbackListener));
            this.shared.sourceEditor.getContentComponent().requestFocusInWindow();
            TextRange queryRange = this.getRange();
            SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect((PsiElement)file);
            DatabaseDialect databaseDialect2 = databaseDialect = dialect != null ? dialect.getDatabaseDialect() : null;
            if (queryRange != null && databaseDialect != null) {
                int offset;
                int position = ConsoleDataRequest.getOffsetFromErrorMessage(databaseDialect.getFamilyId(), StringUtil.notNullize((String)error.getMessage()), this.query, dialect, project);
                int n = offset = position >= 0 ? position + queryRange.getStartOffset() : -1;
                if (offset >= queryRange.getEndOffset()) {
                    offset = queryRange.getEndOffset();
                }
                if (offset > -1) {
                    this.scrollToRange(TextRange.create((int)offset, (int)offset));
                }
            }
        }
    }

    private static int getOffsetFromErrorMessage(@NotNull DatabaseFamilyId dialect, @NotNull String message, @NotNull String queryText, @NotNull SqlLanguageDialect language, @NotNull Project project) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromErrorMessage"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromErrorMessage"));
        }
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromErrorMessage"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromErrorMessage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromErrorMessage"));
        }
        if (dialect.isPostgres()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bPosition: (\\d+)\\z", -1, -1, 1, message, queryText, null);
        }
        if (dialect.isMysql()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bnear '([^']*)' at line (\\d+)\\z", 1, 2, -1, message, queryText, StringUtil::indexOfIgnoreCase);
        }
        if (dialect.isTransactSql()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bnear '([^']*)'\\.\\z", 1, -1, -1, message, queryText, ConsoleDataRequest.byTokenFinder(language, project, 126));
        }
        if (dialect.isSqlite()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bnear \"([^\"]*)\":", 1, -1, -1, message, queryText, ConsoleDataRequest.byTokenFinder(language, project, Integer.MAX_VALUE));
        }
        if (dialect.isDerby()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bat line (\\d+), column (\\d+)\\.\\z", -1, 1, 2, message, queryText, null);
        }
        if (dialect.isHsqldb()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl(": (.*) : line: (\\d+)\\z", 1, 2, -1, message, queryText, StringUtil::indexOfIgnoreCase);
        }
        return -1;
    }

    private static StringFinder byTokenFinder(@NotNull SqlLanguageDialect dialect, @NotNull Project project, int cropping) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ConsoleDataRequest", "byTokenFinder"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ConsoleDataRequest", "byTokenFinder"));
        }
        return (query, piece, startOffset) -> {
            boolean croppedMode;
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ConsoleDataRequest", "lambda$byTokenFinder$3"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ConsoleDataRequest", "lambda$byTokenFinder$3"));
            }
            ParserDefinition parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.findSingle((Object)dialect);
            if (parser == null) {
                return StringUtil.indexOfIgnoreCase((String)query, (String)piece, (int)startOffset);
            }
            Lexer lexer = parser.createLexer(project);
            lexer.start((CharSequence)query);
            boolean bl = croppedMode = piece.length() > cropping;
            while (lexer.getTokenType() != null) {
                if (lexer.getTokenStart() >= startOffset) {
                    boolean matched;
                    boolean bl2 = matched = croppedMode ? StringUtil.startsWithIgnoreCase((String)lexer.getTokenText(), (String)piece) : lexer.getTokenText().equalsIgnoreCase(piece);
                    if (matched) {
                        return lexer.getTokenStart();
                    }
                }
                lexer.advance();
            }
            return StringUtil.indexOfIgnoreCase((String)query, (String)piece, (int)startOffset);
        };
    }

    private static int getOffsetFromMessageImpl(@NotNull @RegExp String pattern, int groupNear, int groupLine, int groupColumn, @NotNull String message, @NotNull String queryText, @Nullable StringFinder finder) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromMessageImpl"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromMessageImpl"));
        }
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromMessageImpl"));
        }
        Matcher matcher = Pattern.compile(pattern).matcher(message);
        if (matcher.find()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl(queryText, groupNear > 0 ? matcher.group(groupNear) : null, groupLine > 0 ? matcher.group(groupLine) : null, groupColumn > 0 ? matcher.group(groupColumn) : null, finder);
        }
        return -1;
    }

    private static int getOffsetFromMessageImpl(@NotNull String queryText, @Nullable String near, @Nullable String strLine, @Nullable String strColumn, @Nullable StringFinder finder) {
        int offset;
        int column;
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/run/ConsoleDataRequest", "getOffsetFromMessageImpl"));
        }
        int line = strLine == null ? -1 : StringUtil.parseInt((String)strLine, (int)-1);
        int n = column = strColumn == null ? -1 : StringUtil.parseInt((String)strColumn, (int)-1);
        int n2 = strLine == null || line == -1 ? (column < 0 ? -1 : column - 1) : (offset = StringUtil.lineColToOffset((CharSequence)queryText, (int)(line - 1), (int)(column < 0 ? 0 : column - 1)));
        if (line > -1 && column > -1) {
            return offset;
        }
        if (near == null || finder == null) {
            return offset;
        }
        int refined = finder.find(queryText, near, offset);
        return refined == -1 ? offset : refined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrollToRange(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/run/ConsoleDataRequest", "scrollToRange"));
        }
        Editor editor = this.shared.sourceEditor;
        if (editor.isDisposed() || !editor.getContentComponent().isShowing()) {
            return;
        }
        int offset = range.getEndOffset();
        editor.getCaretModel().moveToOffset(offset);
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.disableAnimation();
        try {
            scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        finally {
            scrollingModel.enableAnimation();
        }
        TextRange existing = EditorUtil.getSelectionInAnyMode((Editor)editor);
        if (!existing.containsOffset(offset)) {
            editor.getSelectionModel().setSelection(offset, offset);
        }
    }

    private void updateHighlighting() {
        Project project = this.getConsole().getProject();
        if (!project.isOpen() || this.shared.sourceEditor.isDisposed()) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.shared.sourceEditor.getDocument());
        if (file != null) {
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project).restart(file);
        }
    }

    @Nullable
    public TextRange getRange() {
        return this.shared.adjustedRange(this.queryIndex);
    }

    private ErrorNotificationPanel createErrorNotificationPanel(Editor sourceEditor, Throwable error, Consumer<Decision> feedbackListener) {
        ErrorNotificationPanel.Builder builder = ErrorNotificationPanel.create(null, error, sourceEditor.getContentComponent());
        if (feedbackListener == null) {
            builder.addDetailsButton().addIconLink("config", "/general/settings.png", "Settings", AllIcons.General.Settings, () -> ShowSettingsUtilImpl.showSettingsDialog(null, (String)DatabaseSettingsConfigurable.CONFIGURABLE_ID, (String)""));
        } else {
            builder.addLink("&retry", "<span style=\"text-decoration:underline;\">R</span>etry", () -> feedbackListener.consume((Object)Decision.RETRY)).addLink("&ignore", "<span style=\"text-decoration:underline;\">I</span>gnore", () -> feedbackListener.consume((Object)Decision.IGNORE)).addLink("ignore_&all", "Ignore <span style=\"text-decoration:underline;\">A</span>ll", () -> feedbackListener.consume((Object)Decision.IGNORE_ALL)).addLink("&stop", "<span style=\"text-decoration:underline;\">S</span>top", () -> feedbackListener.consume((Object)Decision.STOP));
        }
        builder.addCloseButton(() -> ConsoleDataRequest.hideErrorPanel(this.shared.sourceEditor));
        ErrorNotificationPanel notificationPanel = builder.build();
        notificationPanel.getContent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TextRange range;
                if (e.getClickCount() == 2 && (range = ConsoleDataRequest.this.getRange()) != null) {
                    ConsoleDataRequest.this.scrollToRange(range);
                    ((ConsoleDataRequest)ConsoleDataRequest.this).shared.sourceEditor.getContentComponent().requestFocusInWindow();
                    ConsoleDataRequest.this.updateHighlighting();
                }
            }
        });
        return notificationPanel;
    }

    public static void hideErrorPanel(@NotNull Editor sourceEditor) {
        if (sourceEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceEditor", "com/intellij/database/run/ConsoleDataRequest", "hideErrorPanel"));
        }
        ErrorPanelInfo epInfo = (ErrorPanelInfo)ERROR_PANEL_KEY.get((UserDataHolder)sourceEditor);
        if (epInfo == null || sourceEditor.getProject() == null) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)sourceEditor.getProject()).getPsiFile(sourceEditor.getDocument());
        if (file == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)sourceEditor.getProject());
        FileEditor fileEditor = editorManager.getSelectedEditor(file.getVirtualFile());
        if (fileEditor != null) {
            editorManager.removeBottomComponent(fileEditor, (JComponent)epInfo.errorPanel);
            ERROR_PANEL_KEY.set((UserDataHolder)sourceEditor, null);
            sourceEditor.getContentComponent().requestFocusInWindow();
        }
    }

    public static class EscapeHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public EscapeHandler(EditorActionHandler originalHandler) {
            this.myOriginalHandler = originalHandler;
        }

        protected void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (this.myOriginalHandler != null && this.myOriginalHandler.isEnabled(editor, caret, dataContext)) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            ConsoleDataRequest.hideErrorPanel(editor);
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/run/ConsoleDataRequest$EscapeHandler", "isEnabledForCaret"));
            }
            if (caret == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/database/run/ConsoleDataRequest$EscapeHandler", "isEnabledForCaret"));
            }
            return ERROR_PANEL_KEY.get((UserDataHolder)editor) != null || this.myOriginalHandler.isEnabled(editor, caret, dataContext);
        }
    }

    public static class ErrorPanelInfo {
        public final ErrorNotificationPanel errorPanel;
        public final Consumer<Decision> decisionConsumer;

        ErrorPanelInfo(@NotNull ErrorNotificationPanel errorPanel, @Nullable Consumer<Decision> decisionConsumer) {
            if (errorPanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPanel", "com/intellij/database/run/ConsoleDataRequest$ErrorPanelInfo", "<init>"));
            }
            this.errorPanel = errorPanel;
            this.decisionConsumer = decisionConsumer;
        }
    }

    @FunctionalInterface
    private static interface StringFinder {
        public int find(@NotNull String var1, @NotNull String var2, int var3);
    }

    private static class Shared
    extends UserDataHolderBase {
        final Editor sourceEditor;
        final ScriptModel<?> scriptModel;
        final DataRequest.Constraints constraints;
        final JBIterator<? extends ScriptModel.StatementIt<?>> queries;
        final List<RangeMarker> rangeMarkers;
        long lastUpdateTime = -1L;
        boolean ignoreAll = false;
        int errCount;
        int errIgnored;

        public Shared(Editor sourceEditor, ScriptModel<?> scriptModel, DataRequest.Constraints constraints) {
            this.queries = JBIterator.from((Iterator)scriptModel.statements().iterator());
            this.sourceEditor = sourceEditor;
            this.scriptModel = scriptModel;
            this.constraints = constraints;
            Document document = sourceEditor.getDocument();
            this.rangeMarkers = scriptModel.statements().transform(it -> {
                TextRange range = it.range().shiftRight((int)it.rangeOffset());
                return range.getEndOffset() <= document.getTextLength() ? document.createRangeMarker(range) : null;
            }).toList();
        }

        @Nullable
        TextRange adjustedRange(int idx) {
            RangeMarker marker = this.rangeMarkers.get(idx);
            return marker != null && marker.isValid() ? TextRange.create((Segment)marker) : null;
        }
    }

    public static enum Decision {
        STOP,
        RETRY,
        IGNORE,
        IGNORE_ALL;

    }
}

