/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.ChooseExtractorAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumpAction
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction", "update"));
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && DumpAction.getDumpSource(e) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction", "actionPerformed"));
        }
        DumpHandler<?> handler = DumpAction.createHandler(e, this.createHelper());
        if (handler == null) {
            return;
        }
        handler.performDump(e.getDataContext());
    }

    @Nullable
    private static DumpHandler<?> createHandler(@NotNull AnActionEvent e, ExtractionHelper manager) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction", "createHandler"));
        }
        Project project = e.getProject();
        Object source = DumpAction.getDumpSource(e);
        if (project == null || source == null) {
            return null;
        }
        return source instanceof JdbcConsole ? DumpAction.createConsoleHandler((JdbcConsole)source, project, manager) : (source instanceof DataGrid ? new DumpHandler.GridHandler(project, (DataGrid)source, manager) : new DumpHandler.DatabaseViewHandler(project, (List)source, manager));
    }

    @Nullable
    private static DumpHandler<?> createConsoleHandler(@NotNull JdbcConsole console, @NotNull Project project, @NotNull ExtractionHelper manager) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/DumpAction", "createConsoleHandler"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/actions/DumpAction", "createConsoleHandler"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/run/actions/DumpAction", "createConsoleHandler"));
        }
        TextRange range = ScriptModelUtil.getSelectedStatementsRange(console);
        ScriptModel subModel = console.getScriptModel().subModel(range, false);
        if (!console.beforeExecuteQueries(subModel)) {
            return null;
        }
        List<String> queries = DumpAction.getQueries(console, project);
        if (queries == null || queries.isEmpty()) {
            return null;
        }
        return new DumpHandler.ConsoleHandler(project, queries, console, manager);
    }

    @Nullable
    public static List<String> getQueries(@NotNull JdbcConsole console, @NotNull Project project) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/DumpAction", "getQueries"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/actions/DumpAction", "getQueries"));
        }
        String text = DumpAction.getQueryText(console);
        if (text == null) {
            return null;
        }
        return DbSqlUtil.getQueries(text, project, (Language)DbSqlUtil.getSqlDialect(DbImplUtil.getDatabaseDialect(console)));
    }

    @Nullable
    public static Object getDumpSource(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction", "getDumpSource"));
        }
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid != null) {
            return dataGrid.isReady() && !dataGrid.isEmpty() && !dataGrid.isEditing() ? dataGrid : null;
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (console != null && editor != null && DumpAction.getQueryText(console) != null) {
            return console;
        }
        Set<DbElement> selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
        List<DbTable> tables = DumpAction.getTables(selection);
        return tables.isEmpty() ? null : tables;
    }

    private static List<DbTable> getTables(Set<DbElement> elements) {
        ArrayList result = ContainerUtil.newArrayList();
        ((JBTreeTraverser)DasUtil.dasTraverser().withRoots(elements)).filter(DbTable.class).filter(DbImplUtil::canConnectTo).forEach(result::add);
        return result;
    }

    @Nullable
    private static String getQueryText(@Nullable JdbcConsole console) {
        if (console == null) {
            return null;
        }
        TextRange range = ScriptModelUtil.getSelectedStatementsRange(console);
        String selected = range.subSequence((CharSequence)console.getLanguageConsole().getEditorDocument().getText()).toString();
        JBIterable parameters = console.getScriptModel().subModel(range, false).parameters();
        return ScriptModelUtil.statementText(console.getPStorage(), parameters, selected, 0);
    }

    @NotNull
    protected abstract ExtractionHelper createHelper();

    public static class FileGroup
    extends ActionGroup
    implements DumbAware {
        public void update(AnActionEvent e) {
            Object source = DumpAction.getDumpSource(e);
            e.getPresentation().setEnabledAndVisible(source != null && e.getProject() != null);
            if (source == null || e.getProject() == null) {
                return;
            }
            if (source instanceof JdbcConsole) {
                FileGroup.updateConsolePresentation((JdbcConsole)source, e);
            } else {
                this.updatePresentation(source, e);
            }
        }

        private static void updateConsolePresentation(@NotNull JdbcConsole console, @NotNull AnActionEvent e) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/DumpAction$FileGroup", "updateConsolePresentation"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction$FileGroup", "updateConsolePresentation"));
            }
            List<String> queries = DumpAction.getQueries(console, (Project)ObjectUtils.assertNotNull((Object)e.getProject()));
            e.getPresentation().setEnabledAndVisible(queries != null);
            if (queries == null) {
                return;
            }
            e.getPresentation().setText(FileGroup.pluralizeInternal("Execute to &File", FileGroup.getSize(queries)));
            e.getPresentation().setIcon(AllIcons.Actions.Execute);
        }

        private void updatePresentation(@NotNull Object target, @NotNull AnActionEvent e) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/run/actions/DumpAction$FileGroup", "updatePresentation"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction$FileGroup", "updatePresentation"));
            }
            e.getPresentation().setText(FileGroup.pluralizeInternal("Dump Data to &File", FileGroup.getSize(target)), true);
            e.getPresentation().setIcon(this.getTemplatePresentation().getIcon());
        }

        @NotNull
        private static String pluralizeInternal(@NotNull String s, int count) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/run/actions/DumpAction$FileGroup", "pluralizeInternal"));
            }
            String string = s + (count > 1 ? "(s)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$FileGroup", "pluralizeInternal"));
            }
            return string;
        }

        private static int getSize(@NotNull Object object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/run/actions/DumpAction$FileGroup", "getSize"));
            }
            return object instanceof List ? ((List)object).size() : 1;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = ChooseExtractorAction.ChooserGroup.getActions((Function<DataExtractorFactory, ? extends AnAction>)((Function)ToFileWithCopyAction::new));
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$FileGroup", "getChildren"));
            }
            return anActionArray;
        }

        private static class ToFileWithCopyAction
        extends ToFile {
            private final DataExtractorFactory myExtractorFactory;

            public ToFileWithCopyAction(@NotNull DataExtractorFactory factory) {
                if (factory == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction", "<init>"));
                }
                this.myExtractorFactory = factory;
                this.getTemplatePresentation().setText(factory.getName());
            }

            @Override
            @NotNull
            protected ExtractionHelper createHelper() {
                ExtractionHelper.FileExtractionHelper fileExtractionHelper = new ExtractionHelper.FileExtractionHelper(){

                    @Override
                    @Nullable
                    public DataExtractorFactory chooseExtractorFactory(@NotNull DataContext context, @NotNull Project project) {
                        if (context == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction$1", "chooseExtractorFactory"));
                        }
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction$1", "chooseExtractorFactory"));
                        }
                        return myExtractorFactory;
                    }
                };
                if (fileExtractionHelper == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction", "createHelper"));
                }
                return fileExtractionHelper;
            }
        }
    }

    public static class ToFile
    extends DumpAction {
        @Override
        @NotNull
        protected ExtractionHelper createHelper() {
            ExtractionHelper.FileExtractionHelper fileExtractionHelper = new ExtractionHelper.FileExtractionHelper();
            if (fileExtractionHelper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$ToFile", "createHelper"));
            }
            return fileExtractionHelper;
        }
    }

    public static class ToClipboard
    extends DumpAction {
        @Override
        @NotNull
        protected ExtractionHelper createHelper() {
            ExtractionHelper.ClipboardExtractionHelper clipboardExtractionHelper = new ExtractionHelper.ClipboardExtractionHelper();
            if (clipboardExtractionHelper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$ToClipboard", "createHelper"));
            }
            return clipboardExtractionHelper;
        }
    }
}

