/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.openapi.Disposable;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridMainPanel
extends JBLoadingPanel {
    private final DataGrid myGrid;

    public GridMainPanel(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/GridMainPanel", "<init>"));
        }
        super((LayoutManager)new BorderLayout(), (Disposable)grid);
        this.myGrid = grid;
    }

    public Color getBackground() {
        return (Color)ObjectUtils.chooseNotNull(this.myGrid != null ? this.myGrid.getColorsScheme().getDefaultBackground() : null, (Object)UIUtil.getTableBackground());
    }

    public void remove(@NotNull Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/database/run/ui/grid/GridMainPanel", "remove"));
        }
        this.getContentPanel().remove(comp);
    }

    @Nullable
    public Component getTopComponent() {
        return this.getComponentAt("North");
    }

    public void setTopComponent(@Nullable Component topComponent) {
        this.replaceComponentAt("North", topComponent);
    }

    @Nullable
    public Component getBottomComponent() {
        return this.getComponentAt("South");
    }

    public void setBottomComponent(@Nullable Component bottomComponent) {
        this.replaceComponentAt("South", bottomComponent);
    }

    private void replaceComponentAt(@NotNull String location, @Nullable Component with) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/database/run/ui/grid/GridMainPanel", "replaceComponentAt"));
        }
        Component toReplace = this.getComponentAt(location);
        if (toReplace != null) {
            this.remove(toReplace);
        }
        if (with != null) {
            this.add(with, location);
        }
        this.getContentPanel().revalidate();
        this.repaint();
    }

    @Nullable
    private Component getComponentAt(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/database/run/ui/grid/GridMainPanel", "getComponentAt"));
        }
        return this.getContentLayout().getLayoutComponent(location);
    }

    @NotNull
    private BorderLayout getContentLayout() {
        BorderLayout borderLayout = (BorderLayout)this.getContentPanel().getLayout();
        if (borderLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMainPanel", "getContentLayout"));
        }
        return borderLayout;
    }
}

