/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableChild;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaExportHelper {
    private static final Key<Boolean> FK_PULLED_MARK = Key.create((String)"SchemaExportHelper.FK_PULLED_MARK");
    private final Map<DasObject, DeObject> myCache;
    private final DatabaseEditorContext myContext;
    private final SchemaExporters myExporter;
    private final DeModel myModel;
    private final DeObject.DeCopier myCopier;
    private final Set<DasObject> myLocked;

    @NotNull
    public DeObject.DeCopier getCopier() {
        DeObject.DeCopier deCopier = this.myCopier;
        if (deCopier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaExportHelper", "getCopier"));
        }
        return deCopier;
    }

    public SchemaExportHelper(@NotNull SchemaExportHelper other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/schemaEditor/SchemaExportHelper", "<init>"));
        }
        this.myCache = ContainerUtil.newHashMap();
        this.myCopier = new DeObject.DeCopier(){

            @Override
            public <De extends DeObject> De copy(@Nullable De object, boolean child) {
                return SchemaExportHelper.this.export(object, child);
            }
        };
        this.myLocked = ContainerUtil.newHashSet();
        this.myContext = other.myContext;
        this.myExporter = other.myExporter;
        this.myModel = new DeModel(other.myModel, this);
    }

    public SchemaExportHelper(@NotNull SchemaExporters exporter, @NotNull DatabaseEditorContext context, @NotNull DasModel model) {
        if (exporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exporter", "com/intellij/database/schemaEditor/SchemaExportHelper", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/SchemaExportHelper", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/SchemaExportHelper", "<init>"));
        }
        this.myCache = ContainerUtil.newHashMap();
        this.myCopier = new /* invalid duplicate definition of identical inner class */;
        this.myLocked = ContainerUtil.newHashSet();
        this.myContext = context;
        this.myExporter = exporter;
        this.myModel = new DeModel(model, this);
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myContext;
        if (databaseEditorContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaExportHelper", "getContext"));
        }
        return databaseEditorContext;
    }

    @NotNull
    public SchemaExportHelper chained() {
        SchemaExportHelper schemaExportHelper = new SchemaExportHelper(this);
        if (schemaExportHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaExportHelper", "chained"));
        }
        return schemaExportHelper;
    }

    @NotNull
    public DeModel getModel() {
        DeModel deModel = this.myModel;
        if (deModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/SchemaExportHelper", "getModel"));
        }
        return deModel;
    }

    public boolean contains(@NotNull DasObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/SchemaExportHelper", "contains"));
        }
        return this.myCache.containsKey(obj);
    }

    public boolean canExport(@NotNull DasObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/SchemaExportHelper", "canExport"));
        }
        return this.myExporter.get(object) != null;
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    public <De extends DeObject> De export(@Nullable DasObject object, boolean withChildren) {
        if (object == null) {
            return null;
        }
        DeObject res = this.myCache.get(object);
        if (!(res == null || withChildren && res.lightExported)) {
            return (De)res;
        }
        SchemaExporters.Exporter<? extends DeObject, DasObject> exporter = this.myExporter.get(object);
        assert (exporter != null) : "No exporter for " + object.getClass().getName();
        if (res == null) {
            boolean wasFree = this.myLocked.add(object);
            assert (wasFree);
            assert (!(object instanceof DeObject) || ((DeObject)object).model != this.myModel);
            res = exporter.create(this, object);
            this.myLocked.remove(object);
            this.created(object, res);
            res.lightExported = true;
            exporter.lightExport(this, res, object);
            if (res.getParent() != null && res.getParent().lightExported) {
                res.getParent().addLightChild(res);
            }
        }
        if (withChildren && res.lightExported) {
            res.lightChildren = null;
            res.lightExported = false;
            exporter.exportChildren(this, res, object);
        }
        return (De)res;
    }

    protected void created(@NotNull DasObject object, @NotNull DeObject res) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/SchemaExportHelper", "created"));
        }
        if (res == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "res", "com/intellij/database/schemaEditor/SchemaExportHelper", "created"));
        }
        this.myCache.put(object, res);
    }

    public <De extends DeObject> De exportDeep(@NotNull DasModel model, @NotNull DasObject object, boolean withChildren) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/SchemaExportHelper", "exportDeep"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/SchemaExportHelper", "exportDeep"));
        }
        return (De)((DeObject)this.exportDeep(model, (Iterable<? extends DasObject>)JBIterable.of((Object)object), withChildren).first());
    }

    public <De extends DeObject> JBIterable<De> exportDeep(@NotNull DasModel model, @NotNull Iterable<? extends DasObject> objects, final boolean withChildren) {
        JBIterable<De> unexported;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/SchemaExportHelper", "exportDeep"));
        }
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/schemaEditor/SchemaExportHelper", "exportDeep"));
        }
        if (model == this.myModel) {
            return JBIterable.from(objects).transform(f -> (DeObject)f);
        }
        DasModel subModel = this.myModel.getModel();
        if (subModel != model) {
            assert (subModel instanceof DeModel);
            unexported = ((DeModel)subModel).getExportHelper().exportDeep(model, objects, withChildren);
        } else {
            unexported = JBIterable.from(objects);
        }
        return unexported.transform(new Function<DasObject, De>(){

            public De fun(DasObject object) {
                return SchemaExportHelper.this.export(object, withChildren);
            }
        });
    }

    public <De extends DeObject> JBIterable<De> findExportDeep(@NotNull Condition<DasObject> condition, final boolean withChildren) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/schemaEditor/SchemaExportHelper", "findExportDeep"));
        }
        DasModel model = this.myModel.getModel();
        JBIterable unexported = model instanceof DeModel ? ((DeModel)model).getExportHelper().findExportDeep(condition, withChildren) : ((JBTreeTraverser)model.traverser().filter(condition)).bfsTraversal();
        return unexported.transform(new Function<DasObject, De>(){

            public De fun(DasObject object) {
                return SchemaExportHelper.this.export(object, withChildren);
            }
        });
    }

    public void pullDependencies(@Nullable DasObject baseTarget) {
        Object obj = this.export(baseTarget, false);
        DeTable target = (DeTable)ObjectUtils.tryCast(obj, DeTable.class);
        if (target == null) {
            DeTableChild child = (DeTableChild)ObjectUtils.tryCast(obj, DeTableChild.class);
            DeTable deTable = target = child == null ? null : child.table;
        }
        if (target == null) {
            return;
        }
        if (FK_PULLED_MARK.get(target.flags) == Boolean.TRUE) {
            return;
        }
        target.model.getExportedKeys(target).size();
        FK_PULLED_MARK.set(target.flags, (Object)Boolean.TRUE);
    }
}

