/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeObject
implements DasObject {
    @NotNull
    public String name;
    @NotNull
    public DeModel model;
    @Nullable
    public String comment;
    @Nullable
    public DasObject editedObject;
    public boolean lightExported;
    public Set<DeObject> lightChildren;
    public final Map<Key, Object> additional;
    public final transient Map<Key, Object> flags;

    protected DeObject(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeObject", "<init>"));
        }
        this.name = "";
        this.lightChildren = null;
        this.additional = ContainerUtil.newHashMap();
        this.flags = ContainerUtil.newHashMap();
        this.model = model;
    }

    public DeObject(@NotNull String name, @NotNull DeModel model) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/schemaEditor/model/DeObject", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeObject", "<init>"));
        }
        this.name = "";
        this.lightChildren = null;
        this.additional = ContainerUtil.newHashMap();
        this.flags = ContainerUtil.newHashMap();
        this.name = name;
        this.model = model;
    }

    @NotNull
    public abstract DeObject emptyClone(@NotNull DeModel var1);

    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj, boolean withChildren, @NotNull DeCopier copier) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/model/DeObject", "copyFrom"));
        }
        if (copier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copier", "com/intellij/database/schemaEditor/model/DeObject", "copyFrom"));
        }
        this.name = obj.name;
        this.comment = obj.comment;
        this.editedObject = obj.editedObject;
        this.lightExported = true;
        if (withChildren) {
            this.copyChildrenFrom(obj, copier);
        }
        DeObject deObject = this;
        if (deObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeObject", "copyFrom"));
        }
        return deObject;
    }

    @NotNull
    public static <De extends DeObject> De copy(@NotNull De obj, boolean withChildren, @NotNull DeCopier copier) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/model/DeObject", "copy"));
        }
        if (copier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copier", "com/intellij/database/schemaEditor/model/DeObject", "copy"));
        }
        De De = copier.copy(obj, withChildren);
        if (De == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeObject", "copy"));
        }
        return De;
    }

    public void copyChildrenFrom(@NotNull DeObject obj, @NotNull DeCopier copier) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/model/DeObject", "copyChildrenFrom"));
        }
        if (copier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copier", "com/intellij/database/schemaEditor/model/DeObject", "copyChildrenFrom"));
        }
        this.lightExported = false;
    }

    @NotNull
    public JBIterable<DeObject> getChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeObject", "getChildren"));
        }
        return jBIterable;
    }

    @Nullable
    public abstract DeObject getParent();

    @NotNull
    public JBIterable<DeObject> getLightChildren() {
        JBIterable jBIterable = JBIterable.from(this.lightChildren);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeObject", "getLightChildren"));
        }
        return jBIterable;
    }

    public void addLightChild(@NotNull DeObject child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/schemaEditor/model/DeObject", "addLightChild"));
        }
        if (this.lightChildren == null) {
            this.lightChildren = ContainerUtil.newLinkedHashSet();
        }
        this.lightChildren.add(child);
    }

    public final boolean isAltered(@NotNull DeObject other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/schemaEditor/model/DeObject", "isAltered"));
        }
        return this.isAlteredIgnoringChild(other, Collections.emptySet(), Collections.emptySet());
    }

    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children, @NotNull Collection<? extends DasObject> otherChildren) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/schemaEditor/model/DeObject", "isAlteredIgnoringChild"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/database/schemaEditor/model/DeObject", "isAlteredIgnoringChild"));
        }
        if (otherChildren == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherChildren", "com/intellij/database/schemaEditor/model/DeObject", "isAlteredIgnoringChild"));
        }
        return !this.name.equals(other.name) || !Comparing.equal((String)this.comment, (String)other.comment) || !ContainerUtil.diff(this.additional, other.additional).isEmpty();
    }

    public String toString() {
        return this.name + "(" + this.getClass().getSimpleName() + ")";
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeObject", "getName"));
        }
        return string;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Nullable
    public DasObject getDbParent() {
        return this.getParent();
    }

    @NotNull
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/schemaEditor/model/DeObject", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/schemaEditor/model/DeObject", "getDbChildren"));
        }
        if (!this.lightExported) {
            JBIterable jBIterable = this.getChildren().filter(clazz).filter(DasUtil.byKind((ObjectKind)kind));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeObject", "getDbChildren"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = this.getLightChildren().filter(clazz).filter(DasUtil.byKind((ObjectKind)kind));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeObject", "getDbChildren"));
        }
        return jBIterable;
    }

    public short getPosition() {
        return this.editedObject instanceof DasPositioned ? ((DasPositioned)this.editedObject).getPosition() : (short)0;
    }

    @NotNull
    public String getDisplayOrder() {
        String string = this.editedObject instanceof DasPositioned ? ((DasPositioned)this.editedObject).getDisplayOrder() : DasUtil.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeObject", "getDisplayOrder"));
        }
        return string;
    }

    public static abstract class DeCopier {
        public static final DeCopier SHALLOW = new DeCopier(){

            @Override
            public <De extends DeObject> De copy(@Nullable De object, boolean child) {
                return object;
            }
        };

        @Contract(value="null, _ -> null; !null, _ -> !null")
        public abstract <De extends DeObject> De copy(De var1, boolean var2);

        public static DeCopier onlySelected(final DeObject ... objects) {
            if (objects == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/schemaEditor/model/DeObject$DeCopier", "onlySelected"));
            }
            return new DeConditionCopier(){

                @Override
                protected boolean condition(@Nullable DeObject obj) {
                    return ArrayUtil.contains((Object)obj, (Object[])objects);
                }
            };
        }

        public static DeCopier deepSubTree(final @NotNull DeObject root2) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/schemaEditor/model/DeObject$DeCopier", "deepSubTree"));
            }
            return new DeConditionCopier(){

                @Override
                protected boolean condition(@Nullable DeObject obj) {
                    while (obj != null) {
                        if (obj == root2) {
                            return true;
                        }
                        obj = obj.getParent();
                    }
                    return false;
                }
            };
        }

        public static DeCopier exportExisting(final @NotNull DeModel model, final @NotNull DasModel targetModel) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeObject$DeCopier", "exportExisting"));
            }
            if (targetModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetModel", "com/intellij/database/schemaEditor/model/DeObject$DeCopier", "exportExisting"));
            }
            return new DeCopier(){

                @Override
                public <De extends DeObject> De copy(De object, boolean child) {
                    if (object == null) {
                        return null;
                    }
                    if (object.editedObject == null) {
                        return DeObject.copy(object, child, this);
                    }
                    return model.getExportHelper().exportDeep(targetModel, object.editedObject, true);
                }
            };
        }

        public static abstract class DeConditionCopier
        extends DeCopier {
            private final Map<DeObject, DeObject> myCache = ContainerUtil.newHashMap();

            @Override
            public <De extends DeObject> De copy(@Nullable De object, boolean child) {
                if (object == null) {
                    return null;
                }
                DeObject res = this.myCache.get(object);
                if (res == null) {
                    if (!this.condition(object)) {
                        return object;
                    }
                    res = object.emptyClone(object.model);
                    this.myCache.put(object, res);
                    res.copyFrom(object, child, this);
                }
                return (De)res;
            }

            protected abstract boolean condition(@Nullable DeObject var1);
        }
    }
}

