/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.coding.CodeTextBuilder;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.mssql.MsDatabase;
import com.intellij.database.model.mssql.MsModel;
import com.intellij.database.model.mssql.MsSchema;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.MsScriptingService$WhenMappings;
import com.intellij.database.scripting.ScriptingPreferences;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.TsqlScriptingService;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u000fB\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\n\u001a\u00180\u000bR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/scripting/MsScriptingService;", "Lcom/intellij/database/scripting/TsqlScriptingService;", "Lcom/intellij/database/model/mssql/MsModel;", "Lcom/intellij/database/model/mssql/MsDatabase;", "Lcom/intellij/database/model/mssql/MsSchema;", "model", "database", "prefs", "Lcom/intellij/database/scripting/ScriptingPreferences;", "(Lcom/intellij/database/model/mssql/MsModel;Lcom/intellij/database/model/mssql/MsDatabase;Lcom/intellij/database/scripting/ScriptingPreferences;)V", "createGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "MsCreatingGenerator", "database-scripting"})
public final class MsScriptingService
extends TsqlScriptingService<MsModel, MsDatabase, MsSchema> {
    @Override
    @NotNull
    protected AbstractScriptingService.CodeGenerator createGenerator(@NotNull ScriptingTask task) {
        AbstractScriptingService.CodeGenerator codeGenerator;
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        switch (MsScriptingService$WhenMappings.$EnumSwitchMapping$0[task.ordinal()]) {
            case 1: {
                codeGenerator = new MsCreatingGenerator(task);
                break;
            }
            default: {
                codeGenerator = new AbstractScriptingService.StupidGenerator(task);
            }
        }
        return codeGenerator;
    }

    public MsScriptingService(@NotNull MsModel model, @NotNull MsDatabase database, @NotNull ScriptingPreferences prefs) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"prefs");
        super((BasicModel)model, (BasicDatabase)database, prefs);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0014J\n\u0010\u0015\u001a\u00020\u0014*\u00020\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/scripting/MsScriptingService$MsCreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/mssql/MsModel;", "Lcom/intellij/database/model/mssql/MsDatabase;", "Lcom/intellij/database/model/mssql/MsSchema;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/MsScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateColumnComment", "", "column", "Lcom/intellij/database/model/basic/BasicColumn;", "generateComment", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateTableComment", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "makeColumnSpecification", "", "quoteNameAsString", "database-scripting"})
    private final class MsCreatingGenerator
    extends AbstractScriptingService.CreatingGenerator {
        @Override
        @Nullable
        protected String makeColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            String s = super.makeColumnSpecification(column);
            SequenceIdentity q = column.getSequenceIdentity();
            if (q != null) {
                String identityClause = Intrinsics.areEqual((Object)q.min, (Object)BigInteger.ONE) && Intrinsics.areEqual((Object)q.increment, (Object)BigInteger.ONE) ? " identity" : " identity(" + q.min + ", " + q.increment + ")";
                s = Intrinsics.stringPlus((String)s, (Object)identityClause);
            }
            return s;
        }

        @Override
        protected void generateComment(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof BasicLikeTable) {
                this.generateTableComment((BasicLikeTable)element);
            } else if (basicElement instanceof BasicColumn) {
                this.generateColumnComment((BasicColumn)element);
            }
        }

        public final void generateTableComment(@NotNull BasicLikeTable table) {
            String string;
            ObjectKind kind;
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            String string2 = table.getName();
            if (string2 == null || (string2 = this.quoteNameAsString(string2)) == null) {
                return;
            }
            String name = string2;
            String string3 = table.getComment();
            if (string3 == null || (string3 = this.quoteNameAsString(string3)) == null) {
                return;
            }
            String comment = string3;
            ObjectKind objectKind = kind = table.getKind();
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
                string = "TABLE";
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
                string = "VIEW";
            } else {
                return;
            }
            String tableWord = string;
            String s = StringsKt.trimMargin$default((String)("\n" + "              |declare @sn nvarchar(30)" + "\n" + "              |set @sn = schema_name()" + "\n" + "              |execute sp_addextendedproperty N'MS_Description', N" + comment + ", N'SCHEMA', @sn, N'" + tableWord + "', N" + name + "\n" + "              "), null, (int)1, null);
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
                final /* synthetic */ MsCreatingGenerator this$0;
                final /* synthetic */ String $s;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$s, null, false, 6, null);
                }
                {
                    this.this$0 = msCreatingGenerator;
                    this.$s = string;
                    super(0);
                }
            }, 3, null);
        }

        public final void generateColumnComment(@NotNull BasicColumn column) {
            String string;
            ObjectKind kind;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            BasicLikeTable basicLikeTable = column.getTable();
            if (basicLikeTable == null) {
                return;
            }
            BasicLikeTable table = basicLikeTable;
            String string2 = table.getRealName();
            if (string2 == null || (string2 = this.quoteNameAsString(string2)) == null) {
                return;
            }
            String tableName = string2;
            String string3 = column.getRealName();
            if (string3 == null || (string3 = this.quoteNameAsString(string3)) == null) {
                return;
            }
            String columnName = string3;
            String string4 = column.getComment();
            if (string4 == null || (string4 = this.quoteNameAsString(string4)) == null) {
                return;
            }
            String comment = string4;
            ObjectKind objectKind = kind = table.getKind();
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
                string = "TABLE";
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
                string = "VIEW";
            } else {
                return;
            }
            String tableWord = string;
            String s = StringsKt.trimMargin$default((String)("\n" + "              |declare @sn nvarchar(30)" + "\n" + "              |set @sn = schema_name()" + "\n" + "              |execute sp_addextendedproperty N'MS_Description', N" + comment + ", N'SCHEMA', @sn, N'" + tableWord + "', N" + tableName + ", N'COLUMN', N" + columnName + "\n" + "              "), null, (int)1, null);
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
                final /* synthetic */ MsCreatingGenerator this$0;
                final /* synthetic */ String $s;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$s, null, false, 6, null);
                }
                {
                    this.this$0 = msCreatingGenerator;
                    this.$s = string;
                    super(0);
                }
            }, 3, null);
        }

        @NotNull
        public final String quoteNameAsString(@NotNull String $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return "'" + StringsKt.replace$default((String)$receiver, (String)"'", (String)"''", (boolean)false, (int)4, null) + "'";
        }

        public MsCreatingGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
        }
    }
}

