/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.coding.CodeTextBuilder;
import com.intellij.coding.CompositeText;
import com.intellij.database.model.DataType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.mysql.MysqlArgument;
import com.intellij.database.model.mysql.MysqlModel;
import com.intellij.database.model.mysql.MysqlRoot;
import com.intellij.database.model.mysql.MysqlRoutine;
import com.intellij.database.model.mysql.MysqlSchema;
import com.intellij.database.model.mysql.MysqlTable;
import com.intellij.database.model.mysql.MysqlTrigger;
import com.intellij.database.model.mysql.MysqlView;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.MysqlNamingService;
import com.intellij.database.scripting.MysqlScriptingService$WhenMappings;
import com.intellij.database.scripting.ScriptingPreferences;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0016B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\u000f\u001a\u00180\u0010R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\r\u0010\u0013\u001a\u00020\u0014H\u0010\u00a2\u0006\u0002\b\u0015R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/scripting/MysqlScriptingService;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/mysql/MysqlModel;", "Lcom/intellij/database/model/mysql/MysqlRoot;", "Lcom/intellij/database/model/mysql/MysqlSchema;", "model", "prefs", "Lcom/intellij/database/scripting/ScriptingPreferences;", "(Lcom/intellij/database/model/mysql/MysqlModel;Lcom/intellij/database/scripting/ScriptingPreferences;)V", "defaultPrimitiveSizes", "", "", "Lcom/intellij/database/scripting/AbstractScriptingService$SizeAndScale;", "getDefaultPrimitiveSizes", "()Ljava/util/Map;", "createGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "init", "", "init$database_scripting", "MysqlCreatingGenerator", "database-scripting"})
public final class MysqlScriptingService
extends AbstractScriptingService<MysqlModel, MysqlRoot, MysqlSchema> {
    @NotNull
    private final Map<String, AbstractScriptingService.SizeAndScale> defaultPrimitiveSizes;

    @Override
    public void init$database_scripting() {
        super.init$database_scripting();
        this.setNaming(MysqlNamingService.INSTANCE);
    }

    @Override
    @NotNull
    protected Map<String, AbstractScriptingService.SizeAndScale> getDefaultPrimitiveSizes() {
        return this.defaultPrimitiveSizes;
    }

    @Override
    @NotNull
    protected AbstractScriptingService.CodeGenerator createGenerator(@NotNull ScriptingTask task) {
        AbstractScriptingService.CodeGenerator codeGenerator;
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        switch (MysqlScriptingService$WhenMappings.$EnumSwitchMapping$0[task.ordinal()]) {
            case 1: {
                codeGenerator = new MysqlCreatingGenerator(task);
                break;
            }
            default: {
                codeGenerator = new AbstractScriptingService.StupidGenerator(task);
            }
        }
        return codeGenerator;
    }

    public MysqlScriptingService(@NotNull MysqlModel model, @NotNull ScriptingPreferences prefs) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"prefs");
        BasicModel basicModel = model;
        MysqlRoot mysqlRoot = model.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)mysqlRoot, (String)"model.root");
        super(basicModel, (BasicDatabase)mysqlRoot, prefs);
        this.defaultPrimitiveSizes = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"char", (Object)new AbstractScriptingService.SizeAndScale(1, 0, 2, null)), TuplesKt.to((Object)"boolean", (Object)new AbstractScriptingService.SizeAndScale(1, 0, 2, null)), TuplesKt.to((Object)"bit", (Object)new AbstractScriptingService.SizeAndScale(1, 0, 2, null)), TuplesKt.to((Object)"tinyint", (Object)new AbstractScriptingService.SizeAndScale(4, 0, 2, null)), TuplesKt.to((Object)"smallint", (Object)new AbstractScriptingService.SizeAndScale(5, 0, 2, null)), TuplesKt.to((Object)"mediumint", (Object)new AbstractScriptingService.SizeAndScale(9, 0, 2, null)), TuplesKt.to((Object)"int", (Object)new AbstractScriptingService.SizeAndScale(11, 0, 2, null)), TuplesKt.to((Object)"bigint", (Object)new AbstractScriptingService.SizeAndScale(20, 0, 2, null)), TuplesKt.to((Object)"decimal", (Object)new AbstractScriptingService.SizeAndScale(10, 0, 2, null)), TuplesKt.to((Object)"year", (Object)new AbstractScriptingService.SizeAndScale(4, 0, 2, null))});
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\u0012\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014\u00a8\u0006!"}, d2={"Lcom/intellij/database/scripting/MysqlScriptingService$MysqlCreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/mysql/MysqlModel;", "Lcom/intellij/database/model/mysql/MysqlRoot;", "Lcom/intellij/database/model/mysql/MysqlSchema;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/MysqlScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "argDataType", "", "arg", "Lcom/intellij/database/model/basic/BasicArgument;", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateRoutine", "routine", "Lcom/intellij/database/model/mysql/MysqlRoutine;", "generateTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateView", "view", "Lcom/intellij/database/model/mysql/MysqlView;", "getSingleColumnElements", "", "column", "Lcom/intellij/database/model/basic/BasicColumn;", "isNullExplicit", "", "makeNormalColumnSpecification", "database-scripting"})
    private final class MysqlCreatingGenerator
    extends AbstractScriptingService.CreatingGenerator {
        @Override
        protected boolean isNullExplicit() {
            return true;
        }

        @Override
        @NotNull
        protected Iterable<BasicElement> getSingleColumnElements(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            BasicLikeTable basicLikeTable = column.getTable();
            if (basicLikeTable == null) {
                return SetsKt.emptySet();
            }
            BasicLikeTable table = basicLikeTable;
            JBIterable jBIterable = table.getDbChildren(BasicKey.class, null).filter((Condition)new Condition<BasicKey>(this, column){
                final /* synthetic */ MysqlCreatingGenerator this$0;
                final /* synthetic */ BasicColumn $column;

                public final boolean value(BasicKey it) {
                    BasicKey basicKey = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicKey, (String)"it");
                    return this.this$0.canCreateInColumn(basicKey) && it.isNameSurrogate() && it.getColNames().size() == 1 && Intrinsics.areEqual((Object)((String)CollectionsKt.first(it.getColNames())), (Object)this.$column.getName());
                }
                {
                    this.this$0 = mysqlCreatingGenerator;
                    this.$column = basicColumn;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"table.getDbChildren(Basi\u2026s.first() == column.name}");
            return (Iterable)jBIterable;
        }

        @Override
        @Nullable
        protected String makeNormalColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            String string = super.makeNormalColumnSpecification(column);
            if (string == null) {
                return null;
            }
            String s = string;
            SequenceIdentity si = column.getSequenceIdentity();
            if (si != null) {
                s = s + " auto_increment";
            }
            return s;
        }

        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof MysqlView) {
                this.generateView((MysqlView)element);
            } else if (basicElement instanceof MysqlRoutine) {
                this.generateRoutine((MysqlRoutine)element);
            } else {
                super.generateElement(element);
            }
        }

        private final String argDataType(BasicArgument arg) {
            String string;
            if (arg == null) {
                string = "/*none*/";
            } else {
                DataType dataType = arg.getDataType();
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"arg.dataType");
                string = MysqlScriptingService.this.script(dataType);
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final void generateRoutine(MysqlRoutine routine2) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            boolean isFunction = routine2.getReturnArgument() != null;
            Iterable iterable = $receiver$iv = routine2.getArguments();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                MysqlArgument it = (MysqlArgument)element$iv$iv;
                if (!(!it.getArgumentDirection().isReturnOrResult())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String params2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, (Function1)((Function1)new Function1<MysqlArgument, String>(this, isFunction){
                final /* synthetic */ MysqlCreatingGenerator this$0;
                final /* synthetic */ boolean $isFunction;

                @NotNull
                public final String invoke(MysqlArgument p) {
                    StringBuilder stringBuilder = new StringBuilder().append(this.$isFunction ? "" : p.getArgumentDirection().name() + " ");
                    StringBuilder stringBuilder2 = new StringBuilder().append(this.this$0.MysqlScriptingService.this.getScr(p.getName())).append(" ");
                    MysqlScriptingService mysqlScriptingService = this.this$0.MysqlScriptingService.this;
                    DataType dataType = p.getDataType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"p.dataType");
                    return stringBuilder.append(stringBuilder2.append(mysqlScriptingService.script(dataType)).toString()).toString();
                }
                {
                    this.this$0 = mysqlCreatingGenerator;
                    this.$isFunction = bl;
                    super(1);
                }
            }), (int)31, null);
            String routineType = isFunction ? "function" : "procedure";
            String returns = isFunction ? "returns " + this.argDataType(routine2.getReturnArgument()) : "";
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, routineType, routine2, params2, returns){
                final /* synthetic */ MysqlCreatingGenerator this$0;
                final /* synthetic */ String $routineType;
                final /* synthetic */ MysqlRoutine $routine;
                final /* synthetic */ String $params;
                final /* synthetic */ String $returns;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create " + this.$routineType + " " + this.this$0.MysqlScriptingService.this.currentScopeName(this.$routine) + " (" + this.$params + ") " + this.$returns + " ", null, false, 6, null);
                    CompositeText compositeText = this.$routine.getSourceText();
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), compositeText != null ? compositeText.getContent() : null, false, 2, null);
                }
                {
                    this.this$0 = mysqlCreatingGenerator;
                    this.$routineType = string;
                    this.$routine = mysqlRoutine;
                    this.$params = string2;
                    this.$returns = string3;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateTrigger(@NotNull BasicTrigger trigger2) {
            Intrinsics.checkParameterIsNotNull((Object)trigger2, (String)"trigger");
            if (!(trigger2 instanceof MysqlTrigger)) {
                super.generateTrigger(trigger2);
                return;
            }
            String event = ((TrigEvent)((Object)CollectionsKt.first((Iterable)((MysqlTrigger)trigger2).getEvents()))).name();
            String turn = Intrinsics.areEqual((Object)((Object)((MysqlTrigger)trigger2).getTurn()), (Object)((Object)TrigTurn.BEFORE_ROW)) ? "before" : "after";
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger2, turn, event){
                final /* synthetic */ MysqlCreatingGenerator this$0;
                final /* synthetic */ BasicTrigger $trigger;
                final /* synthetic */ String $turn;
                final /* synthetic */ String $event;

                public final void invoke() {
                    MysqlTable mysqlTable = ((MysqlTrigger)this.$trigger).getTable();
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create trigger " + this.this$0.MysqlScriptingService.this.currentScopeName((BasicSchemaObject)((Object)this.$trigger)) + "\n" + "             " + this.$turn + " " + this.$event + " on " + (mysqlTable != null ? this.this$0.MysqlScriptingService.this.currentScopeName(mysqlTable) : null) + "\n" + "             for each row", null, false, 6, null);
                    CompositeText compositeText = ((MysqlTrigger)this.$trigger).getSourceText();
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), compositeText != null ? compositeText.getContent() : null, false, 2, null);
                }
                {
                    this.this$0 = mysqlCreatingGenerator;
                    this.$trigger = basicTrigger;
                    this.$turn = string;
                    this.$event = string2;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateView(MysqlView view2) {
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view2){
                final /* synthetic */ MysqlCreatingGenerator this$0;
                final /* synthetic */ MysqlView $view;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create view " + this.this$0.MysqlScriptingService.this.currentScopeName(this.$view) + " as ", null, false, 6, null);
                    CompositeText compositeText = this.$view.getSourceText();
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), compositeText != null ? compositeText.getContent() : null, false, 2, null);
                }
                {
                    this.this$0 = mysqlCreatingGenerator;
                    this.$view = mysqlView;
                    super(0);
                }
            }, 3, null);
        }

        public MysqlCreatingGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
        }
    }
}

