/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.coding.CodeTextBuilder;
import com.intellij.coding.CompositeText;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.oracle.OraBody;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.oracle.OraClusterColumn;
import com.intellij.database.model.oracle.OraClusterIndex;
import com.intellij.database.model.oracle.OraCollectionType;
import com.intellij.database.model.oracle.OraModel;
import com.intellij.database.model.oracle.OraModule;
import com.intellij.database.model.oracle.OraRoot;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.oracle.OraTrigger;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.OraNamingService;
import com.intellij.database.scripting.OraScriptingService;
import com.intellij.database.scripting.OraScriptingService$WhenMappings;
import com.intellij.database.scripting.ScriptingPreferences;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0017B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\r\u001a\u00180\u000eR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\r\u0010\u0011\u001a\u00020\u0012H\u0010\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/scripting/OraScriptingService;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/oracle/OraModel;", "Lcom/intellij/database/model/oracle/OraRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "model", "prefs", "Lcom/intellij/database/scripting/ScriptingPreferences;", "(Lcom/intellij/database/model/oracle/OraModel;Lcom/intellij/database/scripting/ScriptingPreferences;)V", "statementDelimiter", "", "getStatementDelimiter", "()Ljava/lang/String;", "createGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "init", "", "init$database_scripting", "script", "d", "Lcom/intellij/database/model/DataType;", "OraCreatingGenerator", "database-scripting"})
public final class OraScriptingService
extends AbstractScriptingService<OraModel, OraRoot, OraSchema> {
    @Override
    public void init$database_scripting() {
        super.init$database_scripting();
        this.setNaming(OraNamingService.INSTANCE);
    }

    @Override
    @NotNull
    public String getStatementDelimiter() {
        return "/";
    }

    @Override
    @NotNull
    protected String script(@NotNull DataType d) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        if (d.getPrecision() == 0x7FFFFFFE && d.scale == 0 && !d.custom) {
            String string2 = d.typeName;
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"d.typeName");
        } else if (d.size == 1 && Intrinsics.areEqual((Object)d.typeName, (Object)"CHAR") && !d.sizeUnitExplicit && !d.custom) {
            String string3 = d.typeName;
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"d.typeName");
        } else {
            String string4 = d.getSpecification();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"d.specification");
        }
        return string;
    }

    @Override
    @NotNull
    protected AbstractScriptingService.CodeGenerator createGenerator(@NotNull ScriptingTask task) {
        AbstractScriptingService.CodeGenerator codeGenerator;
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        switch (OraScriptingService$WhenMappings.$EnumSwitchMapping$0[task.ordinal()]) {
            case 1: {
                codeGenerator = new OraCreatingGenerator(task);
                break;
            }
            default: {
                codeGenerator = new AbstractScriptingService.StupidGenerator(task);
            }
        }
        return codeGenerator;
    }

    public OraScriptingService(@NotNull OraModel model, @NotNull ScriptingPreferences prefs) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"prefs");
        BasicModel basicModel = model;
        OraRoot oraRoot = model.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)oraRoot, (String)"model.root");
        super(basicModel, (BasicDatabase)oraRoot, prefs);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u001eH\u0014\u00a8\u0006$"}, d2={"Lcom/intellij/database/scripting/OraScriptingService$OraCreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/oracle/OraModel;", "Lcom/intellij/database/model/oracle/OraRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/OraScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateCluster", "", "cluster", "Lcom/intellij/database/model/oracle/OraCluster;", "generateCollectionType", "col", "Lcom/intellij/database/model/oracle/OraCollectionType;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateModule", "module", "Lcom/intellij/database/model/oracle/OraModule;", "generateObjectTable", "table", "Lcom/intellij/database/model/oracle/OraTable;", "generatePublicSynonym", "synonym", "Lcom/intellij/database/model/basic/BasicSynonym;", "generateSynonym", "generateTable", "Lcom/intellij/database/model/basic/BasicTable;", "generateTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "database-scripting"})
    private final class OraCreatingGenerator
    extends AbstractScriptingService.CreatingGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof OraCluster) {
                this.generateCluster((OraCluster)element);
            } else if (basicElement instanceof OraModule) {
                this.generateModule((OraModule)element);
            } else if (basicElement instanceof OraCollectionType) {
                this.generateCollectionType((OraCollectionType)element);
            } else {
                super.generateElement(element);
            }
        }

        @Override
        protected void generateTable(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            if (table instanceof OraTable && ((OraTable)table).getRowTypeObjectName() != null) {
                BasicTable basicTable = table;
                if (basicTable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraTable");
                }
                this.generateObjectTable((OraTable)basicTable);
            } else {
                super.generateTable(table);
            }
        }

        private final void generateObjectTable(OraTable table) {
            String objectSchemaName = table.getRowTypeSchemaName();
            if (Intrinsics.areEqual((Object)objectSchemaName, (Object)table.getSchemaName())) {
                objectSchemaName = null;
            }
            String string = table.getRowTypeObjectName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String objectName = string;
            String n = objectSchemaName == null ? OraScriptingService.this.getScr(objectName) : OraScriptingService.this.getScr(objectSchemaName) + '.' + OraScriptingService.this.getScr(objectName);
            String s = "create table " + table.getName() + " of " + n;
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $s;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$s, null, false, 6, null);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$s = string;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateCluster(OraCluster cluster) {
            String name = OraScriptingService.this.getScr(cluster.getName());
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name, cluster){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ OraCluster $cluster;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create cluster " + this.$name, null, false, 6, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "(", null, false, 6, null);
                    AbstractScriptingService.CodeGenerator.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateCluster.1 this$0;

                        public final void invoke() {
                            for (OraClusterColumn oraClusterColumn : this.this$0.$cluster.getColumns()) {
                                String name1 = this.this$0.this$0.OraScriptingService.this.getScr(oraClusterColumn.getName());
                                String type1 = oraClusterColumn.getDataType().getSpecification();
                                CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), name1 + " " + type1 + ",", null, false, 6, null);
                            }
                            this.this$0.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }, 1, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, 6, null);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (this.$cluster.getBlockSize() > 0) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "size " + this.$cluster.getBlockSize(), null, false, 6, null);
                        }
                        String singleTableClause = this.$cluster.isSingleTable() ? "single table" : null;
                        String cardinalityClause = this.$cluster.getHashCardinality() != 0 ? "hashkeys " + this.$cluster.getHashCardinality() : null;
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), ScriptingUtilsKt.concatWithSpace(singleTableClause, cardinalityClause), null, false, 6, null);
                        if (this.$cluster.getHashExpression() != null) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "hash is " + this.$cluster.getHashExpression(), null, false, 6, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$name = string;
                    this.$cluster = oraCluster;
                    super(0);
                }
            }, 3, null);
            OraClusterIndex index = cluster.getIndices().get();
            if (index != null) {
                AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, index, name){
                    final /* synthetic */ OraCreatingGenerator this$0;
                    final /* synthetic */ OraClusterIndex $index;
                    final /* synthetic */ String $name;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke() {
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "create index " + this.this$0.OraScriptingService.this.getScr(this.$index.getName()), null, false, 6, null);
                        CodeTextBuilder this_$iv = this.this$0.getBuilder();
                        CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                        try {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "on cluster " + this.$name, null, false, 6, null);
                        }
                        finally {
                            this_$iv.unindent();
                        }
                    }
                    {
                        this.this$0 = oraCreatingGenerator;
                        this.$index = oraClusterIndex;
                        this.$name = string;
                        super(0);
                    }
                }, 3, null);
            }
        }

        @Override
        @NotNull
        protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            BasicTable basicTable = table;
            if (basicTable == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraTable");
            }
            OraTable tab = (OraTable)basicTable;
            String name = OraScriptingService.this.currentScopeName(table);
            String h = "create table " + name;
            String f = null;
            if (tab.getClusterName() != null) {
                String string = tab.getClusterName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String cn = OraScriptingService.this.getScr(string);
                String cols3 = CollectionsKt.joinToString$default((Iterable)((OraTable)table).getClusterColNames(), null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this){
                    final /* synthetic */ OraCreatingGenerator this$0;

                    @NotNull
                    public final String invoke(String it) {
                        return this.this$0.OraScriptingService.this.getScr(it);
                    }
                    {
                        this.this$0 = oraCreatingGenerator;
                        super(1);
                    }
                }), (int)31, null);
                f = "\t" + "cluster " + cn + " (" + cols3 + ")";
            } else if (Intrinsics.areEqual((Object)((Object)tab.getOrganization()), (Object)((Object)TableOrganization.INDEX))) {
                f = "\torganization index";
            } else if (tab.isTemporary()) {
                String string;
                h = "create global temporary table " + name;
                boolean bl = tab.isTemporaryPreserve();
                if (!bl) {
                    string = "\ton commit delete rows";
                } else if (bl) {
                    string = "\ton commit preserve rows";
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                f = string;
            }
            return new HeaderFooter(h, f);
        }

        public final void generateCollectionType(@NotNull OraCollectionType col) {
            Intrinsics.checkParameterIsNotNull((Object)col, (String)"col");
            String name = OraScriptingService.this.getScr(col.getName());
            int n = col.getUpperBound();
            DataType dataType = col.getElementType();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"col.elementType");
            String d = OraScriptingService.this.script(dataType);
            String s1 = col.isArray() && n > 0 ? "create type " + name + " is varray(" + n + ") of " + d : "create type " + name + " as table of " + d;
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s1){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $s1;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$s1, null, false, 6, null);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$s1 = string;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateTrigger(@NotNull BasicTrigger trigger2) {
            OraTable table;
            Intrinsics.checkParameterIsNotNull((Object)trigger2, (String)"trigger");
            BasicTrigger basicTrigger = trigger2;
            if (basicTrigger == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraTrigger");
            }
            OraTrigger cfr_ignored_0 = (OraTrigger)basicTrigger;
            String triggerName = OraScriptingService.this.currentScopeName((BasicSchemaObject)((Object)trigger2));
            CharSequence charSequence = ((OraTrigger)trigger2).getOriginalSourceText();
            if (charSequence == null) {
                return;
            }
            CharSequence text = charSequence;
            BasicLikeTable basicLikeTable = ((OraTrigger)trigger2).getTable();
            if (!(basicLikeTable instanceof OraTable)) {
                basicLikeTable = null;
            }
            if ((table = (OraTable)basicLikeTable) == null) {
                AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName){
                    final /* synthetic */ OraCreatingGenerator this$0;
                    final /* synthetic */ String $triggerName;

                    public final void invoke() {
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- Cannot generate trigger " + this.$triggerName + ": the table is unknown", null, false, 6, null);
                    }
                    {
                        this.this$0 = oraCreatingGenerator;
                        this.$triggerName = string;
                        super(0);
                    }
                }, 3, null);
                return;
            }
            String tableName = OraScriptingService.this.currentScopeName(table);
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName, trigger2, tableName, text){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $triggerName;
                final /* synthetic */ BasicTrigger $trigger;
                final /* synthetic */ String $tableName;
                final /* synthetic */ CharSequence $text;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create trigger " + this.$triggerName, null, false, 6, null);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        String ev = ScriptingUtilsKt.makeTriggerEventString(this.$trigger);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), ev, null, false, 6, null);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "on " + this.$tableName, null, false, 6, null);
                        TrigTurn turn = ((OraTrigger)this.$trigger).getTurn();
                        if (Intrinsics.areEqual((Object)((Object)turn), (Object)((Object)TrigTurn.BEFORE_ROW)) || Intrinsics.areEqual((Object)((Object)turn), (Object)((Object)TrigTurn.AFTER_ROW)) || Intrinsics.areEqual((Object)((Object)turn), (Object)((Object)TrigTurn.INSTEAD_OF))) {
                            String c;
                            String string;
                            CharSequence charSequence;
                            String s = "for each row";
                            String string2 = ((OraTrigger)this.$trigger).getCondition();
                            if (string2 != null) {
                                charSequence = string2;
                                String string3 = charSequence;
                                if (string3 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                }
                                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                            } else {
                                string = c = null;
                            }
                            if (c != null && (charSequence = (CharSequence)c).length() > 0) {
                                s = s + (" when (" + s + ")");
                            }
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), s, null, false, 6, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$text, CompositeText.Kind.ORIGINAL_TEXT, false, 4, null);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$triggerName = string;
                    this.$trigger = basicTrigger;
                    this.$tableName = string2;
                    this.$text = charSequence;
                    super(0);
                }
            }, 3, null);
        }

        public final void generateModule(@NotNull OraModule module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            AbstractScriptingService.CreatingGenerator.generateUnspecificSourceAwareElement$default(this, module, false, 2, null);
            OraBody body = module.getBodies().get();
            if (body != null) {
                AbstractScriptingService.CreatingGenerator.generateUnspecificSourceAwareElement$default(this, body, false, 2, null);
            }
        }

        @Override
        protected void generateSynonym(@NotNull BasicSynonym synonym) {
            Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
            if (Intrinsics.areEqual((Object)synonym.getSchemaName(), (Object)"PUBLIC")) {
                this.generatePublicSynonym(synonym);
            } else {
                super.generateSynonym(synonym);
            }
        }

        private final void generatePublicSynonym(BasicSynonym synonym) {
            String targetSpec = this.makeSynonymTargetSpec(synonym);
            String name = OraScriptingService.this.getScr(synonym.getName());
            String text = targetSpec != null ? "create public synonym " + name + " for " + targetSpec : "-- unknown what the public synonym " + name + " references on :(";
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, text){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $text;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$text, null, false, 6, null);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$text = string;
                    super(0);
                }
            }, 3, null);
        }

        public OraCreatingGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
        }
    }
}

