/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.collect.Iterables;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.generic.GenericModDatabase;
import com.intellij.database.model.generic.GenericModModel;
import com.intellij.database.model.generic.GenericModRoot;
import com.intellij.database.model.generic.GenericModSchema;
import com.intellij.database.model.generic.GenericModTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.TraverserBasedASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileAttributes;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.script.SqlReader;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class DbSqlUtil {
    private static final Logger LOG = Logger.getInstance(DbSqlUtil.class);

    private DbSqlUtil() {
    }

    @Nullable
    public static SqlLanguageDialect findDialectById(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/util/DbSqlUtil", "findDialectById"));
        }
        return (SqlLanguageDialect)ObjectUtils.tryCast((Object)Language.findLanguageByID((String)id), SqlLanguageDialect.class);
    }

    @NotNull
    public static Collection<SqlLanguageDialect> getSqlDialects() {
        List list = JBIterable.from((Iterable)SqlLanguage.INSTANCE.getDialects()).filter(SqlLanguageDialect.class).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "getSqlDialects"));
        }
        return list;
    }

    @NotNull
    public static List<SqlLanguageDialect> getTopLevelSqlDialects() {
        List list = JBIterable.from((Iterable)SqlLanguage.INSTANCE.getDialects()).filter(SqlLanguageDialect.class).filter(o -> !(o instanceof InjectableLanguage)).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "getTopLevelSqlDialects"));
        }
        return list;
    }

    @NotNull
    public static SqlLanguageDialect getGenericDialect() {
        SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)ObjectUtils.notNull((Object)DbSqlUtil.findDialectById("GenericSQL"));
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "getGenericDialect"));
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static PsiElement getPsiDelegate(@Nullable DasObject info) {
        DasObject delegate = info instanceof DbElement ? ((DbElement)info).getDelegate() : info;
        return delegate instanceof PsiElement ? (PsiElement)delegate : null;
    }

    @Nullable
    public static SqlLanguageDialect getSqlDialect(@Nullable PsiElement element) {
        SqlLanguageDialect language;
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof SqlFile) {
            language = ((SqlFile)containingFile).getSqlLanguage();
        } else if (containingFile instanceof DummyHolder) {
            language = containingFile.getLanguage();
        } else {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            language = LanguageUtil.getLanguageForPsi((Project)element.getProject(), (VirtualFile)virtualFile);
        }
        return language instanceof SqlLanguageDialect ? language : null;
    }

    @NotNull
    public static Condition<VirtualFile> SQL_FILE_FILTER(Project project) {
        if (project == null) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "SQL_FILE_FILTER"));
            }
            return condition;
        }
        Condition condition = file -> {
            if (!file.isValid()) {
                return false;
            }
            if (file instanceof DatabaseElementVirtualFileImpl && ((DatabaseElementVirtualFileImpl)((Object)file)).isBusy()) {
                return false;
            }
            return file.getFileType() == SqlFileType.INSTANCE || LanguageUtil.getLanguageFileType((Language)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file)) == SqlFileType.INSTANCE;
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "SQL_FILE_FILTER"));
        }
        return condition;
    }

    @Nullable
    public static <T> T getSqlFileAttributeAt(@NotNull PsiFile file, @NotNull Key<T> attr, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/util/DbSqlUtil", "getSqlFileAttributeAt"));
        }
        if (attr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attr", "com/intellij/database/util/DbSqlUtil", "getSqlFileAttributeAt"));
        }
        SqlFile sqlFile = (SqlFile)ObjectUtils.tryCast((Object)file, SqlFile.class);
        return (T)(sqlFile != null ? sqlFile.getAttributeAt(attr, offset) : null);
    }

    @NotNull
    public static String getDelimiterAt(@Nullable PsiFile file, int offset) {
        String delim = file == null ? null : (String)DbSqlUtil.getSqlFileAttributeAt(file, SqlFileAttributes.DELIMITER, offset);
        String string = StringUtil.notNullize((String)delim, (String)";");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "getDelimiterAt"));
        }
        return string;
    }

    public static boolean delimiterNeedsSpacing(@NotNull String delim) {
        if (delim == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delim", "com/intellij/database/util/DbSqlUtil", "delimiterNeedsSpacing"));
        }
        return !delim.equals(";");
    }

    @NotNull
    public static String sql2Html(@NotNull Project project, @NotNull Language language, @NotNull CharSequence sequence) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbSqlUtil", "sql2Html"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/util/DbSqlUtil", "sql2Html"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/util/DbSqlUtil", "sql2Html"));
        }
        DdlBuilder.Colored colored = new DdlBuilder.Colored();
        GenericDialect dialect = language instanceof SqlLanguageDialect ? (DatabaseDialectEx)((SqlLanguageDialect)language).getDatabaseDialect() : GenericDialect.INSTANCE;
        colored.withDialect(dialect);
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, null);
        Lexer lexer = highlighter.getHighlightingLexer();
        lexer.start(sequence);
        while (lexer.getTokenType() != null) {
            TextAttributesKey[] keys;
            boolean pushed = false;
            IElementType type = lexer.getTokenType();
            if (type != null && (keys = highlighter.getTokenHighlights(type)).length > 0) {
                pushed = true;
                colored.pushStyle(keys[0]);
            }
            colored.plain(StringUtil.escapeXml((String)lexer.getTokenText()));
            lexer.advance();
            if (!pushed) continue;
            colored.popStyle();
        }
        String string = colored.getStatement();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "sql2Html"));
        }
        return string;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DbSqlUtil", "getSqlDialect"));
        }
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(DbImplUtil.getDatabaseDialect(element));
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "getSqlDialect"));
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static List<String> getQueries(@NotNull String text, @NotNull Project project, @NotNull Language language) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DbSqlUtil", "getQueries"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbSqlUtil", "getQueries"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/util/DbSqlUtil", "getQueries"));
        }
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)project);
        Ref model = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbSqlUtil", "lambda$getQueries$2"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/util/DbSqlUtil", "lambda$getQueries$2"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DbSqlUtil", "lambda$getQueries$2"));
            }
            PsiFile psi = PsiFileFactory.getInstance((Project)project).createFileFromText("fake.sql", language, (CharSequence)text);
            model.set((Object)facade.createScriptModel(psi));
        }, ModalityState.any());
        List list = ((ScriptModel)model.get()).statements().transform(ScriptModelUtil.TO_TEXT).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "getQueries"));
        }
        return list;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbSqlUtil", "getSqlDialect"));
        }
        for (SqlLanguageDialect sqlDialect : DbSqlUtil.getSqlDialects()) {
            if (sqlDialect.getDatabaseDialect() != dialect) continue;
            SqlLanguageDialect sqlLanguageDialect = sqlDialect;
            if (sqlLanguageDialect == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "getSqlDialect"));
            }
            return sqlLanguageDialect;
        }
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getGenericDialect();
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "getSqlDialect"));
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSourcesForResolve(@NotNull PsiFile sqlFile) {
        if (sqlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlFile", "com/intellij/database/util/DbSqlUtil", "getDataSourcesForResolve"));
        }
        JBIterable<DbDataSource> jBIterable = DbSqlUtil.getAppropriateDataSources(sqlFile, true, false);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "getDataSourcesForResolve"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DbDataSource> getAppropriateDataSources(@NotNull PsiFile sqlFile, boolean forResolve, boolean matchingOnly) {
        JBIterable sqlDataSources;
        if (sqlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlFile", "com/intellij/database/util/DbSqlUtil", "getAppropriateDataSources"));
        }
        boolean isReadonly = sqlFile instanceof PsiFileWithStubSupport && ((PsiFileWithStubSupport)sqlFile).getStubTree() == null && sqlFile.getNode() instanceof TraverserBasedASTNode;
        SqlLanguageDialect sqlDialect = (SqlLanguageDialect)ObjectUtils.notNull((Object)DbSqlUtil.getSqlDialect((PsiElement)sqlFile), (Object)DbSqlUtil.getGenericDialect());
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)sqlFile.getProject());
        JBIterable allDataSources = JBIterable.from((Iterable)dbPsiFacade.getDataSources());
        if (isReadonly) {
            allDataSources = allDataSources.filter(ds -> !(ds instanceof SqlDataSource));
        }
        JBIterable selectedDataSources = allDataSources.filter(element -> element.isValid() && DbImplUtil.getDatabaseDialect((DbElement)element) == sqlDialect.getDatabaseDialect());
        if (!isReadonly && forResolve && !(sqlDataSources = allDataSources.filter(o -> {
            if (sqlFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlFile", "com/intellij/database/util/DbSqlUtil", "lambda$getAppropriateDataSources$5"));
            }
            SqlDataSource delegate = (SqlDataSource)ObjectUtils.tryCast((Object)o.getDelegate(), SqlDataSource.class);
            return delegate != null && delegate.getSqlFiles().contains((Object)sqlFile);
        })).isEmpty()) {
            selectedDataSources = sqlDataSources;
        }
        JBIterable jBIterable = !matchingOnly && selectedDataSources.isEmpty() ? allDataSources : selectedDataSources;
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "getAppropriateDataSources"));
        }
        return jBIterable;
    }

    @Nullable
    public static SqlLanguageDialect guessSqlDialect(@NotNull RawConnectionConfig connectionInfo) {
        if (connectionInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionInfo", "com/intellij/database/util/DbSqlUtil", "guessSqlDialect"));
        }
        DatabaseFamilyId familyId = connectionInfo instanceof DatabaseSystem ? DatabaseFamilyId.forDataSource((DatabaseSystem)((DatabaseSystem)connectionInfo)) : DatabaseFamilyId.forConnection((RawConnectionConfig)connectionInfo);
        return DbSqlUtil.getSqlDialect(familyId);
    }

    @Nullable
    public static SqlLanguageDialect getSqlDialect(DatabaseFamilyId familyId) {
        for (SqlLanguageDialect dialect : DbSqlUtil.getSqlDialects()) {
            if (dialect.getDatabaseDialect().getFamilyId() != familyId) continue;
            return dialect;
        }
        return null;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull Project project, @Nullable RawConnectionConfig connectionInfo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbSqlUtil", "getSqlDialect"));
        }
        SqlLanguageDialect language = connectionInfo == null ? null : DbSqlUtil.guessSqlDialect(connectionInfo);
        SqlLanguageDialect sqlLanguageDialect = language != null ? language : SqlPsiFacade.getInstance((Project)project).getDefaultDialect();
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "getSqlDialect"));
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static DbElement findAnyContext(@NotNull Project project, @NotNull DatabaseSystem dataSource, @Nullable ObjectPath path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbSqlUtil", "findAnyContext"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DbSqlUtil", "findAnyContext"));
        }
        DatabaseElementVirtualFileImpl namespaceFile = DatabaseElementVirtualFileImpl.findFile(project, dataSource, path);
        DbElement namespace = null;
        if (namespaceFile != null) {
            namespace = namespaceFile.findElement();
        }
        if (namespace == null) {
            namespace = DbImplUtil.getDbDataSource(project, dataSource);
        }
        return namespace;
    }

    public static DasTable detectTable(@NotNull Project project, @NotNull Language language, @Nullable DbElement context, String queryText, DataRequest request, List<DataConsumer.Column> columns) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbSqlUtil", "detectTable"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/util/DbSqlUtil", "detectTable"));
        }
        DasTable table = null;
        if (language instanceof SqlLanguageDialect && queryText != null) {
            SqlTableType type = request instanceof ConsoleDataRequest && ((ConsoleDataRequest)request).resultType instanceof SqlTableType ? (SqlTableType)((ConsoleDataRequest)request).resultType : DbSqlUtil.parseQueryType(project, (SqlLanguageDialect)language, context, queryText, null);
            PsiElement element = type == null ? null : type.getTypeElement();
            DasTable dasTable = table = element instanceof DasTable ? (DasTable)element : null;
            if (table == null && element instanceof SqlReferenceExpression) {
                SqlReferenceExpression ref = (SqlReferenceExpression)element;
                String name = ref.getReferencePart(ObjectKind.TABLE);
                String schema = ref.getReferencePart(ObjectKind.SCHEMA);
                String catalog = ref.getReferencePart(ObjectKind.DATABASE);
                table = (DasTable)DialectUtils.withNewModel(UnknownDatabase.RDBMS, GenericModModel.class, GenericModRoot.class, root2 -> (GenericModTable)((GenericModSchema)((GenericModDatabase)root2.getDatabases().createOrGet(catalog)).getSchemas().createOrGet(schema)).getTables().createOrGet(name));
            } else if (table != null && columns.isEmpty()) {
                DatabaseDialectEx dialect = (DatabaseDialectEx)((SqlLanguageDialect)language).getDatabaseDialect();
                columns = DbSqlUtil.createColumnsFromType(project, dialect, type, DasUtil.getCatalog((DasObject)table), DasUtil.getSchema((DasObject)table), table.getName());
            }
        }
        if (!columns.isEmpty() && context != null) {
            DataConsumer.Column tableColumn = null;
            for (DataConsumer.Column column : columns) {
                if (StringUtil.isNotEmpty((String)column.table) && (tableColumn == null || Comparing.equal((String)column.catalog, (String)tableColumn.catalog) && Comparing.equal((String)column.schema, (String)tableColumn.schema) && Comparing.equal((String)column.table, (String)tableColumn.table))) {
                    tableColumn = column;
                    continue;
                }
                tableColumn = null;
                break;
            }
            DasTable fromCols = tableColumn == null ? null : QNameUtil.findTable((DatabaseSystem)context.getDataSource(), tableColumn.table, tableColumn.schema, tableColumn.catalog);
            table = (DasTable)ObjectUtils.chooseNotNull(fromCols, table);
        }
        if (table != null && request instanceof ConsoleDataRequest) {
            DasTableKey pk = DasUtil.getPrimaryKey(table);
            if (pk == null) {
                return columns.size() == Iterables.size((Iterable)DasUtil.getColumns(table)) ? table : null;
            }
            if (columns.size() < pk.getColumnsRef().size()) {
                return null;
            }
            for (String name : pk.getColumnsRef().names()) {
                boolean found = false;
                for (DataConsumer.Column column : columns) {
                    if (!Comparing.strEqual((String)name, (String)column.name, (boolean)false)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return null;
            }
        }
        return table;
    }

    @NotNull
    public static List<DataConsumer.Column> createColumnsFromType(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @Nullable String catalog, @Nullable String schema, @NotNull String tableName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbSqlUtil", "createColumnsFromType"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbSqlUtil", "createColumnsFromType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/util/DbSqlUtil", "createColumnsFromType"));
        }
        if (tableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableName", "com/intellij/database/util/DbSqlUtil", "createColumnsFromType"));
        }
        ArrayList columns = ContainerUtil.newArrayListWithCapacity((int)type.getColumnCount());
        List<String> columnNames = DbSqlUtil.getUnambiguousColumnNames(project, dialect, type);
        int count = type.getColumnCount();
        for (int i2 = 0; i2 < count; ++i2) {
            String name = columnNames.get(i2);
            String typeName = type.getColumnType(i2).getDisplayName();
            columns.add(new DataConsumer.Column(i2, name, 1111, typeName, null, 0, 0, catalog, schema, tableName));
        }
        ArrayList arrayList = columns;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "createColumnsFromType"));
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbSqlUtil", "getUnambiguousColumnNames"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbSqlUtil", "getUnambiguousColumnNames"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/util/DbSqlUtil", "getUnambiguousColumnNames"));
        }
        List<String> columnNames = DbSqlUtil.getColumnNames(type);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(columnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, type, columnNames, duplicates);
        List<String> list = columnNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "getUnambiguousColumnNames"));
        }
        return list;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType partType, @NotNull SqlTableType fullType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbSqlUtil", "getUnambiguousColumnNames"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbSqlUtil", "getUnambiguousColumnNames"));
        }
        if (partType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partType", "com/intellij/database/util/DbSqlUtil", "getUnambiguousColumnNames"));
        }
        if (fullType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullType", "com/intellij/database/util/DbSqlUtil", "getUnambiguousColumnNames"));
        }
        List<String> partColumnNames = DbSqlUtil.getColumnNames(partType);
        List<String> fullColumnNames = DbSqlUtil.getColumnNames(fullType);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(fullColumnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, partType, partColumnNames, duplicates);
        List<String> list = partColumnNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "getUnambiguousColumnNames"));
        }
        return list;
    }

    private static void makeUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @NotNull List<String> columnNames, @NotNull Set<String> duplicates) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbSqlUtil", "makeUnambiguousColumnNames"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbSqlUtil", "makeUnambiguousColumnNames"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/util/DbSqlUtil", "makeUnambiguousColumnNames"));
        }
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/database/util/DbSqlUtil", "makeUnambiguousColumnNames"));
        }
        if (duplicates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duplicates", "com/intellij/database/util/DbSqlUtil", "makeUnambiguousColumnNames"));
        }
        DdlBuilder builder = new DdlBuilder(new StringBuilder()).configureBuilder(project).withDialect(dialect);
        for (int i2 = 0; i2 < columnNames.size(); ++i2) {
            String name = columnNames.get(i2);
            String typeAlias = type.getColumnTypeAlias(i2);
            if (duplicates.contains(name) && typeAlias != null) {
                builder.columnRef(typeAlias).symbol(".").columnRef(name);
            } else {
                builder.columnRef(name);
            }
            columnNames.set(i2, builder.getStatement());
            builder.clear();
        }
    }

    private static List<String> getColumnNames(SqlTableType type) {
        ArrayList columnNames = ContainerUtil.newArrayListWithCapacity((int)type.getColumnCount());
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            columnNames.add(StringUtil.notNullize((String)type.getColumnName(i2)));
        }
        return columnNames;
    }

    private static Set<String> getDuplicateNames(List<String> names) {
        THashSet duplicates = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        THashSet distinctNames = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (String name : names) {
            if (distinctNames.add(name)) continue;
            duplicates.add(name);
        }
        return duplicates;
    }

    @NotNull
    public static List<PsiElement> resolveToColumnList(@NotNull SqlReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/util/DbSqlUtil", "resolveToColumnList"));
        }
        String text = StringUtil.notNullize((String)ref.getText());
        if (!"*".equals(text) && !text.endsWith(".*")) {
            PsiElement resolve = ref.getReference().resolve();
            List<Object> list = resolve == null ? Collections.emptyList() : Collections.singletonList(resolve);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "resolveToColumnList"));
            }
            return list;
        }
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)ref.getSqlType(), SqlTableType.class);
        if (type == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "resolveToColumnList"));
            }
            return list;
        }
        ArrayList res = ContainerUtil.newArrayListWithCapacity((int)type.getColumnCount());
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            res.add(type.getColumnElement(i2));
        }
        ArrayList arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbSqlUtil", "resolveToColumnList"));
        }
        return arrayList;
    }

    @Nullable
    public static SqlResultSetExpression parseQuery(@NotNull Project project, @NotNull SqlLanguageDialect language, @NotNull String queryText, SqlReader sqlReader) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbSqlUtil", "parseQuery"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/util/DbSqlUtil", "parseQuery"));
        }
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/util/DbSqlUtil", "parseQuery"));
        }
        SqlPsiFacade psiFacade = SqlPsiFacade.getInstance((Project)project);
        SqlFile sql = (sqlReader != null ? sqlReader : psiFacade.createSqlReader()).getReadOnlyPsi(language, (CharSequence)queryText);
        SyntaxTraverser traverser = (SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)sql);
        SqlResultSetExpression queryExpression = (SqlResultSetExpression)traverser.filter(SqlResultSetExpression.class).first();
        if (queryExpression == null || queryExpression.getTextRange().getStartOffset() != 0) {
            return null;
        }
        SqlSelectIntoClause selectIntoClause = (SqlSelectIntoClause)traverser.filter(SqlSelectIntoClause.class).first();
        if (selectIntoClause != null) {
            return null;
        }
        return queryExpression;
    }

    @Nullable
    public static SqlTableType parseQueryType(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @Nullable DbElement context, @NotNull String queryText, @Nullable SqlReader sqlReader) {
        SqlType sqlType;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbSqlUtil", "parseQueryType"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbSqlUtil", "parseQueryType"));
        }
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/util/DbSqlUtil", "parseQueryType"));
        }
        SqlResultSetExpression sql = DbSqlUtil.parseQuery(project, dialect, queryText, sqlReader);
        if (sql == null) {
            return null;
        }
        if (context != null) {
            sql.getContainingFile().putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, (Object)context.getDataSource());
            DasNamespace namespace = (DasNamespace)ObjectUtils.tryCast((Object)context, DasNamespace.class);
            sql.getContainingFile().putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, namespace != null ? Collections.singletonList(namespace) : null);
        }
        return (sqlType = sql.getSqlType()) instanceof SqlTableType ? (SqlTableType)sqlType : null;
    }

    public static boolean isResultEditable(@Nullable DataRequest request, DasTable detectedTable) {
        DasTable table;
        if (!(request instanceof DataRequest.QueryRequest)) {
            return false;
        }
        if (!(request instanceof ConsoleDataRequest)) {
            return true;
        }
        Object resultType = ((ConsoleDataRequest)request).resultType;
        if (!(resultType instanceof SqlTableType)) {
            return false;
        }
        SqlTableType type = (SqlTableType)resultType;
        PsiElement element = type.getTypeElement();
        Object object = element instanceof DasTable ? (DasTable)element : (table = element instanceof SqlReferenceExpression ? detectedTable : null);
        if (table == null || !DasUtil.getColumns((DasObject)table).iterator().hasNext()) {
            return false;
        }
        return DbImplUtil.isDataTable(table.getKind());
    }

    @Nullable
    public static IntrospectionScopeUpdater getScopeUpdater(@NotNull SyntaxTraverser<PsiElement> s, @Nullable ObjectPath ns, @NotNull DasModel model) {
        ObjectName objectName;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/util/DbSqlUtil", "getScopeUpdater"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/util/DbSqlUtil", "getScopeUpdater"));
        }
        IntrospectionScopeUpdater res = null;
        ObjectName db = ns != null ? DbSqlUtil.getCurrentDatabase(ns) : DbSqlUtil.getCurrentDatabase(model);
        for (SqlCreateStatement statement : s.filter(SqlCreateStatement.class)) {
            SqlNameElement element;
            ObjectKind kind = statement.getKind();
            if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA || (element = statement.getNameElement()) == null) continue;
            if (res == null) {
                res = new IntrospectionScopeUpdater();
            }
            objectName = new ObjectName(element.getName(), element.isQuotedIdentifier());
            if (kind == ObjectKind.DATABASE) {
                res.toAdd(objectName, null);
                continue;
            }
            res.toAdd(db, objectName);
        }
        for (SqlCreateStatement statement : s.filter(SqlDropStatement.class)) {
            ObjectKind kind;
            SqlReferenceExpression expression = statement.getTargetExpression();
            if (expression == null || (kind = expression.getReferenceElementType().getTargetKind()) != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) continue;
            if (res == null) {
                res = new IntrospectionScopeUpdater();
            }
            objectName = new ObjectName(expression.getName(), expression.isQuotedIdentifier());
            if (kind == ObjectKind.DATABASE) {
                res.toRemove(objectName, null);
                continue;
            }
            res.toRemove(db, objectName);
        }
        return res;
    }

    @Nullable
    private static ObjectName getCurrentDatabase(@NotNull DasModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/util/DbSqlUtil", "getCurrentDatabase"));
        }
        DasNamespace cur = model.getCurrentRootNamespace();
        if (cur == null) {
            Iterator it = model.getModelRoots().filter(DasNamespace.class).iterator();
            if (!it.hasNext()) {
                return null;
            }
            cur = (DasNamespace)it.next();
            if (it.hasNext()) {
                return null;
            }
        }
        return cur.getKind() == ObjectKind.DATABASE ? ObjectName.quoted((String)cur.getName()) : null;
    }

    @Nullable
    private static ObjectName getCurrentDatabase(@NotNull ObjectPath ns) {
        if (ns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ns", "com/intellij/database/util/DbSqlUtil", "getCurrentDatabase"));
        }
        ObjectName db = ObjectName.quoted((String)(ns.kind == ObjectKind.DATABASE ? ns.getName() : (ns.path.size() > 1 ? ns.path.get(ns.path.size() - 2) : null)));
        return db;
    }
}

