/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbUIUtil {
    public static final JBColor WARNING = new JBColor(15111424, 10322434);

    private DbUIUtil() {
    }

    public static void configureDataSourceComboBox(JComboBox comboBox, Iterable<DbDataSource> dataSources, boolean allowNull) {
        ArrayList copy = ContainerUtil.newArrayList(dataSources);
        Collections.sort(copy, (o1, o2) -> Comparing.compare((Comparable)((Object)StringUtil.toLowerCase((String)o1.getName())), (Comparable)((Object)StringUtil.toLowerCase((String)o2.getName()))));
        if (allowNull) {
            copy.add(0, null);
        }
        comboBox.setModel(new CollectionComboBoxModel((List)copy));
        comboBox.setRenderer(new ListCellRendererWrapper<DatabaseSystem>(){

            public void customize(JList list, DatabaseSystem element, int index, boolean selected, boolean hasFocus) {
                this.setIcon(element instanceof DbDataSource ? ((DbDataSource)element).getIcon() : null);
                String name = element == null ? "<none>" : element.getName();
                this.setText(StringUtil.notNullize((String)name));
            }
        });
        comboBox.setEditable(false);
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/util/DbUIUtil", "invokeLaterIfNeeded"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/util/DbUIUtil", "invokeLater"));
        }
        SwingUtilities.invokeLater(runnable);
    }

    public static Color softHighlightOf(Color c1) {
        if (c1 == null) {
            return null;
        }
        int i2 = 16;
        return new JBColor(new Color(Math.max(0, c1.getRed() - i2), Math.max(0, c1.getGreen() - i2), Math.max(0, c1.getBlue() - i2)), new Color(Math.min(255, c1.getRed() + i2), Math.min(255, c1.getGreen() + i2), Math.min(255, c1.getBlue() + i2)));
    }

    public static boolean isIntervalModifierSet(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/util/DbUIUtil", "isIntervalModifierSet"));
        }
        return 0 != (e.getModifiersEx() & 0x40);
    }

    public static boolean isExclusiveModifierSet(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/util/DbUIUtil", "isExclusiveModifierSet"));
        }
        return 0 != (e.getModifiersEx() & 0x180);
    }

    @Nullable
    public static VirtualFile openInConsole(@Nullable DbElement o, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DbUIUtil", "openInConsole"));
        }
        return o == null ? null : DbUIUtil.openInConsole(o.getDataSource(), o, text, false);
    }

    @Nullable
    public static VirtualFile openInConsole(@NotNull DbDataSource dataSource, @Nullable DbElement o, @NotNull String text, boolean existing) {
        VirtualFile file;
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DbUIUtil", "openInConsole"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DbUIUtil", "openInConsole"));
        }
        LocalDataSource localDataSource = (LocalDataSource)((Object)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class));
        if (localDataSource == null) {
            return null;
        }
        VirtualFile virtualFile = file = existing ? DatabaseEditorHelper.getConsoleVirtualFile((DatabaseSystem)localDataSource) : DatabaseEditorHelper.createNewConsoleVirtualFile((DatabaseSystem)localDataSource);
        if (file == null) {
            return null;
        }
        DbUIUtil.openInConsole(dataSource.getProject(), file, text, (DasObject)o);
        return file;
    }

    public static void openInConsole(@NotNull Project project, @NotNull VirtualFile file, @NotNull String text, @Nullable DasObject o) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbUIUtil", "openInConsole"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/util/DbUIUtil", "openInConsole"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DbUIUtil", "openInConsole"));
        }
        Document doc = FileDocumentManager.getInstance().getDocument(file);
        if (doc != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbUIUtil", "lambda$openInConsole$2"));
                }
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DbUIUtil", "lambda$openInConsole$2"));
                }
                CommandProcessor.getInstance().executeCommand(project, () -> {
                    int length;
                    if (text == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DbUIUtil", "lambda$null$1"));
                    }
                    doc.insertString(length, (CharSequence)((length = doc.getTextLength()) == 0 ? text : "\n" + text));
                }, "Open query in console", null);
            });
            FileEditorManager.getInstance((Project)project).openFile(file, true);
            DatabaseEditorHelper.openConsoleForFile(project, (DasNamespace)DasUtil.getParentOfClass((DasObject)o, DasNamespace.class, (boolean)false), file);
        }
    }
}

