/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.DatabaseInputType;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.copy.CopyHandlerDelegate;

public class DatabaseViewCopyHandlerDelegate
implements CopyHandlerDelegate {
    public boolean canCopy(PsiElement[] elements) {
        return elements != null && elements.length == 1 && elements[0] instanceof DbTable && ImportUtil.canBeProducer((DbElement)elements[0]);
    }

    public void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        DbTable element = (DbTable)elements[0];
        DbDataSource source = element.getDataSource();
        LocalDataSource delegate = (LocalDataSource)source.getDelegate();
        ImportInfo.Builder builder = new ImportInfo.Builder().producerName(element.getName()).inputType(new DatabaseInputType(delegate, source, (DasTable)element, element.getProject()));
        ImportUtil.showTargetChooser(element.getProject(), builder, (DbElement)element);
    }

    public void doClone(PsiElement element) {
    }
}

