/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.SchemaEditorHelper;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DdlPreviewBase;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlPreview
extends DdlPreviewBase {
    public DdlPreview(@NotNull DatabaseEditorContext context, @NotNull Function<Runnable, ActionCallback> asyncProcessor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/editors/DdlPreview", "<init>"));
        }
        if (asyncProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncProcessor", "com/intellij/database/view/editors/DdlPreview", "<init>"));
        }
        super(context, asyncProcessor);
    }

    public boolean updatePreview(@Nullable ModelTraverser traverser) {
        if (traverser != null) {
            return this.updatePreview((Processor<SchemaEditorHelper>)((Processor)helper -> {
                helper.alter(traverser.model, traverser.traverse());
                return true;
            }), (DeModel)traverser.model.getModel());
        }
        this.myPreview.setText("-- No editor");
        this.scrollToBeginning();
        return false;
    }

    @Override
    @NotNull
    public String getPreviewText() {
        String string = this.myPreview.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DdlPreview", "getPreviewText"));
        }
        return string;
    }

    public static class ModelTraverser {
        public final DeModel model;

        public ModelTraverser(DeModel model) {
            this.model = model;
        }

        @NotNull
        public JBIterable<SchemaEditorHelper.ObjectAction> traverse() {
            JBIterable<SchemaEditorHelper.ObjectAction> jBIterable = SchemaEditorHelper.basicTraversal(this.model);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DdlPreview$ModelTraverser", "traverse"));
            }
            return jBIterable;
        }
    }
}

