/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverListener;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import com.intellij.util.ui.classpath.SingleRootClasspathElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DriverClasspathPanel
implements Disposable {
    @NotNull
    private Project myProject;
    @Nullable
    private final LocalDataSource myDataSource;
    private final Configurable myConfigurable;
    @Nullable
    private DatabaseDriver myDriver;
    @NotNull
    private DatabaseConfigEditor myController;
    private JBList myArtifactList;
    private MyUserActivityPanel myArtifactsPanel;
    private Runnable onUpdate;
    private MyArtifactLink myArtifactLink;
    private LinkLabel<?> myUpdateLink;
    private String myArtifactName;
    private String myArtifactVersion;
    private boolean myRolling;
    private JBCheckBox myUseArtifactBox;

    public boolean isRolling() {
        return this.myRolling;
    }

    public DriverClasspathPanel(@NotNull Project project, @NotNull Configurable configurable, @Nullable DatabaseDriver driver, @Nullable LocalDataSource dataSource, @NotNull DatabaseConfigEditor controller) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/ui/DriverClasspathPanel", "<init>"));
        }
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/database/view/ui/DriverClasspathPanel", "<init>"));
        }
        if (controller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/intellij/database/view/ui/DriverClasspathPanel", "<init>"));
        }
        this.myProject = project;
        this.myConfigurable = configurable;
        this.myDriver = driver;
        this.myDataSource = dataSource;
        this.myController = controller;
        DatabaseDriver.ArtifactRef artifact = this.myDriver == null ? null : this.myDriver.getArtifact();
        this.myArtifactName = artifact == null ? null : artifact.getName();
        this.myArtifactVersion = artifact == null ? null : artifact.getVersion();
        this.myRolling = artifact == null || artifact.isRolling();
        DatabaseDriverManager.getInstance().addDriverListener(new DatabaseDriverListener.Adapter(){

            @Override
            public void driverUpdated(DatabaseDriver driver) {
                if (driver == DriverClasspathPanel.this.myDriver) {
                    DatabaseDriver.ArtifactRef artifact = driver.getArtifact();
                    DriverClasspathPanel.this.myArtifactVersion = artifact == null ? null : artifact.getVersion();
                    DriverClasspathPanel.this.myRolling = artifact == null || artifact.isRolling();
                    DriverClasspathPanel.this.updateClasspath();
                    DriverClasspathPanel.this.updateArtifactLink();
                    DriverClasspathPanel.this.fireUserActivity();
                }
            }
        }, this);
    }

    public void dispose() {
    }

    private void fireUserActivity() {
        ((ChangeListener)this.myArtifactsPanel.myDispatcher.getMulticaster()).stateChanged(this.myArtifactsPanel.myEvent);
    }

    public void setDriver(@Nullable DatabaseDriver driver) {
        this.myDriver = driver;
        DatabaseDriver.ArtifactRef artifact = this.myDriver == null ? null : this.myDriver.getArtifact();
        this.myArtifactName = artifact == null ? null : artifact.getName();
        this.myArtifactVersion = artifact == null ? null : artifact.getVersion();
        this.myUseArtifactBox.setSelected(artifact != null && artifact.isUsed());
        this.updateClasspath();
        this.updateArtifactLink();
    }

    public void setOnUpdate(Runnable onUpdate) {
        this.onUpdate = onUpdate;
    }

    public JComponent createComponent() {
        this.myArtifactsPanel = new MyUserActivityPanel();
        this.myArtifactList = new JBList();
        this.myArtifactList.setEmptyText("No additional files");
        this.myArtifactList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/view/ui/DriverClasspathPanel$2", "customizeCellRenderer"));
                }
                ClassPathItem item = (ClassPathItem)value;
                if (item != null) {
                    File file = item.file;
                    SimpleTextAttributes style = item.fromParent ? SimpleTextAttributes.GRAY_ATTRIBUTES : (file != null && file.exists() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.append(file != null ? file.getPath() : item.element.getPresentableName(), style);
                    if (file != null) {
                        this.setIcon(!file.exists() ? PlatformIcons.FILE_ICON : (file.isDirectory() ? PlatformIcons.FOLDER_ICON : FileTypeManager.getInstance().getFileTypeByExtension(FileUtilRt.getExtension((String)file.getName())).getIcon()));
                    } else {
                        this.setIcon(PlatformIcons.LIBRARY_ICON);
                    }
                } else {
                    this.append("?");
                    this.setIcon(null);
                }
            }
        });
        JPanel artifactsListPanel = ToolbarDecorator.createDecorator((JList)this.myArtifactList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                DriverClasspathPanel.this.doChooseFiles((Consumer<List<VirtualFile>>)files -> {
                    for (VirtualFile file : files) {
                        for (SimpleClasspathElement cpe : SimpleClasspathElementFactory.createElements((String[])new String[]{file.getUrl()})) {
                            ((DefaultListModel)DriverClasspathPanel.this.myArtifactList.getModel()).addElement(new ClassPathItem(cpe, false));
                        }
                    }
                });
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                ClassPathItem item = (ClassPathItem)DriverClasspathPanel.this.myArtifactList.getSelectedValue();
                return !item.fromParent;
            }
        }).createPanel();
        Box downloadPanel = new Box(0);
        this.myArtifactLink = new MyArtifactLink();
        this.myUseArtifactBox = new JBCheckBox("Use provided driver ");
        this.myUseArtifactBox.addActionListener(e -> {
            this.onUpdateClasspath();
            this.updateArtifactLink();
        });
        this.myUpdateLink = LinkLabel.create((String)"", () -> this.download("latest"));
        DatabaseArtifactManager.getInstance().addListener((name, version) -> {
            if (!(name == null || Comparing.equal((String)name, (String)this.myArtifactName) && Comparing.equal((String)version, (String)this.myArtifactVersion))) {
                return;
            }
            this.onUpdateClasspath();
            this.updateArtifactLink();
        }, this);
        Font smallFont = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
        this.myUseArtifactBox.setFont(smallFont);
        this.myArtifactLink.setFont(smallFont);
        this.myUpdateLink.setFont(smallFont);
        downloadPanel.add((Component)this.myUseArtifactBox);
        downloadPanel.add((Component)((Object)this.myArtifactLink));
        downloadPanel.add(Box.createHorizontalStrut(40));
        downloadPanel.add((Component)this.myUpdateLink);
        JBLabel tableLabel = new JBLabel("Additional:");
        tableLabel.setFont(smallFont);
        downloadPanel.setAlignmentX(0.0f);
        tableLabel.setAlignmentX(0.0f);
        artifactsListPanel.setAlignmentX(0.0f);
        this.myArtifactsPanel.add(downloadPanel);
        this.myArtifactsPanel.add((Component)tableLabel);
        this.myArtifactsPanel.add(artifactsListPanel);
        this.updateArtifactLink();
        return this.myArtifactsPanel;
    }

    private void download(final @NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/database/view/ui/DriverClasspathPanel", "download"));
        }
        if (this.myArtifactName == null) {
            return;
        }
        new Task.Backgroundable(this.myProject, "Downloading " + this.myArtifactName, true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                String realVersion;
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DriverClasspathPanel$5", "run"));
                }
                if (DriverClasspathPanel.this.myArtifactName == null) {
                    return;
                }
                DatabaseArtifactManager manager = DatabaseArtifactManager.getInstance();
                String string = realVersion = version.equals("latest") ? manager.getActualVersion(DriverClasspathPanel.this.myArtifactName) : version;
                if (realVersion == null) {
                    return;
                }
                try {
                    Consumer uiUpdate = version -> {
                        DriverClasspathPanel.this.myArtifactVersion = version;
                        DriverClasspathPanel.this.updateArtifactLink();
                        DriverClasspathPanel.this.onUpdateClasspath();
                        DriverClasspathPanel.this.fireUserActivity();
                    };
                    if (manager.isValid(DriverClasspathPanel.this.myArtifactName, realVersion)) {
                        ApplicationManager.getApplication().invokeLater(() -> uiUpdate.consume((Object)realVersion));
                    } else {
                        manager.downloadArtifact(DriverClasspathPanel.this.myArtifactName, version, (Consumer<DownloadableFileSetDescription>)((Consumer)o -> uiUpdate.consume((Object)o.getVersionString())));
                    }
                }
                catch (IOException e) {
                    ApplicationManager.getApplication().invokeLater(() -> DriverClasspathPanel.this.myController.showErrorNotification(DriverClasspathPanel.this.myConfigurable, (Object)this, e));
                }
            }
        }.queue();
    }

    private void updateArtifactLink() {
        this.myArtifactLink.setText(this.getArtifactString());
        String actual = this.myArtifactName == null ? null : DatabaseArtifactManager.getInstance().getActualVersion(this.myArtifactName);
        boolean actualDownloaded = true;
        boolean invalid = false;
        boolean needUpdate = false;
        if (this.myArtifactName != null && this.myUseArtifactBox.isSelected()) {
            List<SimpleClasspathElement> cp = null;
            if (this.myDriver != null && this.myDriver.getArtifact() != null && this.myArtifactName.equals(this.myDriver.getArtifact().getName()) && this.myArtifactVersion == null) {
                cp = this.myDriver.getClasspathElements();
            }
            invalid = !DatabaseDriverValidator.isDriverFilesValid(this.myArtifactName, this.myArtifactVersion, cp);
            needUpdate = invalid || !DatabaseDriverValidator.isDriverFilesUpToDate(this.myArtifactName, this.myArtifactVersion, this.myRolling, cp);
            actualDownloaded = !needUpdate || DatabaseDriverValidator.isDriverFilesUpToDate(this.myArtifactName, actual, this.myRolling, cp);
        }
        Color fg = this.myUseArtifactBox.isSelected() ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground();
        this.myUseArtifactBox.setForeground(fg);
        this.myArtifactLink.setEnabled(this.myUseArtifactBox.isSelected());
        this.myArtifactLink.setInvalid(invalid);
        if (actual == null || !invalid && !needUpdate) {
            this.myUpdateLink.setVisible(false);
            return;
        }
        this.myUpdateLink.setText((actualDownloaded ? "Switch to" : "Download") + " ver. " + actual);
        this.myUpdateLink.setVisible(true);
    }

    @NotNull
    private String getArtifactString() {
        if (this.myArtifactName == null) {
            if ("None" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DriverClasspathPanel", "getArtifactString"));
            }
            return "None";
        }
        String driverStr = this.myArtifactName;
        if (this.myRolling) {
            driverStr = driverStr + " [latest]";
        } else if (this.myArtifactVersion != null) {
            driverStr = driverStr + " ver. " + this.myArtifactVersion;
        }
        String string = driverStr;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DriverClasspathPanel", "getArtifactString"));
        }
        return string;
    }

    private void doChooseFiles(@NotNull Consumer<List<VirtualFile>> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/view/ui/DriverClasspathPanel", "doChooseFiles"));
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, true, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && file.isDirectory() || file.getFileType() == FileTypes.ARCHIVE;
            }
        };
        descriptor.setTitle("Select Database Driver Files");
        VirtualFile toSelect = LocalFileSystem.getInstance().findFileByPath(DatabaseDriverImpl.getDriverDownloadDirectory());
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, (Component)this.myArtifactsPanel, (VirtualFile)toSelect, consumer);
    }

    public void updateClasspath() {
        DefaultListModel listModel = new DefaultListModel();
        if (this.myDataSource != null) {
            ListModel oldModel = this.myArtifactList.getModel();
            if (oldModel.getSize() == 0) {
                for (SimpleClasspathElement cp : this.myDataSource.getOwnClasspath()) {
                    listModel.addElement(new ClassPathItem(cp, false));
                }
            } else {
                listModel = (DefaultListModel)oldModel;
            }
        } else if (this.myDriver != null) {
            for (SimpleClasspathElement element : this.myDriver.getAdditionalClasspathElements()) {
                listModel.addElement(new ClassPathItem(element, this.myDataSource != null));
            }
        }
        this.myArtifactList.setModel(listModel);
        listModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                DriverClasspathPanel.this.onUpdateClasspath();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                DriverClasspathPanel.this.onUpdateClasspath();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                DriverClasspathPanel.this.onUpdateClasspath();
            }
        });
        this.onUpdateClasspath();
    }

    private void onUpdateClasspath() {
        if (this.onUpdate != null) {
            this.onUpdate.run();
        }
    }

    public List<SimpleClasspathElement> getClasspath() {
        ListModel artifactListModel = this.myArtifactList.getModel();
        ArrayList<SimpleClasspathElement> fileList = new ArrayList<SimpleClasspathElement>();
        for (int i2 = 0; i2 < artifactListModel.getSize(); ++i2) {
            ClassPathItem item = (ClassPathItem)artifactListModel.getElementAt(i2);
            if (item == null || item.fromParent) continue;
            fileList.add(item.element);
        }
        return fileList;
    }

    public List<SimpleClasspathElement> getClasspathFull() {
        List<SimpleClasspathElement> classpath = this.getClasspath();
        if (this.myUseArtifactBox.isSelected() && this.myArtifactName != null) {
            DatabaseArtifactManager artifactManager = DatabaseArtifactManager.getInstance();
            if (this.myArtifactVersion == null) {
                DatabaseDriver.ArtifactRef artifactRef;
                DatabaseDriver.ArtifactRef artifactRef2 = artifactRef = this.myDriver == null ? null : this.myDriver.getArtifact();
                if (artifactRef != null && Comparing.equal((String)this.myArtifactName, (String)artifactRef.getName()) && artifactRef.getVersion() == null) {
                    classpath.addAll(((DatabaseDriverImpl)this.myDriver).getArtifactClasspathElements());
                }
            } else {
                for (VirtualFile file : artifactManager.getFiles(this.myArtifactName, (String)ObjectUtils.chooseNotNull((Object)this.myArtifactVersion, (Object)"latest"))) {
                    classpath.add((SimpleClasspathElement)new SingleRootClasspathElement(file.getUrl()));
                }
            }
        }
        return classpath;
    }

    @Nullable
    public String getArtifactName() {
        return this.myArtifactName;
    }

    @Nullable
    public String getArtifactVersion() {
        return this.myArtifactVersion;
    }

    public boolean isUseArtifact() {
        return this.myUseArtifactBox.isSelected();
    }

    private class MyArtifactLink
    extends LinkLabel<Void> {
        private boolean myInvalid;

        public MyArtifactLink() {
            super("", null);
            this.setListener((a, b) -> this.onClick(), null);
        }

        public String getToolTipText() {
            StringBuilder builder;
            block8: {
                block7: {
                    DatabaseDriver.ArtifactRef artifact;
                    if (DriverClasspathPanel.this.myArtifactName == null) {
                        return "";
                    }
                    builder = new StringBuilder();
                    builder.append(DriverClasspathPanel.this.myArtifactName);
                    if (DriverClasspathPanel.this.myRolling) {
                        builder.append(" [rolling releases]");
                    }
                    if (DriverClasspathPanel.this.myArtifactVersion != null) break block7;
                    builder.append(" with old files:\n");
                    DatabaseDriver.ArtifactRef artifactRef = artifact = DriverClasspathPanel.this.myDriver == null ? null : DriverClasspathPanel.this.myDriver.getArtifact();
                    if (artifact == null || !Comparing.equal((String)artifact.getName(), (String)DriverClasspathPanel.this.myArtifactName) || artifact.getVersion() != null) break block8;
                    for (SimpleClasspathElement element : ((DatabaseDriverImpl)DriverClasspathPanel.this.myDriver).getArtifactClasspathElements()) {
                        for (String url : element.getClassesRootUrls()) {
                            if (builder.length() != 0) {
                                builder.append("\n");
                            }
                            builder.append(VfsUtilCore.urlToPath((String)url));
                        }
                    }
                    break block8;
                }
                builder.append(" [ver. ").append(DriverClasspathPanel.this.myArtifactVersion).append("]:\n");
                for (VirtualFile file : DatabaseArtifactManager.getInstance().getFiles(DriverClasspathPanel.this.myArtifactName, DriverClasspathPanel.this.myArtifactVersion)) {
                    if (builder.length() != 0) {
                        builder.append("\n");
                    }
                    builder.append(file.getPath());
                }
            }
            return builder.toString();
        }

        private void onClick() {
            if (!DriverClasspathPanel.this.myUseArtifactBox.isSelected()) {
                return;
            }
            List<DownloadableFileSetDescription> artifacts = DatabaseArtifactManager.getInstance().getArtifacts();
            if (artifacts.isEmpty()) {
                return;
            }
            final MultiMap groupped = MultiMap.create();
            ArrayList names = ContainerUtil.newArrayList();
            artifacts.forEach(a -> groupped.putValue((Object)a.getName(), a));
            names.addAll(groupped.keySet());
            Collections.sort(names, StringUtil::naturalCompare);
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(null, (List)names){

                @NotNull
                public String getTextFor(String value) {
                    String string = value;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DriverClasspathPanel$MyArtifactLink$1", "getTextFor"));
                    }
                    return string;
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                public boolean hasSubstep(String selectedValue) {
                    return true;
                }

                public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                    final ArrayList list = ContainerUtil.newArrayList();
                    for (DownloadableFileSetDescription description : groupped.get((Object)selectedValue)) {
                        list.add(Pair.create((Object)description.getVersionString(), (Object)description));
                    }
                    if (list.isEmpty()) {
                        return FINAL_CHOICE;
                    }
                    list.add(0, Pair.create((Object)"Latest version", (Object)((Pair)list.get((int)0)).second));
                    return new BaseListPopupStep<Pair<String, DownloadableFileSetDescription>>(null, (List)list){

                        @NotNull
                        public String getTextFor(Pair<String, DownloadableFileSetDescription> value) {
                            String string = (String)value.first;
                            if (string == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DriverClasspathPanel$MyArtifactLink$1$1", "getTextFor"));
                            }
                            return string;
                        }

                        public boolean isSpeedSearchEnabled() {
                            return true;
                        }

                        public PopupStep onChosen(Pair<String, DownloadableFileSetDescription> selectedValue, boolean finalChoice) {
                            if (selectedValue != null) {
                                DriverClasspathPanel.this.myRolling = selectedValue == list.get(0);
                                DriverClasspathPanel.this.myArtifactName = ((DownloadableFileSetDescription)selectedValue.second).getName();
                                DriverClasspathPanel.this.myArtifactVersion = ((DownloadableFileSetDescription)selectedValue.second).getVersionString();
                                DriverClasspathPanel.this.download(DriverClasspathPanel.this.myArtifactVersion);
                                DriverClasspathPanel.this.fireUserActivity();
                            }
                            return FINAL_CHOICE;
                        }
                    };
                }
            }).show(RelativePoint.getSouthWestOf((JComponent)((Object)DriverClasspathPanel.this.myArtifactLink)));
        }

        public void setInvalid(boolean invalid) {
            this.myInvalid = invalid;
        }

        protected Color getActive() {
            return this.myInvalid ? JBColor.RED : super.getActive();
        }

        protected Color getNormal() {
            return this.myInvalid ? JBColor.RED : super.getNormal();
        }
    }

    private static class MyUserActivityPanel
    extends Box
    implements UserActivityProviderComponent {
        private EventDispatcher<ChangeListener> myDispatcher = EventDispatcher.create(ChangeListener.class);
        private ChangeEvent myEvent = new ChangeEvent(this);

        public MyUserActivityPanel() {
            super(1);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.myDispatcher.addListener((EventListener)changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.myDispatcher.removeListener((EventListener)changeListener);
        }
    }

    private static class ClassPathItem {
        @NotNull
        SimpleClasspathElement element;
        @Nullable
        File file;
        boolean fromParent;

        ClassPathItem(@NotNull SimpleClasspathElement element, boolean fromParent) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/ui/DriverClasspathPanel$ClassPathItem", "<init>"));
            }
            this.element = element;
            this.fromParent = fromParent;
            String url = (String)ContainerUtil.getFirstItem((List)element.getClassesRootUrls());
            if (url != null) {
                this.file = new File(PathUtil.toPresentableUrl((String)url));
            }
        }

        public String toString() {
            String url = (String)ContainerUtil.getFirstItem((List)this.element.getClassesRootUrls());
            return url == null ? "" : PathUtil.toPresentableUrl((String)url);
        }
    }
}

