/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlResolveEditor;
import com.intellij.sql.dialects.SqlResolveMappings;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Producer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlResolveConfigurable
extends PerFileConfigurableBase<TreePattern> {
    protected SqlResolveConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/SqlResolveConfigurable", "<init>"));
        }
        super(project, (PerFileMappings)SqlResolveMappings.getInstance(project));
    }

    @Nullable
    protected <S> Object getParameter(@NotNull Key<S> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/sql/dialects/SqlResolveConfigurable", "getParameter"));
        }
        if (key == DESCRIPTION) {
            return SqlMessages.message("dialog.sql.resolve.caption", ApplicationNamesInfo.getInstance().getProductName());
        }
        if (key == MAPPING_TITLE) {
            return SqlMessages.message("dialog.sql.resolve.value.title", new Object[0]);
        }
        if (key == OVERRIDE_QUESTION) {
            return SqlMessages.message("dialog.sql.resolve.override.question", new Object[0]);
        }
        if (key == OVERRIDE_TITLE) {
            return SqlMessages.message("dialog.sql.resolve.override.title", new Object[0]);
        }
        if (key == ADD_PROJECT_MAPPING) {
            return false;
        }
        return null;
    }

    protected void renderDefaultValue(@Nullable Object target, @NotNull ColoredTextContainer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/sql/dialects/SqlResolveConfigurable", "renderDefaultValue"));
        }
        TreePattern t = (TreePattern)this.getNewMapping((VirtualFile)target);
        if (t == null) {
            return;
        }
        this.renderValue(t, renderer, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES, 120);
    }

    @NotNull
    private TreePattern getDefaultMapping(@Nullable Object target) {
        VirtualFile file = (VirtualFile)ObjectUtils.tryCast((Object)target, VirtualFile.class);
        TreePattern treePattern = (TreePattern)ObjectUtils.chooseNotNull((Object)this.getNewMapping(file), (Object)SqlResolveMappings.ALL_DATA_SOURCES);
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveConfigurable", "getDefaultMapping"));
        }
        return treePattern;
    }

    @Nullable
    protected String getNullValueText(@Nullable Object target) {
        if (target == null) {
            return "<Default>";
        }
        return super.getNullValueText(target);
    }

    @NotNull
    protected Collection<TreePattern> getValueVariants(@Nullable Object target) {
        List<Object> list = Collections.singletonList(this.myMappings.getMapping(null));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveConfigurable", "getValueVariants"));
        }
        return list;
    }

    protected void renderValue(@Nullable Object target, @NotNull TreePattern pattern, @NotNull ColoredTextContainer renderer) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/sql/dialects/SqlResolveConfigurable", "renderValue"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/sql/dialects/SqlResolveConfigurable", "renderValue"));
        }
        this.renderValue(pattern, renderer, null, 120);
    }

    private void renderValue(@NotNull TreePattern pattern, @NotNull ColoredTextContainer renderer, @Nullable SimpleTextAttributes forcedAttrs, int maxChars) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/sql/dialects/SqlResolveConfigurable", "renderValue"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/sql/dialects/SqlResolveConfigurable", "renderValue"));
        }
        boolean[] first = new boolean[]{true};
        String[] ds = new String[]{null};
        int[] count = new int[]{0};
        this.format(pattern, (s, k, leaf, lvl) -> {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/sql/dialects/SqlResolveConfigurable", "lambda$renderValue$0"));
            }
            if (count[0] == -1) {
                return;
            }
            if (k == SqlImportUtil.DATA_SOURCE) {
                ds[0] = s;
                if (!first[0]) {
                    count[0] = count[0] + 2;
                    renderer.append(", ", (SimpleTextAttributes)ObjectUtils.notNull((Object)forcedAttrs, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                }
                if (leaf) {
                    s = "<Default>";
                } else {
                    return;
                }
            }
            if (count[0] >= maxChars) {
                count[0] = -1;
                return;
            }
            String trimmed1 = StringUtil.first((String)s, (int)(maxChars - count[0]), (boolean)false);
            if (!leaf) {
                count[0] = count[0] + (trimmed1.length() + 1);
                renderer.append(trimmed1 + ":", (SimpleTextAttributes)ObjectUtils.notNull((Object)forcedAttrs, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
            } else {
                count[0] = count[0] + trimmed1.length();
                renderer.append(trimmed1, (SimpleTextAttributes)ObjectUtils.notNull((Object)forcedAttrs, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                if (ds[0] != null && count[0] < maxChars) {
                    String trimmed2 = StringUtil.first((String)(" (" + ds[0] + ")"), (int)(maxChars - count[0]), (boolean)false);
                    count[0] = count[0] + trimmed2.length();
                    renderer.append(trimmed2, (SimpleTextAttributes)ObjectUtils.notNull((Object)forcedAttrs, (Object)SimpleTextAttributes.GRAY_ATTRIBUTES));
                }
                ds[0] = null;
            }
            first[0] = false;
            if (count[0] >= maxChars) {
                count[0] = -1;
            }
        });
        if (count[0] == -1) {
            renderer.append("...", (SimpleTextAttributes)ObjectUtils.notNull((Object)forcedAttrs, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
        }
    }

    private void format(@NotNull TreePattern pattern, final Formatter consumer) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/sql/dialects/SqlResolveConfigurable", "format"));
        }
        if (pattern.root.groups.length == 0) {
            consumer.consume("<Nothing>", SqlImportUtil.DATA_SOURCE, true, 0);
            return;
        }
        if (SqlResolveConfigurable.isWildcard(pattern.root)) {
            consumer.consume("<Everything>", SqlImportUtil.DATA_SOURCE, true, 0);
            return;
        }
        final DbPsiFacade facade = DbPsiFacade.getInstance((Project)this.myProject);
        new Object(){

            public void visit(TreePatternNode<?> root2, ObjectKind kind, int lvl) {
                TreePatternNode.Group child = root2.getGroup(ObjectKind.DATABASE);
                if (child == null) {
                    child = root2.getGroup(ObjectKind.SCHEMA);
                }
                boolean ds = kind == SqlImportUtil.DATA_SOURCE;
                boolean neg = root2.naming instanceof TreePatternNode.NegativeNaming;
                JBIterable names = ds ? JBIterable.of((Object[])((TreePatternNode.BaseNaming)root2.naming).names).transform(o -> {
                    DbDataSource s = facade.findDataSource(o.name);
                    return s == null ? null : s.getName();
                }).filter(Conditions.notNull()) : JBIterable.of((Object[])((TreePatternNode.BaseNaming)root2.naming).names).transform(o -> o.name);
                String nm = !names.isEmpty() ? (neg ? "<All exc.> " : "") + StringUtil.join((Iterable)names, (String)", ") : (neg ? "<All>" : (ds ? "<None>" : "<Default>"));
                consumer.consume(nm, kind, child == null, lvl);
                this.visit(child, lvl + 1);
            }

            public void visit(TreePatternNode.Group root2, int lvl) {
                if (root2 == null) {
                    return;
                }
                if (root2.positiveChildren != null) {
                    for (TreePatternNode<TreePatternNode.PositiveNaming> p : root2.positiveChildren) {
                        this.visit(p, root2.kind, lvl);
                    }
                }
                if (root2.negativeChild != null) {
                    this.visit(root2.negativeChild, root2.kind, lvl);
                }
            }
        }.visit(pattern.root.getGroup(SqlImportUtil.DATA_SOURCE), 0);
    }

    private static boolean isWildcard(TreePatternNode node) {
        return node == null || TreePatternUtils.isWildcard(node.getGroup(SqlImportUtil.DATA_SOURCE));
    }

    @Nls
    public String getDisplayName() {
        return SqlMessages.message("sql.resolve.configurable", new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.project.sql.resolve";
    }

    @NotNull
    protected JBPopup createValueEditorPopup(@Nullable Object target, @Nullable TreePattern value, @Nullable Runnable onDispose, @NotNull DataContext dataContext, final @NotNull Consumer<TreePattern> onChosen, @NotNull Runnable onCommit) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/sql/dialects/SqlResolveConfigurable", "createValueEditorPopup"));
        }
        if (onChosen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onChosen", "com/intellij/sql/dialects/SqlResolveConfigurable", "createValueEditorPopup"));
        }
        if (onCommit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onCommit", "com/intellij/sql/dialects/SqlResolveConfigurable", "createValueEditorPopup"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            JBPopup jBPopup = super.createValueEditorPopup(target, (Object)value, onDispose, dataContext, onChosen, onCommit);
            if (jBPopup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveConfigurable", "createValueEditorPopup"));
            }
            return jBPopup;
        }
        final SqlResolveEditor editor = new SqlResolveEditor(project);
        editor.getTree().getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesChanged(TreeModelEvent event) {
                onChosen.consume((Object)editor.getPattern(editor.getEditorState()));
            }
        });
        if (value == null) {
            value = this.getDefaultMapping(target);
        }
        editor.setPatterns(value, value);
        final Ref popupRef = Ref.create(null);
        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder(editor.getComponent(), (JComponent)editor.getTree()).setKeyEventHandler(event -> {
            if (event.getID() == 401) {
                if (event.getKeyCode() == 27 && !editor.hasSpeedSearchActive()) {
                    ((JBPopup)popupRef.get()).cancel();
                    return true;
                }
                if (event.getKeyCode() == 10) {
                    ((JBPopup)popupRef.get()).cancel();
                    return true;
                }
            }
            return false;
        }).setDimensionServiceKey(project, "SqlResolveConfigurable", false).setRequestFocus(true).setResizable(true).addListener((JBPopupListener)new JBPopupListener.Adapter(){

            public void beforeShown(LightweightWindowEvent event) {
                ((AbstractPopup)popupRef.get()).setShowHints(true);
            }
        }).createPopup();
        popupRef.set((Object)popup);
        popup.setFinalRunnable(() -> {
            if (onCommit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onCommit", "com/intellij/sql/dialects/SqlResolveConfigurable", "lambda$createValueEditorPopup$2"));
            }
            onCommit.run();
            if (onDispose != null) {
                onDispose.run();
            }
        });
        JBPopup jBPopup = popup;
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveConfigurable", "createValueEditorPopup"));
        }
        return jBPopup;
    }

    @NotNull
    protected List<Trinity<String, Producer<TreePattern>, Consumer<TreePattern>>> getDefaultMappings() {
        List<Trinity<String, Producer<TreePattern>, Consumer<TreePattern>>> list = Collections.singletonList(Trinity.create((Object)"Project mapping", () -> (TreePattern)SqlResolveMappings.getInstance(this.myProject).getConfiguredMapping(null), o -> SqlResolveMappings.getInstance(this.myProject).setMapping(null, o)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveConfigurable", "getDefaultMappings"));
        }
        return list;
    }

    protected String getToolTipFor(TreePattern value) {
        if (value == null) {
            value = SqlResolveMappings.ALL_DATA_SOURCES;
        }
        SimpleColoredText renderer = new SimpleColoredText();
        this.renderValue(value, (ColoredTextContainer)renderer, null, 200);
        StringBuilder html = new StringBuilder("<html>");
        for (String s : renderer.getTexts()) {
            if (s.equals(", ")) {
                html.append("<br>");
                continue;
            }
            html.append(StringUtil.escapeXml((String)s));
        }
        html.append("</html>");
        return html.toString();
    }

    @FunctionalInterface
    private static interface Formatter {
        public void consume(String var1, ObjectKind var2, boolean var3, int var4);
    }
}

