/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespaceSkippedCallback;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.common.SqlGeneratedParser;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.postgres.PgDdlParsing;
import com.intellij.sql.dialects.postgres.PgDmlParsing;
import com.intellij.sql.dialects.postgres.PgExpressionParsing;
import com.intellij.sql.dialects.postgres.PgGeneratedParser;
import com.intellij.sql.dialects.postgres.PgPlParsing;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.PostgresDialect;
import com.intellij.sql.dialects.postgres.PostgresElementTypes;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.parser.SqlParser;
import com.intellij.sql.psi.impl.parser.SqlParserUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public class PostgresParser
extends SqlParser {
    private final boolean myPlSql;
    private boolean myPsqlSameLine;
    int codeBlockMode;

    public PostgresParser(boolean pl) {
        super(pl ? PostgresDialect.PlDialect.INSTANCE : PostgresDialect.INSTANCE);
        this.myPlSql = pl;
    }

    @Override
    public IElementType parseLiteralOther(PsiBuilder builder, int level) {
        if (SqlParserUtil.consumeOptionalToken(builder, PgTypes.PG_ARRAY) && PgGeneratedParser.array_literal(builder, level)) {
            return SQL_ARRAY_LITERAL;
        }
        return super.parseLiteralOther(builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = PgExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error("<expression> expected");
        }
        return result;
    }

    @Override
    protected boolean allowNoopStringConcatenation(final PsiBuilder builder, boolean first) {
        final Ref newLine = Ref.create();
        builder.setWhitespaceSkippedCallback(new WhitespaceSkippedCallback(){

            public void onSkip(IElementType type, int start, int end) {
                newLine.set((Object)(StringUtil.countNewLines((CharSequence)StringUtil.notNullize((String)builder.getTokenText())) > 0 ? 1 : 0));
            }
        });
        boolean result = builder.getTokenType() == SQL_STRING_TOKEN && (first || Boolean.TRUE.equals(newLine.get()));
        builder.setWhitespaceSkippedCallback(null);
        return result;
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        if (this.myPlSql) {
            return PgPlParsing.pl_statement(builder, level);
        }
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)PG_PSQL_BACKSLASH) && (this.myPsqlSameLine || SqlParserUtil.endsWithNewLine(builder))) {
            return this.parsePsqlMetaCommand(builder, level);
        }
        return PgGeneratedParser.statement(builder, level);
    }

    private boolean parsePsqlMetaCommand(PsiBuilder builder, int level) {
        if (!SqlParserUtil.nextTokenIs(builder, (IElementType)PG_PSQL_BACKSLASH)) {
            return false;
        }
        this.myPsqlSameLine = false;
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        if (builder.rawLookup(0) == PG_PSQL_BACKSLASH) {
            builder.advanceLexer();
        } else {
            SqlGeneratedParserUtil.parseAsTree(builder, level, (IElementType)SqlCompositeElementTypes.SQL_GENERIC_ELEMENT, true, GeneratedParserUtilBase.TOKEN_ADVANCER, new GeneratedParserUtilBase.Parser(){

                public boolean parse(PsiBuilder builder, int level) {
                    return !(PostgresParser.this.myPsqlSameLine = SqlParserUtil.nextTokenIs(builder, (IElementType)SqlTokens.PG_PSQL_BACKSLASH)) && !SqlParserUtil.endsWithNewLine(builder);
                }
            });
        }
        mark.done((IElementType)PostgresElementTypes.PG_PSQL_META_COMMAND);
        this.statementSeparatorParsed();
        return true;
    }

    @Override
    @Nullable
    protected IElementType parseTimestampLiteral(PsiBuilder builder) {
        boolean result = GeneratedParserUtilBase.consumeTokens((PsiBuilder)builder, (int)0, (IElementType[])new IElementType[]{PgTypes.PG_WITH, PgTypes.PG_TIME, PgTypes.PG_ZONE});
        if (!result) {
            GeneratedParserUtilBase.consumeTokens((PsiBuilder)builder, (int)0, (IElementType[])new IElementType[]{PgTypes.PG_WITHOUT, PgTypes.PG_TIME, PgTypes.PG_ZONE});
        }
        return super.parseTimestampLiteral(builder);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return PgGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return PgDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level) {
        return PgDdlParsing.type_element(builder, level);
    }

    @Override
    public boolean consumeUnderscoreAndCharSpec(PsiBuilder builder) {
        return false;
    }

    @Override
    public boolean mergeOperatorWithQuestionMark(PsiBuilder builder) {
        PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)((PsiElement)builder.getUserDataUnprotected(FileContextUtil.CONTAINING_FILE_KEY)));
        return host == null;
    }

    @Override
    protected boolean parsingOperatorsAsIdentifier() {
        return false;
    }

    @Override
    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        IElementType result;
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_CUSTOM_LQUOTE)) {
            result = this.parseStringLiteralInner(builder);
        } else if (this.myPlSql && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_IDENT) && builder.getTokenText() != null && builder.getTokenText().startsWith("$")) {
            this.consumeIdentifier(builder);
            result = SQL_VARIABLE_REFERENCE;
        } else {
            result = super.consumeCustomParameterReference(builder);
        }
        return result;
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, PgExpressionParsing::parenthesized_values_expr, PgDmlParsing::top_query_expression, PostgresParser::parseTopQueryExpressionTail, PgExpressionParsing::row_element_list, (b, l) -> PgExpressionParsing.root_expr_0(b, l, -1) && PgExpressionParsing.row_element_list_separator(b, l) && PgExpressionParsing.row_element_list(b, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, PgDmlParsing::parenthesized_aliased_join_expression, PgDmlParsing::top_query_expression, PostgresParser::parseTopQueryExpressionTail, (b, l) -> PgDmlParsing.join_expression(b, l, -1), (b, l) -> PgDmlParsing.join_expression_0(b, l, -1));
    }

    @Override
    protected boolean parsePrototypeTail(PsiBuilder builder, int level, SqlFunctionDefinition.Prototype parameter, SqlParser.FunctionParsingContext context) {
        if (!super.parsePrototypeTail(builder, level, parameter, context)) {
            return false;
        }
        if (parameter != null && ("true".equals(parameter.getAttributes().get("analytic")) || "true".equals(parameter.getAttributes().get("aggregate")))) {
            PgGeneratedParser.analytic_clause(builder, level);
        }
        return true;
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        if (PgGeneratedParser.within_group_clause(builder, level) || PgGeneratedParser.analytic_clause(builder, level)) {
            IElementType type;
            LighterASTNode ref = SqlGeneratedParserUtil.getExposedFunctionRef(builder);
            IElementType iElementType = type = ref == null ? null : ref.getTokenType();
            if (type == SQL_REFERENCE || type == SQL_ANY_CALLABLE_REFERENCE) {
                ((PsiBuilderImpl.ProductionMarker)ref).remapTokenType((IElementType)SQL_FUNCTION_REFERENCE);
            }
        }
        return true;
    }

    @Override
    protected boolean allowIntervalLiteral() {
        return false;
    }

    @Override
    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, SqlFunctionDefinition definition, boolean allowNoParens) {
        if (super.parseFunctionParametersAndParens(builder, level, functionName, definition, allowNoParens)) {
            if (definition != null && ("true".equals(definition.getDialectAttribute("analytic")) || "true".equals(definition.getDialectAttribute("aggregate")))) {
                PgGeneratedParser.analytic_clause(builder, level);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean parseFunctionParametersEnd(PsiBuilder builder, int level, SqlFunctionDefinition definition) {
        PgDmlParsing.order_by_clause(builder, level);
        return true;
    }

    @Override
    public boolean parseFunctionParametersStart(PsiBuilder builder, int level, SqlFunctionDefinition definition) {
        boolean ignored = SqlParserUtil.consumeOptionalToken(builder, PgTypes.PG_ALL) || SqlParserUtil.consumeOptionalToken(builder, PgTypes.PG_DISTINCT);
        return true;
    }

    @Override
    protected boolean parseTypedReference(PsiBuilder builder, SqlReferenceElementType refType) {
        boolean result = super.parseTypedReference(builder, refType);
        if (!result && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_STRING_TOKEN)) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            mark.done((IElementType)SQL_IDENTIFIER);
            mark.precede().done((IElementType)refType);
            result = true;
        }
        if (result && SqlParserUtil.consumeOptionalToken(builder, (IElementType)PG_OP_TYPE_CAST)) {
            PsiBuilder.Marker marker = (PsiBuilder.Marker)ObjectUtils.assertNotNull((Object)((PsiBuilder.Marker)builder.getLatestDoneMarker()));
            PgPlParsing.type_element_ext_inner(builder, 0);
            marker.precede().done((IElementType)SQL_BINARY_EXPRESSION);
        }
        return result;
    }

    @Override
    public boolean parseFunctionArgument(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean variadic = SqlParserUtil.consumeToken(builder, true, PgTypes.PG_VARIADIC);
        return super.parseFunctionArgument(builder, level, optional && !variadic, allowBoolean);
    }

    @Override
    public boolean parseNamedFunctionArgumentPrefix(PsiBuilder builder, int level) {
        PsiBuilder.Marker mark = builder.mark();
        boolean result = this.parseReferenceExpression(builder, true, SQL_ARGUMENT_REFERENCE);
        if (result && !(result = SqlParserUtil.consumeToken(builder, true, (IElementType)SqlTokens.SQL_OP_ASSIGN))) {
            result = GeneratedParserUtilBase.consumeToken((PsiBuilder)builder, (String)"=>");
        }
        if (result) {
            mark.drop();
        } else {
            mark.rollbackTo();
        }
        return result;
    }

    @Override
    public boolean argumentListRecover(PsiBuilder builder, int level) {
        return GeneratedParserUtilBase.nextTokenIsSmart((PsiBuilder)builder, (IElementType)PgTypes.PG_ORDER);
    }

    public boolean parseSchemaPath(PsiBuilder builder, int level, boolean strict) {
        if (strict) {
            IElementType type = builder.getTokenType();
            if (type == SQL_STRING_TOKEN) {
                PsiBuilder.Marker m = builder.mark();
                builder.advanceLexer();
                m.done((IElementType)SQL_IDENTIFIER);
                m.precede().done((IElementType)SQL_SCHEMA_REFERENCE);
                return true;
            }
            if (type == SQL_DEFAULT) {
                return true;
            }
        } else if ("search_path".equalsIgnoreCase(((LighterASTNode)ObjectUtils.assertNotNull((Object)builder.getLatestDoneMarker())).toString().trim())) {
            if (SqlParserUtil.consumeToken(builder, true, (IElementType)SQL_DEFAULT)) {
                return true;
            }
            SqlGeneratedParser.simple_list(builder, level, (b, l) -> {
                GeneratedParserUtilBase.addVariant((PsiBuilder)builder, (String)"schema reference");
                PsiBuilder.Marker m = b.mark();
                if (b.getTokenType() != SQL_DEFAULT && this.consumeIdentifier(b, true, true)) {
                    m.done((IElementType)SQL_IDENTIFIER);
                    m.precede().done((IElementType)SQL_SCHEMA_REFERENCE);
                    return true;
                }
                m.drop();
                return false;
            });
            return true;
        }
        return false;
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        PgDmlParsing.query_expression_0(builder, level, -1);
        return PgDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

