/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sqlite;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.sqlite.SqliteDdlParsing;
import com.intellij.sql.dialects.sqlite.SqliteDialect;
import com.intellij.sql.dialects.sqlite.SqliteDmlParsing;
import com.intellij.sql.dialects.sqlite.SqliteExpressionParsing;
import com.intellij.sql.dialects.sqlite.SqliteGeneratedParser;
import com.intellij.sql.psi.impl.parser.SqlParser;
import com.intellij.sql.psi.impl.parser.SqlParserUtil;

public class SqliteParser
extends SqlParser {
    public SqliteParser() {
        super(SqliteDialect.INSTANCE);
    }

    @Override
    public boolean allowStringsAsIdentifiers() {
        return true;
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return SqliteGeneratedParser.statement(builder, level);
    }

    @Override
    protected boolean allowOdbcSequences() {
        return false;
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return SqliteGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return SqliteDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level) {
        return SqliteDdlParsing.type_element(builder, level);
    }

    @Override
    protected boolean parseParameterReferenceInner(PsiBuilder builder, IElementType paramToken, IElementType resultType) {
        return super.parseParameterReferenceInner(builder, paramToken, (IElementType)SQL_PARAMETER_REFERENCE);
    }

    @Override
    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        IElementType result = super.consumeCustomParameterReference(builder);
        if (result != null) {
            return result;
        }
        if (!SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_IDENT)) {
            return null;
        }
        String text = builder.getTokenText();
        if (text != null && text.startsWith("$")) {
            result = SQL_PARAMETER_REFERENCE;
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_IDENT);
            while (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_COLON)) {
                SqlParserUtil.consumeToken(builder, (IElementType)SQL_COLON);
                SqlParserUtil.consumeToken(builder, (IElementType)SQL_IDENT);
            }
            if (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_LEFT_PAREN)) {
                SqlParserUtil.consumeAllTokensUpTo(builder, new IElementType[]{SQL_RIGHT_PAREN, SQL_SEMICOLON});
                SqlParserUtil.consumeToken(builder, (IElementType)SQL_RIGHT_PAREN);
            }
        }
        return result;
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = SqliteExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error("<expression> expected");
        }
        return result;
    }
}

