/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlExpressionWrapperImpl<T extends SqlExpression>
extends SqlExpressionImpl {
    public SqlExpressionWrapperImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlExpressionWrapperImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        T expression = this.getWrappedExpression();
        Object object = expression == null ? SqlType.UNKNOWN : expression.getSqlType();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlExpressionWrapperImpl", "getSqlType"));
        }
        return object;
    }

    @Nullable
    public T getWrappedExpression() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof SqlExpressionWrapperImpl) {
                child = child.getFirstChild();
                continue;
            }
            T t = this.transformTarget(child);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    protected T transformTarget(PsiElement child) {
        return (T)(child instanceof SqlExpression ? (SqlExpression)child : null);
    }

    public static class Select
    extends SqlExpressionWrapperImpl<SqlQueryExpression> {
        public Select(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlExpressionWrapperImpl$Select", "<init>"));
            }
            super(node);
        }

        @Override
        protected SqlQueryExpression transformTarget(PsiElement child) {
            return child instanceof SqlSelectStatement ? ((SqlSelectStatement)child).getQueryExpression() : null;
        }
    }

    public static class TableOrQuery
    extends SqlExpressionWrapperImpl<SqlExpression> {
        public TableOrQuery(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlExpressionWrapperImpl$TableOrQuery", "<init>"));
            }
            super(node);
        }

        @Override
        protected SqlExpression transformTarget(PsiElement child) {
            return child instanceof SqlReferenceExpression || child instanceof SqlQueryExpression || child instanceof SqlTableExpression ? (SqlExpression)child : null;
        }
    }
}

