/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlClauseImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlOnTargetClauseImpl
extends SqlClauseImpl
implements SqlExtraDeclarationsProvider {
    public SqlOnTargetClauseImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlOnTargetClauseImpl", "<init>"));
        }
        super(node);
    }

    public SqlExpression getTargetExpression() {
        SqlTableColumnsList tableColumnsList = (SqlTableColumnsList)this.findChildByClass(SqlTableColumnsList.class);
        return tableColumnsList != null ? tableColumnsList.getTableExpression() : (SqlExpression)this.findChildByClass(SqlExpression.class);
    }

    public SqlTableType getTargetType() {
        SqlExpression targetExpression = this.getTargetExpression();
        if (targetExpression == null) {
            return SqlTableTypeBase.EMPTY_TABLE;
        }
        List<SqlReferenceExpression> referenceList = SqlImplUtil.getReferenceList((SqlTableColumnsList)this.findChildByClass(SqlTableColumnsList.class));
        SqlTableType baseType = SqlTableTypeBase.ensureTableType(targetExpression.getSqlType(), (SqlElement)targetExpression, (PsiElement)this);
        if (referenceList.isEmpty()) {
            return baseType;
        }
        return baseType.alias(null, (PsiElement)this, referenceList);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlClause((SqlClause)this);
    }

    public boolean processExtraDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlExpression targetRoot;
        SqlExpression targetExpression = this.getTargetExpression();
        Object object = targetRoot = targetExpression != null && targetExpression.getParent() instanceof SqlTableColumnsList ? (SqlTableColumnsList)targetExpression.getParent() : targetExpression;
        if (lastParent != targetRoot && targetExpression != null) {
            if (targetExpression instanceof SqlReferenceExpression) {
                if (!SqlImplUtil.processQualifier((SqlReferenceExpression)targetExpression, processor, state, place)) {
                    return false;
                }
            } else {
                if (targetExpression instanceof PsiNamedElement && !processor.execute((PsiElement)targetExpression, state)) {
                    return false;
                }
                SqlType type = targetExpression.getSqlType();
                if (type instanceof SqlTableType && !SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, state)) {
                    return false;
                }
            }
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }
}

