/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalModuleBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class BuildClasspathModuleGradleDataService
extends AbstractProjectDataService<BuildScriptClasspathData, Module> {
    private static final Logger LOG = Logger.getInstance(BuildClasspathModuleGradleDataService.class);

    @NotNull
    public Key<BuildScriptClasspathData> getTargetDataKey() {
        Key<BuildScriptClasspathData> key = BuildScriptClasspathData.KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<BuildScriptClasspathData>> toImport, final @Nullable ProjectData projectData, final @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService", "importData"));
        }
        if (projectData == null || toImport.isEmpty()) {
            return;
        }
        final GradleInstallationManager gradleInstallationManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager != null);
        AbstractExternalSystemLocalSettings localSettings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        final String linkedExternalProjectPath = projectData.getLinkedExternalProjectPath();
        File gradleHomeDir = ((BuildScriptClasspathData)((Object)toImport.iterator().next().getData())).getGradleHomeDir();
        GradleLocalSettings gradleLocalSettings = GradleLocalSettings.getInstance(project);
        if (gradleHomeDir != null) {
            gradleLocalSettings.setGradleHome(linkedExternalProjectPath, gradleHomeDir.getPath());
        }
        GradleProjectSettings settings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(linkedExternalProjectPath);
        NotNullLazyValue<Set<String>> externalProjectGradleSdkLibs = new NotNullLazyValue<Set<String>>(){

            @NotNull
            protected Set<String> compute() {
                List<File> libraries;
                LinkedHashSet gradleSdkLibraries = ContainerUtil.newLinkedHashSet();
                File gradleHome = gradleInstallationManager.getGradleHome(project, linkedExternalProjectPath);
                if (gradleHome != null && gradleHome.isDirectory() && (libraries = gradleInstallationManager.getClassRoots(project, linkedExternalProjectPath)) != null) {
                    for (File library : libraries) {
                        gradleSdkLibraries.add(FileUtil.toCanonicalPath((String)library.getPath()));
                    }
                }
                LinkedHashSet linkedHashSet = gradleSdkLibraries;
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService$1", "compute"));
                }
                return linkedHashSet;
            }
        };
        NotNullLazyValue<Set<String>> buildSrcProjectsRoots = new NotNullLazyValue<Set<String>>(){

            @NotNull
            protected Set<String> compute() {
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                result.add(linkedExternalProjectPath + "/buildSrc/src/main/java");
                result.add(linkedExternalProjectPath + "/buildSrc/src/main/groovy");
                for (Module module : modelsProvider.getModules(projectData)) {
                    String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
                    if (projectPath == null || !StringUtil.startsWith((CharSequence)projectPath, (CharSequence)(linkedExternalProjectPath + "/buildSrc"))) continue;
                    List sourceRoots = ContainerUtil.map((Object[])modelsProvider.getSourceRoots(module, false), VirtualFile::getPath);
                    result.addAll(sourceRoots);
                }
                LinkedHashSet<String> linkedHashSet = result;
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService$2", "compute"));
                }
                return linkedHashSet;
            }
        };
        HashMap localProjectBuildClasspath = ContainerUtil.newHashMap((Map)localSettings.getProjectBuildClasspath());
        for (DataNode<BuildScriptClasspathData> node : toImport) {
            DataNode moduleDataNode;
            if (!GradleConstants.SYSTEM_ID.equals((Object)((BuildScriptClasspathData)((Object)node.getData())).getOwner()) || (moduleDataNode = ExternalSystemApiUtil.findParent(node, (Key)ProjectKeys.MODULE)) == null) continue;
            String externalModulePath = ((ModuleData)moduleDataNode.getData()).getLinkedExternalProjectPath();
            if (settings == null || settings.getDistributionType() == null) {
                LOG.warn("Gradle SDK distribution type was not configured for the project at " + linkedExternalProjectPath);
            }
            LinkedHashSet buildClasspath = ContainerUtil.newLinkedHashSet();
            BuildScriptClasspathData buildScriptClasspathData = (BuildScriptClasspathData)((Object)node.getData());
            for (BuildScriptClasspathData.ClasspathEntry classpathEntry : buildScriptClasspathData.getClasspathEntries()) {
                for (String path : classpathEntry.getSourcesFile()) {
                    buildClasspath.add(FileUtil.toCanonicalPath((String)path));
                }
                for (String path : classpathEntry.getClassesFile()) {
                    buildClasspath.add(FileUtil.toCanonicalPath((String)path));
                }
            }
            ExternalProjectBuildClasspathPojo projectBuildClasspathPojo = (ExternalProjectBuildClasspathPojo)localProjectBuildClasspath.get(linkedExternalProjectPath);
            if (projectBuildClasspathPojo == null) {
                projectBuildClasspathPojo = new ExternalProjectBuildClasspathPojo(((ModuleData)moduleDataNode.getData()).getExternalName(), (List)ContainerUtil.newArrayList(), (Map)ContainerUtil.newHashMap());
                localProjectBuildClasspath.put(linkedExternalProjectPath, projectBuildClasspathPojo);
            }
            ArrayList projectBuildClasspath = ContainerUtil.newArrayList((Iterable)((Iterable)externalProjectGradleSdkLibs.getValue()));
            projectBuildClasspath.addAll((Collection)buildSrcProjectsRoots.getValue());
            projectBuildClasspathPojo.setProjectBuildClasspath((List)projectBuildClasspath);
            projectBuildClasspathPojo.getModulesBuildClasspath().put(externalModulePath, new ExternalModuleBuildClasspathPojo(externalModulePath, (List)ContainerUtil.newArrayList((Iterable)buildClasspath)));
        }
        localSettings.setProjectBuildClasspath((Map)localProjectBuildClasspath);
        if (!project.isDisposed()) {
            GradleBuildClasspathManager.getInstance(project).reload();
        }
    }
}

