/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.CompositeBuildData;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Order(value=-2147483645)
public class CompositeBuildDataService
extends AbstractProjectDataService<CompositeBuildData, Project> {
    @NotNull
    public Key<CompositeBuildData> getTargetDataKey() {
        Key<CompositeBuildData> key = CompositeBuildData.KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/CompositeBuildDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<CompositeBuildData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/CompositeBuildDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/CompositeBuildDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/CompositeBuildDataService", "importData"));
        }
        if (toImport.isEmpty()) {
            GradleProjectSettings projectSettings;
            if (projectData != null && (projectSettings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(projectData.getLinkedExternalProjectPath())) != null && projectSettings.getCompositeBuild() != null && projectSettings.getCompositeBuild().getCompositeDefinitionSource() == CompositeDefinitionSource.SCRIPT) {
                projectSettings.setCompositeBuild(null);
            }
            return;
        }
        if (toImport.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected to get a single composite data node but got %d: %s", toImport.size(), toImport));
        }
        CompositeBuildData compositeBuildData = (CompositeBuildData)toImport.iterator().next().getData();
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(compositeBuildData.getRootProjectPath());
        if (projectSettings != null) {
            GradleProjectSettings.CompositeBuild compositeBuild = new GradleProjectSettings.CompositeBuild();
            compositeBuild.setCompositeDefinitionSource(CompositeDefinitionSource.SCRIPT);
            for (BuildParticipant buildParticipant : compositeBuildData.getCompositeParticipants()) {
                compositeBuild.getCompositeParticipants().add(buildParticipant.copy());
            }
            projectSettings.setCompositeBuild(compositeBuild);
        }
    }
}

