/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.beans;

import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectionPointDescriptor {
    private PsiModifierListOwner myOwner;

    public InjectionPointDescriptor(PsiModifierListOwner owner) {
        this.myOwner = owner;
    }

    @Nullable
    public PsiType getType() {
        if (this.myOwner instanceof PsiField) {
            return ((PsiField)this.myOwner).getType();
        }
        if (this.myOwner instanceof PsiParameter) {
            return ((PsiParameter)this.myOwner).getType();
        }
        return null;
    }

    public PsiAnnotation[] getQualifierAnnotations() {
        return CdiCommonUtils.getQualifierAnnotations(this.myOwner);
    }

    @NotNull
    public PsiModifierListOwner getOwner() {
        PsiModifierListOwner psiModifierListOwner = this.myOwner;
        if (psiModifierListOwner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/beans/InjectionPointDescriptor", "getOwner"));
        }
        return psiModifierListOwner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InjectionPointDescriptor)) {
            return false;
        }
        InjectionPointDescriptor that = (InjectionPointDescriptor)o;
        return !(this.myOwner != null ? !this.myOwner.equals(that.myOwner) : that.myOwner != null);
    }

    public int hashCode() {
        return this.myOwner != null ? this.myOwner.hashCode() : 0;
    }
}

