/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.jam.inject;

import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.jam.JamElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.reflect.JamFieldMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.semantic.SemKey;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CdiInject<T extends PsiMember>
implements JamElement {
    public static final SemKey<CdiInject> SEM_KEY = SemKey.createKey((String)"CdiInject", (SemKey[])new SemKey[0]);
    public static final JamMethodMeta<CdiInject> METHOD_META = new JamMethodMeta(null, Method.class, SEM_KEY);
    public static final JamFieldMeta<CdiInject> FIELD_META = new JamFieldMeta(null, Field.class, SEM_KEY);

    public abstract List<InjectionPointDescriptor> getInjectionPoints();

    @NotNull
    public PsiAnnotation[] getQualifierAnnotations() {
        Module module = ModuleUtilCore.findModuleForPsiElement(this.getPsiElement());
        if (module == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/inject/CdiInject", "getQualifierAnnotations"));
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] psiAnnotationArray = CdiCommonUtils.getQualifierAnnotations(this.getPsiElement());
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/inject/CdiInject", "getQualifierAnnotations"));
        }
        return psiAnnotationArray;
    }

    @JamPsiConnector
    @NotNull
    public abstract T getPsiElement();

    @JamPsiValidity
    public abstract boolean isPsiValid();

    public static abstract class Method
    extends CdiInject<PsiMethod> {
        @Override
        public List<InjectionPointDescriptor> getInjectionPoints() {
            return CdiInjectionUtils.getInjectionPoints((PsiMethod)this.getPsiElement());
        }
    }

    public static abstract class Field
    extends CdiInject<PsiField> {
        public PsiType getType() {
            return ((PsiField)this.getPsiElement()).getType();
        }

        @Override
        public List<InjectionPointDescriptor> getInjectionPoints() {
            return Collections.singletonList(new InjectionPointDescriptor((PsiModifierListOwner)this.getPsiElement()));
        }
    }
}

