/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.model.xml.converters;

import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PatternPackageReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.PsiClassConverter;
import com.intellij.util.xml.PsiPackageConverter;
import com.intellij.util.xml.WrappingConverter;
import org.jetbrains.annotations.NotNull;

public class ExcludeNameConverter
extends WrappingConverter {
    private static final PsiClassConverter myClassConverter = new PsiClassConverter();
    private static final PsiPackageConverter myAnnotationTypeClassConverter = new PsiPackageConverter(){

        @NotNull
        public PsiReference[] createReferences(GenericDomValue<PsiPackage> genericDomValue, PsiElement element, ConvertContext context) {
            String s = genericDomValue.getStringValue();
            if (s == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/model/xml/converters/ExcludeNameConverter$1", "createReferences"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            GlobalSearchScope scope = context.getSearchScope();
            PsiReference[] psiReferenceArray = new PatternPackageReferenceSet(s, element, ElementManipulators.getOffsetInElement((PsiElement)element), scope != null ? scope : GlobalSearchScope.allScope((Project)element.getProject())).getPsiReferences();
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/model/xml/converters/ExcludeNameConverter$1", "createReferences"));
            }
            return psiReferenceArray;
        }
    };

    public Converter getConverter(@NotNull GenericDomValue domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/cdi/model/xml/converters/ExcludeNameConverter", "getConverter"));
        }
        String text = domElement.getRawText();
        if (text != null && text.contains("*")) {
            return myAnnotationTypeClassConverter;
        }
        return myClassConverter;
    }
}

