/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.toolWindow.tree.nodes;

import com.intellij.cdi.toolWindow.tree.CdiTreeStructure;
import com.intellij.cdi.toolWindow.tree.nodes.CdiModuleNode;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CdiTreeRootNode
extends SimpleNode {
    private final Project myProject;
    private final CdiTreeStructure myTreeStructure;

    public CdiTreeRootNode(@NotNull Project project, @NotNull CdiTreeStructure cdiTreeStructure) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cdi/toolWindow/tree/nodes/CdiTreeRootNode", "<init>"));
        }
        if (cdiTreeStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cdiTreeStructure", "com/intellij/cdi/toolWindow/tree/nodes/CdiTreeRootNode", "<init>"));
        }
        this.myProject = project;
        this.myTreeStructure = cdiTreeStructure;
    }

    public SimpleNode[] getChildren() {
        if (DumbService.isDumb((Project)this.myProject)) {
            return NO_CHILDREN;
        }
        ArrayList<CdiModuleNode> children = new ArrayList<CdiModuleNode>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (!CdiCommonUtils.isCdiInstalled(module)) continue;
            children.add(new CdiModuleNode(module, this.myTreeStructure, this));
        }
        return children.toArray(new SimpleNode[children.size()]);
    }

    public boolean isAutoExpandNode() {
        return true;
    }
}

