/*
 * Decompiled with CFR 0.152.
 */
package com.android.assetstudiolib;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.ide.common.util.AssetUtil;
import com.android.resources.Density;
import com.android.utils.Pair;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class LauncherIconGenerator
extends GraphicGenerator {
    private static final Rectangle IMAGE_SIZE_WEB = new Rectangle(0, 0, 512, 512);
    private static final Rectangle IMAGE_SIZE_MDPI = new Rectangle(0, 0, 48, 48);
    private static final Map<Pair<GraphicGenerator.Shape, Density>, Rectangle> TARGET_RECTS = new HashMap<Pair<GraphicGenerator.Shape, Density>, Rectangle>();

    private static GraphicGenerator.Shape applyDog(GraphicGenerator.Shape shape) {
        if (shape == GraphicGenerator.Shape.SQUARE) {
            return GraphicGenerator.Shape.SQUARE_DOG;
        }
        if (shape == GraphicGenerator.Shape.HRECT) {
            return GraphicGenerator.Shape.HRECT_DOG;
        }
        if (shape == GraphicGenerator.Shape.VRECT) {
            return GraphicGenerator.Shape.VRECT_DOG;
        }
        return shape;
    }

    @Override
    public BufferedImage generate(GraphicGeneratorContext context, GraphicGenerator.Options options) {
        Rectangle targetRect;
        LauncherOptions launcherOptions = (LauncherOptions)options;
        String density = launcherOptions.isWebGraphic ? "web" : launcherOptions.density.getResourceValue();
        if (launcherOptions.isDogEar) {
            launcherOptions.shape = LauncherIconGenerator.applyDog(launcherOptions.shape);
        }
        BufferedImage shapeImageBack = null;
        BufferedImage shapeImageFore = null;
        BufferedImage shapeImageMask = null;
        if (launcherOptions.shape != GraphicGenerator.Shape.NONE && launcherOptions.shape != null) {
            String shape = launcherOptions.shape.id;
            shapeImageBack = context.loadImageResource("/images/launcher_stencil/" + shape + "/" + density + "/back.png");
            shapeImageFore = context.loadImageResource("/images/launcher_stencil/" + shape + "/" + density + "/" + launcherOptions.style.id + ".png");
            shapeImageMask = context.loadImageResource("/images/launcher_stencil/" + shape + "/" + density + "/mask.png");
        }
        Rectangle imageRect = IMAGE_SIZE_WEB;
        if (!launcherOptions.isWebGraphic) {
            imageRect = AssetUtil.scaleRectangle((Rectangle)IMAGE_SIZE_MDPI, (float)GraphicGenerator.getMdpiScaleFactor(launcherOptions.density));
        }
        if ((targetRect = TARGET_RECTS.get(Pair.of((Object)((Object)launcherOptions.shape), (Object)launcherOptions.density))) == null) {
            targetRect = AssetUtil.scaleRectangle((Rectangle)TARGET_RECTS.get(Pair.of((Object)((Object)launcherOptions.shape), (Object)Density.MEDIUM)), (float)GraphicGenerator.getMdpiScaleFactor(launcherOptions.density));
        }
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        if (shapeImageBack != null) {
            gOut.drawImage((Image)shapeImageBack, 0, 0, null);
        }
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)tempImage.getGraphics();
        if (shapeImageMask != null) {
            gTemp.drawImage(shapeImageMask, 0, 0, null);
            gTemp.setComposite(AlphaComposite.SrcAtop);
            gTemp.setPaint(new Color(launcherOptions.backgroundColor));
            gTemp.fillRect(0, 0, imageRect.width, imageRect.height);
        }
        BufferedImage iconImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gIcon = (Graphics2D)iconImage.getGraphics();
        if (launcherOptions.crop) {
            AssetUtil.drawCenterCrop((Graphics2D)gIcon, (BufferedImage)launcherOptions.sourceImage, (Rectangle)targetRect);
        } else {
            AssetUtil.drawCenterInside((Graphics2D)gIcon, (BufferedImage)launcherOptions.sourceImage, (Rectangle)targetRect);
        }
        AssetUtil.Effect[] effects = launcherOptions.useForegroundColor ? new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(launcherOptions.foregroundColor), 1.0)} : new AssetUtil.Effect[]{};
        AssetUtil.drawEffects((Graphics2D)gTemp, (BufferedImage)iconImage, (int)0, (int)0, (AssetUtil.Effect[])effects);
        gOut.drawImage((Image)tempImage, 0, 0, null);
        if (shapeImageFore != null) {
            gOut.drawImage((Image)shapeImageFore, 0, 0, null);
        }
        gOut.dispose();
        gTemp.dispose();
        gIcon.dispose();
        return outImage;
    }

    @Override
    protected boolean includeDensity(Density density) {
        return super.includeDensity(density) || density == Density.XXXHIGH;
    }

    @Override
    public void generate(String category, Map<String, Map<String, BufferedImage>> categoryMap, GraphicGeneratorContext context, GraphicGenerator.Options options, String name) {
        LauncherOptions launcherOptions = (LauncherOptions)options;
        boolean generateWebImage = launcherOptions.isWebGraphic;
        launcherOptions.isWebGraphic = false;
        super.generate(category, categoryMap, context, options, name);
        if (generateWebImage) {
            launcherOptions.isWebGraphic = true;
            launcherOptions.density = null;
            BufferedImage image = this.generate(context, options);
            if (image != null) {
                HashMap<String, BufferedImage> imageMap = new HashMap<String, BufferedImage>();
                categoryMap.put("Web", imageMap);
                imageMap.put(this.getIconPath(options, name), image);
            }
        }
    }

    @Override
    protected String getIconPath(GraphicGenerator.Options options, String name) {
        if (((LauncherOptions)options).isWebGraphic) {
            return name + "-web.png";
        }
        return super.getIconPath(options, name);
    }

    static {
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.NONE), null), new Rectangle(32, 32, 448, 448));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.NONE), (Object)Density.HIGH), new Rectangle(4, 4, 64, 64));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.NONE), (Object)Density.MEDIUM), new Rectangle(3, 3, 42, 42));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.CIRCLE), null), new Rectangle(21, 21, 470, 470));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.CIRCLE), (Object)Density.HIGH), new Rectangle(3, 3, 66, 66));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.CIRCLE), (Object)Density.MEDIUM), new Rectangle(2, 2, 44, 44));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.SQUARE), null), new Rectangle(53, 53, 406, 406));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.SQUARE), (Object)Density.HIGH), new Rectangle(7, 7, 57, 57));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.SQUARE), (Object)Density.MEDIUM), new Rectangle(5, 5, 38, 38));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.VRECT), null), new Rectangle(85, 21, 342, 470));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.VRECT), (Object)Density.HIGH), new Rectangle(12, 3, 48, 66));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.VRECT), (Object)Density.MEDIUM), new Rectangle(8, 2, 32, 44));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.HRECT), null), new Rectangle(21, 85, 470, 342));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.HRECT), (Object)Density.HIGH), new Rectangle(3, 12, 66, 48));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.HRECT), (Object)Density.MEDIUM), new Rectangle(2, 8, 44, 32));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.SQUARE_DOG), null), new Rectangle(53, 149, 406, 312));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.SQUARE_DOG), (Object)Density.HIGH), new Rectangle(7, 21, 57, 43));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.SQUARE_DOG), (Object)Density.MEDIUM), new Rectangle(5, 14, 38, 29));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.VRECT_DOG), null), new Rectangle(85, 117, 342, 374));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.VRECT_DOG), (Object)Density.HIGH), new Rectangle(12, 17, 48, 52));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.VRECT_DOG), (Object)Density.MEDIUM), new Rectangle(8, 11, 32, 35));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.HRECT_DOG), null), new Rectangle(21, 85, 374, 342));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.HRECT_DOG), (Object)Density.HIGH), new Rectangle(3, 12, 52, 48));
        TARGET_RECTS.put((Pair<GraphicGenerator.Shape, Density>)Pair.of((Object)((Object)GraphicGenerator.Shape.HRECT_DOG), (Object)Density.MEDIUM), new Rectangle(2, 8, 35, 32));
    }

    public static class LauncherOptions
    extends GraphicGenerator.Options {
        public boolean useForegroundColor = true;
        public int foregroundColor = 0;
        public int backgroundColor = 0;
        public boolean crop = true;
        public GraphicGenerator.Shape shape = GraphicGenerator.Shape.SQUARE;
        public GraphicGenerator.Style style = GraphicGenerator.Style.SIMPLE;
        public boolean isDogEar = false;
        public boolean isWebGraphic;

        public LauncherOptions() {
            this.mipmap = true;
        }
    }
}

