/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;

public class HardwareIdDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(HardwareIdDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("HardwareIds", "Hardware Id Usage", "Using device identifiers is not recommended other than for high value fraud prevention and advanced telephony use-cases. For advertising use-cases, use `AdvertisingIdClient$Info#getId` and for analytics, use `InstanceId#getId`.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/articles/user-data-ids.html");
    private static final String BLUETOOTH_ADAPTER_GET_ADDRESS = "getAddress";
    private static final String WIFI_INFO_GET_MAC_ADDRESS = "getMacAddress";
    private static final String TELEPHONY_MANAGER_GET_DEVICE_ID = "getDeviceId";
    private static final String TELEPHONY_MANAGER_GET_LINE_1_NUMBER = "getLine1Number";
    private static final String TELEPHONY_MANAGER_GET_SIM_SERIAL_NUMBER = "getSimSerialNumber";
    private static final String TELEPHONY_MANAGER_GET_SUBSCRIBER_ID = "getSubscriberId";
    private static final String SETTINGS_SECURE_GET_STRING = "getString";
    private static final String PLAY_SERVICES_NOT_AVAILABLE_EXCEPTION = "com.google.android.gms.common.GooglePlayServicesNotAvailableException";

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList(BLUETOOTH_ADAPTER_GET_ADDRESS, WIFI_INFO_GET_MAC_ADDRESS, TELEPHONY_MANAGER_GET_DEVICE_ID, TELEPHONY_MANAGER_GET_LINE_1_NUMBER, TELEPHONY_MANAGER_GET_SIM_SERIAL_NUMBER, TELEPHONY_MANAGER_GET_SUBSCRIBER_ID, SETTINGS_SECURE_GET_STRING);
    }

    @Override
    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression node, PsiMethod method) {
        PsiCatchSection surroundingCatchSection;
        JavaEvaluator evaluator = context.getEvaluator();
        String className = null;
        switch (method.getName()) {
            case "getAddress": {
                className = "android.bluetooth.BluetoothAdapter";
                break;
            }
            case "getMacAddress": {
                className = "android.net.wifi.WifiInfo";
                break;
            }
            case "getDeviceId": 
            case "getLine1Number": 
            case "getSimSerialNumber": 
            case "getSubscriberId": {
                className = "android.telephony.TelephonyManager";
                break;
            }
            case "getString": {
                className = "android.provider.Settings.Secure";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (!evaluator.isMemberInClass((PsiMember)method, className)) {
            return;
        }
        if (method.getName().equals(SETTINGS_SECURE_GET_STRING)) {
            if (evaluator.getParameterCount(method) != 2 || node.getArgumentList().getExpressions().length != 2) {
                return;
            }
            String value = ConstantEvaluator.evaluateString(context, (PsiElement)node.getArgumentList().getExpressions()[1], false);
            if (!"android_id".equals(value)) {
                return;
            }
        }
        if (HardwareIdDetector.inCatchPlayServicesNotAvailableException(surroundingCatchSection = (PsiCatchSection)PsiTreeUtil.getParentOfType((PsiElement)node, PsiCatchSection.class, (boolean)true))) {
            return;
        }
        String message = String.format("Using `%1$s` to get device identifiers is not recommended.", method.getName());
        context.report(ISSUE, (PsiElement)node, context.getLocation((PsiElement)node), message);
    }

    private static boolean inCatchPlayServicesNotAvailableException(PsiCatchSection surroundingCatchSection) {
        PsiDisjunctionType disjunctionType;
        PsiType catchType;
        return surroundingCatchSection != null && surroundingCatchSection.getCatchType() != null && ((catchType = surroundingCatchSection.getCatchType()) instanceof PsiDisjunctionType ? (disjunctionType = (PsiDisjunctionType)catchType).getDisjunctions().stream().anyMatch(t -> t.equalsToText(PLAY_SERVICES_NOT_AVAILABLE_EXCEPTION)) : catchType.equalsToText(PLAY_SERVICES_NOT_AVAILABLE_EXCEPTION));
    }
}

