/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlDeprecatedTagInspection;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.codeInspection.htmlInspections.htmltagreplace.ReplaceHtmlTagWithAnotherAction;
import com.intellij.codeInspection.htmlInspections.htmltagreplace.ReplaceHtmlTagWithCssAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlPresentationalElementInspection
extends HtmlLocalInspectionTool {
    @NonNls
    private static final Set<String> ourHtmlReplacableTags = new HashSet();
    @NonNls
    private static final Set<String> ourCssReplacableTags;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.check.presentational.tag", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlPresentationalElementInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("HtmlPresentationalElement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlPresentationalElementInspection", "getShortName"));
        }
        return "HtmlPresentationalElement";
    }

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/htmlInspections/HtmlPresentationalElementInspection", "checkTag"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/htmlInspections/HtmlPresentationalElementInspection", "checkTag"));
        }
        String name = tag.getName().toLowerCase();
        if (HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            if (HtmlUtil.isHtml5Context((XmlElement)tag)) {
                return;
            }
            LocalQuickFix[] fixes = null;
            if (ourCssReplacableTags.contains(name)) {
                fixes = new LocalQuickFix[]{new ReplaceHtmlTagWithCssAction(name)};
                if (ourHtmlReplacableTags.contains(name)) {
                    fixes = new LocalQuickFix[]{fixes[0], new ReplaceHtmlTagWithAnotherAction(name)};
                }
            } else if (ourHtmlReplacableTags.contains(name)) {
                fixes = new LocalQuickFix[]{new ReplaceHtmlTagWithAnotherAction(name)};
            }
            HtmlDeprecatedTagInspection.registerTag(tag, "html.inspections.check.presentational.tag", holder, fixes, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    static {
        ourHtmlReplacableTags.addAll(Arrays.asList("i", "b", "tt"));
        ourCssReplacableTags = new HashSet();
        ourCssReplacableTags.addAll(Arrays.asList("i", "b", "big", "small", "tt"));
    }
}

