/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.model.highlighting.jam.SpringBeanPointerResolveInspection;
import com.intellij.spring.security.model.jam.testing.SpringSecurityJamWithUserDetailsForClass;
import com.intellij.spring.security.model.jam.testing.SpringSecurityJamWithUserDetailsForMethod;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSecurityAnnotationBeanPointersResolveInspection
extends SpringBeanPointerResolveInspection {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/security/highlighting/SpringSecurityAnnotationBeanPointersResolveInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/security/highlighting/SpringSecurityAnnotationBeanPointersResolveInspection", "checkMethod"));
        }
        if (SpringSecurityAnnotationBeanPointersResolveInspection.isPlainJavaFileInSpringModule((PsiElement)method)) {
            ProblemsHolder holder = new ProblemsHolder(manager, method.getContainingFile(), isOnTheFly);
            SpringSecurityJamWithUserDetailsForMethod jamElement = (SpringSecurityJamWithUserDetailsForMethod)SpringSecurityJamWithUserDetailsForMethod.META.getJamElement((PsiModifierListOwner)method);
            if (jamElement != null) {
                SpringSecurityAnnotationBeanPointersResolveInspection.checkBeanPointerResolve((ProblemsHolder)holder, jamElement.getUserDetailsServiceBeanName(), (String)"org.springframework.security.core.userdetails.UserDetailsService");
            }
            return holder.getResultsArray();
        }
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/security/highlighting/SpringSecurityAnnotationBeanPointersResolveInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/security/highlighting/SpringSecurityAnnotationBeanPointersResolveInspection", "checkClass"));
        }
        if (SpringSecurityAnnotationBeanPointersResolveInspection.isPlainJavaFileInSpringModule((PsiElement)aClass)) {
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            SpringSecurityJamWithUserDetailsForClass jamElement = (SpringSecurityJamWithUserDetailsForClass)SpringSecurityJamWithUserDetailsForClass.META.getJamElement((PsiModifierListOwner)aClass);
            if (jamElement != null) {
                SpringSecurityAnnotationBeanPointersResolveInspection.checkBeanPointerResolve((ProblemsHolder)holder, jamElement.getUserDetailsServiceBeanName(), (String)"org.springframework.security.core.userdetails.UserDetailsService");
            }
            return holder.getResultsArray();
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringSecurityAnnotationBeanPointersResolveInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/highlighting/SpringSecurityAnnotationBeanPointersResolveInspection", "getShortName"));
        }
        return "SpringSecurityAnnotationBeanPointersResolveInspection";
    }
}

