/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.security.references.SpringSecurityRolePsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityRolesConverter
extends Converter<List<String>>
implements CustomReferenceConverter<List<String>> {
    public String toString(List<String> strings, ConvertContext context) {
        return StringUtil.join(strings, (String)",");
    }

    public List<String> fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        return SpringCommonUtils.tokenize((String)s);
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<List<String>> genericDomValue, PsiElement element, ConvertContext context) {
        Module module = context.getModule();
        String rolesRawText = genericDomValue.getStringValue();
        if (rolesRawText == null || module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/SpringSecurityRolesConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        List roleNames = StringUtil.split((String)rolesRawText, (String)",", (boolean)true, (boolean)false);
        int i = 0;
        ArrayList<PsiReference> references = new ArrayList<PsiReference>(roleNames.size());
        for (String roleName : roleNames) {
            String roleNameCleaned = roleName.trim();
            references.add(this.createReference(element, module, roleNameCleaned, i));
            ++i;
        }
        PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.toObjectArray(references, PsiReference.class);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/SpringSecurityRolesConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    protected PsiReference createReference(PsiElement element, @NotNull Module module, @NotNull String roleName, int i) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/security/model/xml/converters/SpringSecurityRolesConverter", "createReference"));
        }
        if (roleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roleName", "com/intellij/spring/security/model/xml/converters/SpringSecurityRolesConverter", "createReference"));
        }
        return new SpringSecurityRolePsiReference(element, roleName, module, true);
    }
}

