/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.ws.references.BaseRangedReference;
import com.intellij.ws.references.PropOrderReference;
import com.intellij.ws.references.WSReferenceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JAXBJavaReferenceProvider
extends WSReferenceProvider {
    public ElementPattern<? extends PsiElement> getPattern() {
        PsiJavaElementPattern.Capture name = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideAnnotationParam((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"javax.xml.bind.annotation.XmlType"}), "name");
        PsiJavaElementPattern.Capture propOrder = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideAnnotationParam((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"javax.xml.bind.annotation.XmlType"}), "propOrder");
        return StandardPatterns.or((ElementPattern[])new ElementPattern[]{name, propOrder});
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiAnnotation annotation;
        PsiNameValuePair pair;
        String name;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/JAXBJavaReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ws/references/JAXBJavaReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof PsiJavaToken) {
            element = element.getParent();
        }
        if (!(element instanceof PsiLiteralExpression)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/JAXBJavaReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiArrayInitializerMemberValue) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiNameValuePair && ("name".equals(name = (pair = (PsiNameValuePair)parent).getName()) || "propOrder".equals(name)) && (annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)pair, PsiAnnotation.class)) != null && "javax.xml.bind.annotation.XmlType".equals(annotation.getQualifiedName())) {
            PsiReference[] psiReferenceArray;
            if (name.equals("name")) {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = new ClassReference((PsiLiteralExpression)element);
            } else {
                PsiReference[] psiReferenceArray3 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray3;
                psiReferenceArray3[0] = new PropOrderReference((PsiLiteralExpression)element);
            }
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/JAXBJavaReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/JAXBJavaReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    static class ClassReference
    extends BaseRangedReference {
        public ClassReference(PsiLiteralExpression psiElement) {
            super((PsiElement)psiElement, 1, psiElement.getTextLength() - 1);
        }

        @Nullable
        public PsiElement resolve() {
            PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiClass.class);
            if (clazz != null && StringUtil.capitalize((String)this.getCanonicalText()).equals(clazz.getName())) {
                return clazz;
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray;
            PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiClass.class);
            if (clazz == null) {
                objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = StringUtil.decapitalize((String)clazz.getName());
            }
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/JAXBJavaReferenceProvider$ClassReference", "getVariants"));
            }
            return objectArray;
        }

        public boolean isSoft() {
            return true;
        }
    }
}

