/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.ws.references.MemberReferenceThatKnowsAboutParentClassName;
import com.intellij.ws.references.MyReferenceProvider;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.WsReferenceProvidersHelper;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSDDReferenceProvider
extends MyReferenceProvider {
    @NonNls
    private static final String VALUE_ATTR_NAME = "value";
    @NonNls
    public static final String WSDD_NAMESPACE = "http://xml.apache.org/axis/wsdd/";
    @NonNls
    public static final String WSDD_JAVA_PROVIDER_NAMESPACE = "http://xml.apache.org/axis/wsdd/providers/java";
    @NonNls
    public static final String NAME_ATTR_NAME = "name";
    @NonNls
    public static final String PARAMETER_TAG_NAME = "parameter";
    @NonNls
    private static final String NAME_ATTR_VALUE = "allowedMethods";
    @NonNls
    public static final String NAME_ATTR_VALUE2 = "className";
    @NonNls
    public static final String BEANMAPPING_TAG_NAME = "beanMapping";
    private final MyReferenceProvider myClassProvider = WsReferenceProvidersHelper.acquireClassReferenceProvider();

    @Override
    public String[] getAttributeNames() {
        return new String[]{VALUE_ATTR_NAME};
    }

    @Override
    public ElementFilter getAttributeFilter() {
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ws/references/WSDDReferenceProvider", "getReferencesByElement"));
        }
        XmlAttribute attr = (XmlAttribute)psiElement.getParent();
        XmlTag tag = attr.getParent();
        if (VALUE_ATTR_NAME.equals(attr.getName()) && PARAMETER_TAG_NAME.equals(tag.getLocalName()) && WSDD_NAMESPACE.equals(tag.getNamespace())) {
            String name = tag.getAttributeValue(NAME_ATTR_NAME);
            if (NAME_ATTR_VALUE.equals(name)) {
                String s = StringUtil.stripQuotesAroundValue((String)psiElement.getText());
                if (s.length() > 0) {
                    ArrayList<WSMethodReference> refs = new ArrayList<WSMethodReference>(1);
                    int lastOffset = 1;
                    int ind = s.indexOf(32);
                    while (ind >= 0) {
                        refs.add(new WSMethodReference(psiElement, new TextRange(lastOffset, ind + 1)));
                        lastOffset = ind + 2;
                        ind = s.indexOf(32, ind + 1);
                    }
                    refs.add(new WSMethodReference(psiElement, new TextRange(lastOffset, s.length() + 1)));
                    PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDDReferenceProvider", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
            } else if (NAME_ATTR_VALUE2.equals(name)) {
                PsiReference[] psiReferenceArray = this.myClassProvider.getReferencesByElement(psiElement);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDDReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDDReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static class WSMethodReference
    implements PsiReference,
    MemberReferenceThatKnowsAboutParentClassName {
        private final PsiElement myElement;
        private final TextRange myRange;
        private String myClassName;

        public WSMethodReference(PsiElement element, TextRange range) {
            this.myElement = element;
            this.myRange = range;
        }

        @Nullable
        public PsiElement resolve() {
            final String text = this.getCanonicalText();
            final PsiElement[] result = new PsiElement[1];
            this.processMethods(new PsiElementProcessor<PsiMethod>(){

                public boolean execute(@NotNull PsiMethod element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/WSDDReferenceProvider$WSMethodReference$1", "execute"));
                    }
                    if (element.getName().equals(text)) {
                        result[0] = element;
                        return false;
                    }
                    return true;
                }
            });
            if ("*".equals(text)) {
                return this.myElement;
            }
            return result[0];
        }

        private void processMethods(PsiElementProcessor<PsiMethod> processor) {
            PsiElement parent = this.myElement.getParent().getParent().getParent();
            if (parent instanceof XmlTag) {
                XmlTag[] subTags;
                XmlTag parentTag = (XmlTag)parent;
                for (XmlTag p : subTags = parentTag.findSubTags(WSDDReferenceProvider.PARAMETER_TAG_NAME)) {
                    PsiElement psiElement;
                    PsiReference clazzRef = this.findReference(p);
                    PsiElement psiElement2 = psiElement = clazzRef != null ? clazzRef.resolve() : null;
                    if (!(psiElement instanceof PsiClass)) continue;
                    PsiClass psiClass = (PsiClass)psiElement;
                    this.myClassName = psiClass.getQualifiedName();
                    for (PsiMethod m : psiClass.getMethods()) {
                        if (!DeployUtils.isAcceptableMethod(m) || processor.execute((PsiElement)m)) continue;
                        return;
                    }
                }
            }
        }

        protected PsiReference findReference(XmlTag p) {
            PsiReference[] references;
            String value;
            if (WSDDReferenceProvider.NAME_ATTR_VALUE2.equals(p.getAttributeValue(WSDDReferenceProvider.NAME_ATTR_NAME)) && (value = p.getAttributeValue(WSDDReferenceProvider.VALUE_ATTR_NAME)) != null && (references = p.getAttribute(WSDDReferenceProvider.VALUE_ATTR_NAME, null).getValueElement().getReferences()).length > 0) {
                return references[references.length - 1];
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            final ArrayList results = new ArrayList(1);
            this.processMethods(new PsiElementProcessor<PsiMethod>(){

                public boolean execute(@NotNull PsiMethod element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/WSDDReferenceProvider$WSMethodReference$2", "execute"));
                    }
                    results.add(element.getName());
                    return true;
                }
            });
            Object[] objectArray = ArrayUtil.toStringArray(results);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDDReferenceProvider$WSMethodReference", "getVariants"));
            }
            return objectArray;
        }

        public boolean isSoft() {
            return false;
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        public TextRange getRangeInElement() {
            return this.myRange;
        }

        @NotNull
        public String getCanonicalText() {
            String text = this.myElement.getText();
            String string = this.myRange.substring(text);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WSDDReferenceProvider$WSMethodReference", "getCanonicalText"));
            }
            return string;
        }

        public PsiElement handleElementRename(String string) throws IncorrectOperationException {
            return ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.myRange, string);
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/WSDDReferenceProvider$WSMethodReference", "bindToElement"));
            }
            throw new IncorrectOperationException();
        }

        public boolean isReferenceTo(PsiElement element) {
            return this.myElement.getManager().areElementsEquivalent(element, this.resolve());
        }

        @Override
        public String getParentClassName() {
            return this.myClassName;
        }
    }
}

