/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.ws.WSBundle;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class MyDialogWrapper
extends DialogWrapper {
    protected static Logger LOG = Logger.getInstance((String)"webservicesplugin.dialogwrapper");
    protected Project myProject;
    private PsiClass myClass;
    protected static final String NO_CLASS_IN_SELECTED_TEXT_EDITOR = WSBundle.message("no.class.in.selected.text.editor.error.message", new Object[0]);
    private PsiFile myFile;

    public MyDialogWrapper(Project project) {
        super(project, true);
        this.myProject = project;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected String getDimensionServiceKey() {
        return "#" + ((Object)((Object)this)).getClass().getName();
    }

    public PsiClass getCurrentClass() {
        if (this.myClass != null && !this.myClass.isValid() && this.myFile != null) {
            this.myClass = (PsiClass)ArrayUtil.getFirstElement((Object[])((PsiJavaFile)this.myFile).getClasses());
        }
        return this.myClass;
    }

    protected boolean hasClassNameInUI() {
        return true;
    }

    public void setCurrentClass(PsiClass aClass) {
        this.myClass = aClass;
        this.myFile = this.myClass != null ? this.myClass.getContainingFile() : null;
    }

    public void setCurrentFile(PsiFile aFile) {
        this.myFile = aFile;
    }

    protected void init() {
        super.init();
        this.setClassNameToUI(this.myClass);
    }

    public void setClassNameToUI(PsiClass aClass) {
        if (!this.hasClassNameInUI()) {
            return;
        }
        JComponent className = this.getClassName();
        if (className != null) {
            String text = aClass != null ? this.getClassNameTextToSet(aClass) : "*UNDEFINED*";
            this.doSetClassNameText(className, text);
        }
    }

    protected void doSetClassNameText(JComponent className, String text) {
        if (className instanceof JLabel) {
            ((JLabel)className).setText(text);
        } else if (className instanceof JTextField) {
            ((JTextField)className).setText(text);
        } else {
            throw new UnsupportedOperationException();
        }
        this.validate();
    }

    protected String getClassNameTextToSet(PsiClass aClass) {
        return aClass.getName();
    }

    protected JComponent getClassName() {
        return null;
    }

    protected void doHelpAction() {
        String helpId = this.getHelpId();
        HelpManager.getInstance().invokeHelp("webservices." + helpId.substring(0, helpId.lastIndexOf(46)));
    }

    public void doInitFor(JLabel textComponent, JComponent component, char mnemonic) {
        textComponent.setLabelFor(component);
        textComponent.setDisplayedMnemonic(mnemonic);
    }

    @NotNull
    protected Alarm.ThreadToUse getValidationThreadToUse() {
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.POOLED_THREAD;
        if (threadToUse == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/utils/ui/MyDialogWrapper", "getValidationThreadToUse"));
        }
        return threadToUse;
    }

    protected abstract ValidationInfo doValidate(ValidationData var1);

    protected abstract ValidationData createValidationData();

    protected ValidationInfo doValidate() {
        ValidationData validationData = this.createValidationData();
        if (validationData != null) {
            validationData.acquire();
        }
        return this.doValidate(validationData);
    }

    @NotNull
    @NonNls
    protected abstract String getHelpId();

    protected boolean isAcceptableFile(VirtualFile virtualFile) {
        return virtualFile.getFileType() == StdFileTypes.JAVA;
    }

    public void configureComboBox(JComboBox combo, List<String> lastValues) {
        combo.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(lastValues)));
        if (combo.getItemCount() != 0) {
            combo.setSelectedIndex(0);
            combo.getEditor().selectAll();
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public static abstract class ValidationData {
        public final void acquire() {
            try {
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        this.doAcquire();
                    }
                });
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        protected abstract void doAcquire();
    }
}

