/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.parser;

import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.jsp.el.ELParserUtil;
import com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELParameterList;
import com.intellij.psi.tree.IElementType;
import com.intellij.spring.el.lexer.SpringELTokenType;
import com.intellij.spring.el.psi.SpringELInlineMapEntry;
import com.intellij.spring.el.psi.SpringELNewExpression;
import com.intellij.spring.el.psi.SpringELPropertyReference;
import com.intellij.spring.el.psi.SpringELQualifiedType;
import com.intellij.spring.el.psi.impl.SpringELBeanReferenceExpressionImpl;
import com.intellij.spring.el.psi.impl.SpringELLiteralExpressionImpl;
import com.intellij.spring.el.psi.impl.SpringELMethodCallExpressionImpl;
import com.intellij.spring.el.psi.impl.SpringELTypeExpressionImpl;
import com.intellij.spring.el.psi.impl.SpringELVariableImpl;

public class SpringELParserUtil
extends ELParserUtil {
    public static ELParameterList getParameterList(SpringELMethodCallExpressionImpl expression) {
        return expression.getELParameterList();
    }

    public static PsiReference[] getReferences(SpringELVariableImpl variable) {
        if (variable.getParent() instanceof SpringELQualifiedType || variable.getParent() instanceof SpringELInlineMapEntry) {
            return PsiReference.EMPTY_ARRAY;
        }
        return ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)variable);
    }

    public static PsiType getType(SpringELTypeExpressionImpl expression) {
        SpringELQualifiedType type = expression.getELQualifiedType();
        return type == null ? null : type.getType();
    }

    public static PsiType getType(SpringELNewExpression expression) {
        SpringELQualifiedType type = expression.getELQualifiedType();
        return type == null ? null : type.getType();
    }

    public static PsiType getType(SpringELBeanReferenceExpressionImpl expression) {
        return ELResolveUtil.resolveContextAsType((ELExpression)expression.getELVariable());
    }

    public static Class getTypeClass(SpringELLiteralExpressionImpl expression) {
        IElementType type = expression.getNode().getFirstChildNode().getElementType();
        if (SpringELTokenType.SPEL_STRING_LITERALS.contains(type)) {
            return String.class;
        }
        if (type == SpringELTokenType.SPEL_INTEGER_LITERAL) {
            return Integer.class;
        }
        if (type == SpringELTokenType.SPEL_FLOATING_POINT_LITERAL) {
            return Float.class;
        }
        if (type == SpringELTokenType.SPEL_TRUE || type == SpringELTokenType.SPEL_FALSE) {
            return Boolean.class;
        }
        return Object.class;
    }

    public static PsiReference getReference(SpringELPropertyReference expression) {
        return new PropertyReference(expression.getText(), (PsiElement)expression, null, false);
    }
}

