/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.PosixFile;
import net.rubygrapefruit.platform.PosixFiles;
import net.rubygrapefruit.platform.internal.FileStat;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.jni.PosixFileFunctions;

public class DefaultPosixFiles
implements PosixFiles {
    public PosixFile stat(File file) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        FileStat stat = new FileStat();
        PosixFileFunctions.stat(file.getPath(), stat, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not get posix file details of %s: %s", file, result2.getMessage()));
        }
        return stat;
    }

    public void setMode(File file, int perms) {
        FunctionResult result2 = new FunctionResult();
        PosixFileFunctions.chmod(file.getPath(), perms, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not set UNIX mode on %s: %s", file, result2.getMessage()));
        }
    }

    public int getMode(File file) {
        PosixFile stat = this.stat(file);
        if (stat.getType() == PosixFile.Type.Missing) {
            throw new NativeException(String.format("Could not get UNIX mode on %s: file does not exist.", file));
        }
        return stat.getMode();
    }

    public String readLink(File link) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        String contents = PosixFileFunctions.readlink(link.getPath(), result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not read symlink %s: %s", link, result2.getMessage()));
        }
        return contents;
    }

    public void symlink(File link, String contents) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        PosixFileFunctions.symlink(link.getPath(), contents, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not create symlink %s: %s", link, result2.getMessage()));
        }
    }
}

