/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.Process;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.jni.PosixProcessFunctions;

public class DefaultProcess
implements Process {
    public int getProcessId() throws NativeException {
        return PosixProcessFunctions.getPid();
    }

    public File getWorkingDirectory() throws NativeException {
        FunctionResult result2 = new FunctionResult();
        String dir = PosixProcessFunctions.getWorkingDirectory(result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not get process working directory: %s", result2.getMessage()));
        }
        return new File(dir);
    }

    public void setWorkingDirectory(File directory) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        PosixProcessFunctions.setWorkingDirectory(directory.getAbsolutePath(), result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not set process working directory to '%s': %s", directory.getAbsoluteFile(), result2.getMessage()));
        }
    }

    public String getEnvironmentVariable(String name) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        String value = PosixProcessFunctions.getEnvironmentVariable(name, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not get the value of environment variable '%s': %s", name, result2.getMessage()));
        }
        return value;
    }

    public void setEnvironmentVariable(String name, String value) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        PosixProcessFunctions.setEnvironmentVariable(name, value, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not set the value of environment variable '%s': %s", name, result2.getMessage()));
        }
    }
}

