/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.Stack;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/CompilerOutputParser;", "", "()V", "parseCompilerMessagesFromReader", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "reader", "Ljava/io/Reader;", "collector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "CompilerOutputSAXHandler", "compiler-runner"})
public final class CompilerOutputParser {
    public static final CompilerOutputParser INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseCompilerMessagesFromReader(@NotNull MessageCollector messageCollector, @NotNull Reader reader, @NotNull OutputItemsCollector collector) {
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        StringBuilder stringBuilder = new StringBuilder();
        Reader wrappingReader2 = new Reader(reader, stringBuilder){
            final /* synthetic */ Reader $reader;
            final /* synthetic */ StringBuilder $stringBuilder;

            public int read(@NotNull char[] cbuf, int off, int len) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)cbuf, (String)"cbuf");
                int read = this.$reader.read(cbuf, off, len);
                this.$stringBuilder.append(cbuf, off, len);
                return read;
            }

            public void close() throws IOException {
            }
            {
                this.$reader = $captured_local_variable$0;
                this.$stringBuilder = $captured_local_variable$1;
            }
        };
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(wrappingReader2), (DefaultHandler)new CompilerOutputSAXHandler(messageCollector, collector));
        }
        catch (Throwable e) {
            try {
                FileUtil.loadTextAndClose((Reader)wrappingReader2);
            }
            catch (IOException ioException) {
                MessageCollectorUtil.reportException(messageCollector, ioException);
            }
            String message = stringBuilder.toString();
            MessageCollectorUtil.reportException(messageCollector, new IllegalStateException(message, e));
            messageCollector.report(CompilerMessageSeverity.ERROR, message, CompilerMessageLocation.NO_LOCATION);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                MessageCollectorUtil.reportException(messageCollector, e);
            }
        }
    }

    private CompilerOutputParser() {
        INSTANCE = this;
    }

    static {
        new CompilerOutputParser();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0017J\"\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0017J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J(\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler;", "Lorg/xml/sax/helpers/DefaultHandler;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "collector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;)V", "column", "", "line", "message", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "path", "", "tags", "Lcom/intellij/util/containers/Stack;", "characters", "", "ch", "", "start", "length", "endElement", "uri", "localName", "qName", "reportToCollector", "text", "startElement", "attributes", "Lorg/xml/sax/Attributes;", "Companion", "compiler-runner"})
    private static final class CompilerOutputSAXHandler
    extends DefaultHandler {
        private final StringBuilder message;
        private final Stack<String> tags;
        private String path;
        private int line;
        private int column;
        private final MessageCollector messageCollector;
        private final OutputItemsCollector collector;
        private static final Map<String, CompilerMessageSeverity> CATEGORIES;
        public static final Companion Companion;

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            Intrinsics.checkParameterIsNotNull((Object)localName, (String)"localName");
            Intrinsics.checkParameterIsNotNull((Object)qName, (String)"qName");
            Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
            this.tags.push((Object)qName);
            this.message.setLength(0);
            this.path = attributes.getValue("path");
            this.line = CompilerOutputSAXHandler.Companion.safeParseInt(attributes.getValue("line"), -1);
            this.column = CompilerOutputSAXHandler.Companion.safeParseInt(attributes.getValue("column"), -1);
        }

        @Override
        public void characters(@Nullable char[] ch, int start, int length) throws SAXException {
            if (this.tags.size() == 1) {
                String message;
                if (ch == null) {
                    Intrinsics.throwNpe();
                }
                Object object = ch;
                String $receiver$iv = message = new String((char[])object, start, length);
                CharSequence $receiver$iv$iv = $receiver$iv;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $receiver$iv$iv.charAt(index$iv$iv);
                    boolean bl = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (!((object = (Object)((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0)) {
                    this.messageCollector.report(CompilerMessageSeverity.ERROR, "Unhandled compiler output: " + message, CompilerMessageLocation.NO_LOCATION);
                }
            } else {
                this.message.append(ch, start, length);
            }
        }

        @Override
        public void endElement(@Nullable String uri, @NotNull String localName, @NotNull String qName) throws SAXException {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)localName, (String)"localName");
            Intrinsics.checkParameterIsNotNull((Object)qName, (String)"qName");
            if (this.tags.size() == 1) {
                return;
            }
            String string2 = string = qName;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String qNameLowerCase = string3;
            CompilerMessageSeverity category = (CompilerMessageSeverity)((Object)CompilerOutputSAXHandler.Companion.getCATEGORIES().get(qNameLowerCase));
            if (category == null) {
                this.messageCollector.report(CompilerMessageSeverity.ERROR, "Unknown compiler message tag: " + qName, CompilerMessageLocation.NO_LOCATION);
                category = CompilerMessageSeverity.INFO;
            }
            String text = this.message.toString();
            if (Intrinsics.areEqual((Object)((Object)category), (Object)((Object)CompilerMessageSeverity.OUTPUT))) {
                String string4 = text;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"text");
                this.reportToCollector(string4);
            } else {
                this.messageCollector.report(category, text, CompilerMessageLocation.Companion.create(this.path, this.line, this.column, null));
            }
            this.tags.pop();
        }

        private final void reportToCollector(String text) {
            OutputMessageUtil.Output output = OutputMessageUtil.parseOutputMessage(text);
            if (output != null) {
                this.collector.add(output.sourceFiles, output.outputFile);
            }
        }

        public CompilerOutputSAXHandler(@NotNull MessageCollector messageCollector, @NotNull OutputItemsCollector collector) {
            Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
            Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
            this.messageCollector = messageCollector;
            this.collector = collector;
            this.message = new StringBuilder();
            this.tags = new Stack();
        }

        static {
            Companion = new Companion(null);
            CATEGORIES = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"error", (Object)((Object)CompilerMessageSeverity.ERROR)), TuplesKt.to((Object)"warning", (Object)((Object)CompilerMessageSeverity.WARNING)), TuplesKt.to((Object)"logging", (Object)((Object)CompilerMessageSeverity.LOGGING)), TuplesKt.to((Object)"output", (Object)((Object)CompilerMessageSeverity.OUTPUT)), TuplesKt.to((Object)"exception", (Object)((Object)CompilerMessageSeverity.EXCEPTION)), TuplesKt.to((Object)"info", (Object)((Object)CompilerMessageSeverity.INFO)), TuplesKt.to((Object)"messages", (Object)((Object)CompilerMessageSeverity.INFO))});
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\nH\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler$Companion;", "", "()V", "CATEGORIES", "", "", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "getCATEGORIES", "()Ljava/util/Map;", "safeParseInt", "", "value", "defaultValue", "compiler-runner"})
        public static final class Companion {
            private final Map<String, CompilerMessageSeverity> getCATEGORIES() {
                return CATEGORIES;
            }

            private final int safeParseInt(String value, int defaultValue) {
                if (value == null) {
                    return defaultValue;
                }
                try {
                    String $receiver$iv;
                    String string = $receiver$iv = value;
                    if (string == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    CharSequence $receiver$iv$iv = string;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $receiver$iv$iv.charAt(index$iv$iv);
                        boolean bl = match$iv$iv = it <= ' ';
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    return Integer.parseInt(((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                }
                catch (NumberFormatException e) {
                    return defaultValue;
                }
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

