/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0016\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0017\u001a\u00020\u000eJ\f\u0010\u0018\u001a\u00020\u0012*\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/jps/build/TeamcityStatisticsLogger;", "", "()V", "isOnTeamcity", "", "totalTime", "Ljava/util/concurrent/atomic/AtomicLong;", "escape", "", "text", "escapedChar", "", "c", "printPerChunkStatistics", "", "moduleChunk", "Lorg/jetbrains/jps/ModuleChunk;", "timeToCompileNs", "", "printStatisticMessage", "key", "value", "registerStatistic", "reportTotal", "nanosToMillis", "jps-plugin"})
public final class TeamcityStatisticsLogger {
    private final boolean isOnTeamcity = System.getenv("TEAMCITY_VERSION") != null;
    private final AtomicLong totalTime = new AtomicLong();

    private final char escapedChar(char c) {
        char c2;
        switch (c) {
            case '\n': {
                c2 = 110;
                break;
            }
            case '\r': {
                c2 = 114;
                break;
            }
            case '\u0085': {
                c2 = 120;
                break;
            }
            case '\u2028': {
                c2 = 108;
                break;
            }
            case '\u2029': {
                c2 = 112;
                break;
            }
            case '|': {
                c2 = 124;
                break;
            }
            case '\'': {
                c2 = 39;
                break;
            }
            case '[': {
                c2 = 91;
                break;
            }
            case ']': {
                c2 = 93;
                break;
            }
            default: {
                c2 = (char)0;
            }
        }
        return c2;
    }

    private final String escape(String text) {
        String string;
        StringBuilder escaped = new StringBuilder();
        String string2 = string = text;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string2.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        for (int i = 0; i < cArray2.length; ++i) {
            char c = cArray2[i];
            char escChar = this.escapedChar(c);
            if (escChar == (char)0) {
                escaped.append(c);
                continue;
            }
            escaped.append('|').append(escChar);
        }
        String string3 = escaped.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"escaped.toString()");
        return string3;
    }

    public final void registerStatistic(@NotNull ModuleChunk moduleChunk, long timeToCompileNs) {
        Intrinsics.checkParameterIsNotNull((Object)moduleChunk, (String)"moduleChunk");
        if (!this.isOnTeamcity) {
            return;
        }
        this.totalTime.addAndGet(timeToCompileNs);
        this.printPerChunkStatistics(moduleChunk, timeToCompileNs);
    }

    private final void printPerChunkStatistics(ModuleChunk moduleChunk, long timeToCompileNs) {
        this.printStatisticMessage(KotlinBuilder.KOTLIN_BUILDER_NAME + " for " + moduleChunk.getPresentableShortName() + " compilation time, ms", String.valueOf(this.nanosToMillis(timeToCompileNs)));
    }

    public final void reportTotal() {
        if (!this.isOnTeamcity) {
            return;
        }
        this.printStatisticMessage(KotlinBuilder.KOTLIN_BUILDER_NAME + " total compilation time, ms", String.valueOf(this.nanosToMillis(this.totalTime.get())));
    }

    private final void printStatisticMessage(String key, String value) {
        String string = "##teamcity[buildStatisticValue key='" + this.escape(key) + "' value='" + this.escape(value) + "']";
        System.out.println((Object)string);
    }

    private final long nanosToMillis(long $receiver) {
        return TimeUnit.NANOSECONDS.toMillis($receiver);
    }
}

