/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.ClassDescriptorFactory;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationContext;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.SinceKotlinInfoTable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer;", "", "components", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "(Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;)V", "classes", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer$ClassKey;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "createClass", "key", "deserializeClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "classDataWithSource", "Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;", "ClassKey", "Companion", "deserialization"})
public final class ClassDeserializer {
    private final Function1<ClassKey, ClassDescriptor> classes;
    private final DeserializationComponents components;
    @NotNull
    private static final Set<ClassId> BLACK_LIST;
    public static final Companion Companion;

    @Nullable
    public final ClassDescriptor deserializeClass(@NotNull ClassId classId, @Nullable ClassDataWithSource classDataWithSource) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        return (ClassDescriptor)this.classes.invoke((Object)new ClassKey(classId, classDataWithSource));
    }

    @Nullable
    public static /* bridge */ /* synthetic */ ClassDescriptor deserializeClass$default(ClassDeserializer classDeserializer, ClassId classId, ClassDataWithSource classDataWithSource, int n, Object object) {
        if ((n & 2) != 0) {
            classDataWithSource = null;
        }
        return classDeserializer.deserializeClass(classId, classDataWithSource);
    }

    /*
     * WARNING - void declaration
     */
    private final ClassDescriptor createClass(ClassKey key) {
        void sourceElement;
        void nameResolver;
        void classProto;
        DeserializationContext deserializationContext;
        ClassId classId = key.getClassId();
        for (ClassDescriptorFactory classDescriptorFactory : this.components.getFictitiousClassDescriptorFactories()) {
            ClassDescriptor object;
            ClassDescriptor classDescriptor = classDescriptorFactory.createClass(classId);
            if (classDescriptor == null) continue;
            ClassDescriptor it = object = classDescriptor;
            return it;
        }
        if (Companion.getBLACK_LIST().contains(classId)) {
            return null;
        }
        ClassDataWithSource classDataWithSource = key.getClassDataWithSource();
        if (classDataWithSource == null) {
            classDataWithSource = this.components.getClassDataFinder().findClassData(classId);
        }
        if (classDataWithSource == null) {
            return null;
        }
        Object object = classDataWithSource;
        ClassData classData = ((ClassDataWithSource)object).component1();
        SourceElement sourceElement2 = ((ClassDataWithSource)object).component2();
        object = null;
        ClassData $i$a$1$let = classData;
        object = $i$a$1$let.component1();
        ProtoBuf.Class it = $i$a$1$let.component2();
        $i$a$1$let = null;
        if (classId.isNestedClass()) {
            ClassId classId2 = classId.getOuterClassId();
            Intrinsics.checkExpressionValueIsNotNull((Object)classId2, (String)"classId.outerClassId");
            ClassDescriptor classDescriptor = ClassDeserializer.deserializeClass$default(this, classId2, null, 2, null);
            if (!(classDescriptor instanceof DeserializedClassDescriptor)) {
                classDescriptor = null;
            }
            DeserializedClassDescriptor deserializedClassDescriptor = (DeserializedClassDescriptor)classDescriptor;
            if (deserializedClassDescriptor == null) {
                return null;
            }
            DeserializedClassDescriptor outerClass = deserializedClassDescriptor;
            Name name = classId.getShortClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"classId.shortClassName");
            if (!outerClass.hasNestedClass$deserialization(name)) {
                return null;
            }
            deserializationContext = outerClass.getC();
        } else {
            boolean bl;
            PackageFragmentProvider packageFragmentProvider = this.components.getPackageFragmentProvider();
            FqName fqName = classId.getPackageFqName();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"classId.packageFqName");
            List fragments2 = packageFragmentProvider.getPackageFragments(fqName);
            boolean bl2 = bl = fragments2.size() == 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "There should be exactly one package: " + fragments2 + ", class id is " + classId;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            PackageFragmentDescriptor fragment = (PackageFragmentDescriptor)CollectionsKt.single((List)fragments2);
            if (fragment instanceof DeserializedPackageFragment) {
                DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)fragment;
                Name name = classId.getShortClassName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"classId.shortClassName");
                if (!deserializedPackageFragment.hasTopLevelClass(name)) {
                    return null;
                }
            }
            ProtoBuf.TypeTable typeTable = classProto.getTypeTable();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"classProto.typeTable");
            TypeTable typeTable2 = new TypeTable(typeTable);
            ProtoBuf.SinceKotlinInfoTable sinceKotlinInfoTable = classProto.getSinceKotlinInfoTable();
            Intrinsics.checkExpressionValueIsNotNull((Object)sinceKotlinInfoTable, (String)"classProto.sinceKotlinInfoTable");
            deserializationContext = this.components.createContext(fragment, (NameResolver)nameResolver, typeTable2, SinceKotlinInfoTable.Companion.create(sinceKotlinInfoTable), null);
        }
        DeserializationContext outerContext = deserializationContext;
        return (ClassDescriptor)new DeserializedClassDescriptor(outerContext, (ProtoBuf.Class)classProto, (NameResolver)nameResolver, (SourceElement)sourceElement);
    }

    public ClassDeserializer(@NotNull DeserializationComponents components) {
        Intrinsics.checkParameterIsNotNull((Object)components, (String)"components");
        this.components = components;
        this.classes = this.components.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<ClassKey, ClassDescriptor>(this){
            final /* synthetic */ ClassDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(@NotNull ClassKey key) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                return ClassDeserializer.access$createClass(this.this$0, key);
            }
            {
                this.this$0 = classDeserializer;
                super(1);
            }
        });
    }

    static {
        Companion = new Companion(null);
        BLACK_LIST = SetsKt.setOf((Object)ClassId.topLevel((FqName)KotlinBuiltIns.FQ_NAMES.cloneable.toSafe()));
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$createClass(ClassDeserializer $this, @NotNull ClassKey key) {
        return $this.createClass(key);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer$ClassKey;", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "classDataWithSource", "Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;)V", "getClassDataWithSource", "()Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "equals", "", "other", "hashCode", "", "deserialization"})
    private static final class ClassKey {
        @NotNull
        private final ClassId classId;
        @Nullable
        private final ClassDataWithSource classDataWithSource;

        public boolean equals(@Nullable Object other) {
            return other instanceof ClassKey && Intrinsics.areEqual((Object)this.classId, (Object)((ClassKey)other).classId);
        }

        public int hashCode() {
            return this.classId.hashCode();
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Nullable
        public final ClassDataWithSource getClassDataWithSource() {
            return this.classDataWithSource;
        }

        public ClassKey(@NotNull ClassId classId, @Nullable ClassDataWithSource classDataWithSource) {
            Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
            this.classId = classId;
            this.classDataWithSource = classDataWithSource;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer$Companion;", "", "()V", "BLACK_LIST", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/annotations/NotNull;", "getBLACK_LIST", "()Ljava/util/Set;", "deserialization"})
    public static final class Companion {
        @NotNull
        public final Set<ClassId> getBLACK_LIST() {
            return BLACK_LIST;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

