/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.SuspendFunctionTypesKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.Deserialization;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationContext;
import org.jetbrains.kotlin.serialization.deserialization.FindClassInModuleKt;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.TypeDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedAnnotationsWithPossibleTargets;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.StarProjectionImpl;
import org.jetbrains.kotlin.types.TypeBasedStarProjectionImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\rH\u0002J.\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00062\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020\u001fJ\b\u0010*\u001a\u00020\tH\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020\u001fJ\u001a\u0010-\u001a\u00020#2\b\u0010.\u001a\u0004\u0018\u00010\u00102\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010!2\u0006\u00103\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00140\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;", "", "c", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationContext;", "parent", "typeParameterProtos", "", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$TypeParameter;", "debugName", "", "(Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationContext;Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;Ljava/util/List;Ljava/lang/String;)V", "classDescriptors", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "ownTypeParameters", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getOwnTypeParameters", "()Ljava/util/List;", "typeAliasDescriptors", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "typeParameterDescriptors", "", "computeClassDescriptor", "fqNameIndex", "computeLocalClassifierReplacementType", "Lorg/jetbrains/kotlin/types/SimpleType;", "className", "computeTypeAliasDescriptor", "createSuspendFunctionType", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "functionTypeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "arguments", "Lorg/jetbrains/kotlin/types/TypeProjection;", "nullable", "", "simpleType", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type;", "additionalAnnotations", "toString", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeArgument", "parameter", "typeArgumentProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type$Argument;", "typeConstructor", "typeParameterTypeConstructor", "typeParameterId", "deserialization"})
public final class TypeDeserializer {
    private final Function1<Integer, ClassDescriptor> classDescriptors;
    private final Function1<Integer, ClassifierDescriptor> typeAliasDescriptors;
    private final Map<Integer, TypeParameterDescriptor> typeParameterDescriptors;
    private final DeserializationContext c;
    private final TypeDeserializer parent;
    private final String debugName;

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return CollectionsKt.toReadOnlyList(this.typeParameterDescriptors.values());
    }

    @NotNull
    public final KotlinType type(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)additionalAnnotations, (String)"additionalAnnotations");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            SimpleType lowerBound = this.simpleType(proto, additionalAnnotations);
            ProtoBuf.Type type = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.c.getTypeTable());
            if (type == null) {
                Intrinsics.throwNpe();
            }
            SimpleType upperBound = this.simpleType(type, additionalAnnotations);
            FlexibleTypeDeserializer flexibleTypeDeserializer = this.c.getComponents().getFlexibleTypeDeserializer();
            String string = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
            return flexibleTypeDeserializer.create(proto, string, lowerBound, upperBound);
        }
        return (KotlinType)this.simpleType(proto, additionalAnnotations);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinType type$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type, Annotations annotations2, int n, Object object) {
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.type(type, annotations2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimpleType simpleType(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        SimpleType localClassifierType;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)additionalAnnotations, (String)"additionalAnnotations");
        Object object = proto.hasClassName() ? this.computeLocalClassifierReplacementType(proto.getClassName()) : (localClassifierType = proto.hasTypeAliasName() ? this.computeLocalClassifierReplacementType(proto.getTypeAliasName()) : null);
        if (localClassifierType != null) {
            return localClassifierType;
        }
        TypeConstructor constructor = this.typeConstructor(proto);
        if (ErrorUtils.isError((DeclarationDescriptor)((DeclarationDescriptor)constructor.getDeclarationDescriptor()))) {
            SimpleType simpleType2 = ErrorUtils.createErrorTypeWithCustomConstructor((String)constructor.toString(), (TypeConstructor)constructor);
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"ErrorUtils.createErrorTy\u2026.toString(), constructor)");
            return simpleType2;
        }
        DeserializedAnnotationsWithPossibleTargets annotations2 = new DeserializedAnnotationsWithPossibleTargets(this.c.getStorageManager(), (Function0<? extends List<AnnotationWithTarget>>)((Function0)new Function0<List<? extends AnnotationWithTarget>>(this, proto, additionalAnnotations){
            final /* synthetic */ TypeDeserializer this$0;
            final /* synthetic */ ProtoBuf.Type $proto;
            final /* synthetic */ Annotations $additionalAnnotations;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<AnnotationWithTarget> invoke() {
                void var3_3;
                void $receiver$iv$iv;
                Iterable $receiver$iv = TypeDeserializer.access$getC$p(this.this$0).getComponents().getAnnotationAndConstantLoader().loadTypeAnnotations(this.$proto, TypeDeserializer.access$getC$p(this.this$0).getNameResolver());
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    AnnotationWithTarget annotationWithTarget = new AnnotationWithTarget((AnnotationDescriptor)it, null);
                    collection.add(annotationWithTarget);
                }
                return kotlin.collections.CollectionsKt.plus((Collection)((List)var3_3), (Iterable)this.$additionalAnnotations.getAllAnnotations());
            }
            {
                this.this$0 = typeDeserializer;
                this.$proto = type;
                this.$additionalAnnotations = annotations2;
                super(0);
            }
        }));
        Function1<ProtoBuf.Type, List<? extends ProtoBuf.Type.Argument>> collectAllArguments$ = new Function1<ProtoBuf.Type, List<? extends ProtoBuf.Type.Argument>>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @NotNull
            public final List<ProtoBuf.Type.Argument> invoke(@NotNull ProtoBuf.Type $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                ProtoBuf.Type type = ProtoTypeTableUtilKt.outerType($receiver, TypeDeserializer.access$getC$p(this.this$0).getTypeTable());
                List list = type != null ? this.invoke(type) : null;
                Collection collection = $receiver.getArgumentList();
                List list2 = list;
                if (list2 == null) {
                    list2 = kotlin.collections.CollectionsKt.emptyList();
                }
                List list3 = list2;
                return kotlin.collections.CollectionsKt.plus((Collection)collection, (Iterable)list3);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        };
        Iterable iterable = $receiver$iv = (Iterable)collectAllArguments$.invoke(proto);
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void proto2;
            void index;
            int n = index$iv$iv++;
            ProtoBuf.Type.Argument argument = (ProtoBuf.Type.Argument)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            TypeProjection typeProjection = this.typeArgument((TypeParameterDescriptor)kotlin.collections.CollectionsKt.getOrNull((List)constructor.getParameters(), (int)index), (ProtoBuf.Type.Argument)proto2);
            collection.add(typeProjection);
        }
        List arguments = CollectionsKt.toReadOnlyList((List)destination$iv$iv);
        Boolean bl = Flags.SUSPEND_TYPE.get(proto.getFlags());
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"Flags.SUSPEND_TYPE.get(proto.flags)");
        SimpleType simpleType3 = bl != false ? this.createSuspendFunctionType(annotations2, constructor, arguments, proto.getNullable()) : KotlinTypeFactory.simpleType$default((Annotations)annotations2, (TypeConstructor)constructor, arguments, (boolean)proto.getNullable(), null, (int)16, null);
        ProtoBuf.Type type = ProtoTypeTableUtilKt.abbreviatedType(proto, this.c.getTypeTable());
        if (type == null) {
            return simpleType3;
        }
        ProtoBuf.Type abbreviatedTypeProto = type;
        return SpecialTypesKt.withAbbreviation((SimpleType)simpleType3, (SimpleType)this.simpleType(abbreviatedTypeProto, additionalAnnotations));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SimpleType simpleType$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type, Annotations annotations2, int n, Object object) {
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.simpleType(type, annotations2);
    }

    private final TypeConstructor typeConstructor(ProtoBuf.Type proto) {
        ClassDescriptor classDescriptor;
        if (proto.hasClassName()) {
            classDescriptor = (ClassDescriptor)this.classDescriptors.invoke((Object)proto.getClassName());
            if (classDescriptor == null || (classDescriptor = classDescriptor.getTypeConstructor()) == null) {
                classDescriptor = this.c.getComponents().getNotFoundClasses().getClass(proto, this.c.getNameResolver(), this.c.getTypeTable());
            }
        } else if (proto.hasTypeParameter()) {
            classDescriptor = this.typeParameterTypeConstructor(proto.getTypeParameter());
            if (classDescriptor == null) {
                TypeConstructor typeConstructor = ErrorUtils.createErrorTypeConstructor((String)("Unknown type parameter " + proto.getTypeParameter()));
                classDescriptor = typeConstructor;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor, (String)"ErrorUtils.createErrorTy\u2026 ${proto.typeParameter}\")");
            }
        } else if (proto.hasTypeParameterName()) {
            TypeParameterDescriptor parameter;
            Object v2;
            String name;
            DeclarationDescriptor container;
            block13: {
                Iterable iterable;
                container = this.c.getContainingDeclaration();
                name = this.c.getNameResolver().getString(proto.getTypeParameterName());
                Iterable iterable2 = iterable = (Iterable)this.getOwnTypeParameters();
                for (Object t : iterable2) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)t;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)name)) continue;
                    v2 = t;
                    break block13;
                }
                v2 = null;
            }
            if ((classDescriptor = (parameter = (TypeParameterDescriptor)v2)) == null || (classDescriptor = classDescriptor.getTypeConstructor()) == null) {
                TypeConstructor typeConstructor = ErrorUtils.createErrorTypeConstructor((String)("Deserialized type parameter " + name + " in " + container));
                classDescriptor = typeConstructor;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor, (String)"ErrorUtils.createErrorTy\u2026ter $name in $container\")");
            }
        } else if (proto.hasTypeAliasName()) {
            classDescriptor = (ClassifierDescriptor)this.typeAliasDescriptors.invoke((Object)proto.getTypeAliasName());
            if (classDescriptor == null || (classDescriptor = classDescriptor.getTypeConstructor()) == null) {
                classDescriptor = this.c.getComponents().getNotFoundClasses().getTypeAlias(proto, this.c.getNameResolver(), this.c.getTypeTable());
            }
        } else {
            TypeConstructor typeConstructor = ErrorUtils.createErrorTypeConstructor((String)"Unknown type");
            classDescriptor = typeConstructor;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor, (String)"ErrorUtils.createErrorTy\u2026nstructor(\"Unknown type\")");
        }
        return classDescriptor;
    }

    private final SimpleType createSuspendFunctionType(Annotations annotations2, TypeConstructor functionTypeConstructor, List<? extends TypeProjection> arguments, boolean nullable) {
        SimpleType result2;
        SimpleType simpleType2;
        SimpleType simpleType3;
        switch (functionTypeConstructor.getParameters().size() - arguments.size()) {
            case 0: {
                SimpleType functionType = KotlinTypeFactory.simpleType$default((Annotations)annotations2, (TypeConstructor)functionTypeConstructor, arguments, (boolean)nullable, null, (int)16, null);
                SimpleType simpleType4 = AddToStdlibKt.check(functionType, createSuspendFunctionType.result.1.INSTANCE);
                if (simpleType4 != null) {
                    SimpleType simpleType5 = simpleType4;
                    KotlinType p1 = (KotlinType)simpleType5;
                    simpleType3 = SuspendFunctionTypesKt.transformRuntimeFunctionTypeToSuspendFunction((KotlinType)p1);
                    break;
                }
                simpleType3 = null;
                break;
            }
            case 1: {
                int arity = arguments.size() - 1;
                if (arity >= 0) {
                    TypeConstructor typeConstructor = functionTypeConstructor.getBuiltIns().getSuspendFunction(arity).getTypeConstructor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor, (String)"functionTypeConstructor.\u2026on(arity).typeConstructor");
                    simpleType3 = KotlinTypeFactory.simpleType$default((Annotations)annotations2, (TypeConstructor)typeConstructor, arguments, (boolean)nullable, null, (int)16, null);
                    break;
                }
                simpleType3 = null;
                break;
            }
            default: {
                simpleType3 = null;
            }
        }
        if ((simpleType2 = (result2 = simpleType3)) == null) {
            SimpleType simpleType6 = ErrorUtils.createErrorTypeWithArguments((String)("Bad suspend function in metadata with constructor: " + functionTypeConstructor), arguments);
            simpleType2 = simpleType6;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType6, (String)"ErrorUtils.createErrorTy\u2026eConstructor\", arguments)");
        }
        return simpleType2;
    }

    private final TypeConstructor typeParameterTypeConstructor(int typeParameterId) {
        Object object = this.typeParameterDescriptors.get(typeParameterId);
        if (object == null || (object = object.getTypeConstructor()) == null) {
            TypeDeserializer typeDeserializer = this.parent;
            object = typeDeserializer != null ? typeDeserializer.typeParameterTypeConstructor(typeParameterId) : null;
        }
        return object;
    }

    private final ClassDescriptor computeClassDescriptor(int fqNameIndex) {
        ClassId id = this.c.getNameResolver().getClassId(fqNameIndex);
        if (id.isLocal()) {
            DeserializationComponents deserializationComponents = this.c.getComponents();
            ClassId classId = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"id");
            return deserializationComponents.deserializeClass(classId);
        }
        ModuleDescriptor moduleDescriptor = this.c.getComponents().getModuleDescriptor();
        ClassId classId = id;
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"id");
        return FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
    }

    private final SimpleType computeLocalClassifierReplacementType(int className2) {
        if (this.c.getNameResolver().getClassId(className2).isLocal()) {
            return this.c.getComponents().getLocalClassifierTypeSettings().getReplacementTypeForLocalClassifiers();
        }
        return null;
    }

    private final ClassifierDescriptor computeTypeAliasDescriptor(int fqNameIndex) {
        ClassId id = this.c.getNameResolver().getClassId(fqNameIndex);
        if (id.isLocal()) {
            return null;
        }
        ModuleDescriptor moduleDescriptor = this.c.getComponents().getModuleDescriptor();
        ClassId classId = id;
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"id");
        return (ClassifierDescriptor)FindClassInModuleKt.findTypeAliasAcrossModuleDependencies(moduleDescriptor, classId);
    }

    private final TypeProjection typeArgument(TypeParameterDescriptor parameter, ProtoBuf.Type.Argument typeArgumentProto) {
        if (Intrinsics.areEqual((Object)((Object)typeArgumentProto.getProjection()), (Object)((Object)ProtoBuf.Type.Argument.Projection.STAR))) {
            TypeProjection typeProjection;
            if (parameter == null) {
                SimpleType simpleType2 = this.c.getComponents().getModuleDescriptor().getBuiltIns().getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"c.components.moduleDescr\u2026.builtIns.nullableAnyType");
                typeProjection = (TypeProjection)new TypeBasedStarProjectionImpl((KotlinType)simpleType2);
            } else {
                typeProjection = (TypeProjection)new StarProjectionImpl(parameter);
            }
            return typeProjection;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)projection), (String)"typeArgumentProto.projection");
        Variance variance = Deserialization.variance(projection);
        ProtoBuf.Type type = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
        if (type == null) {
            return (TypeProjection)new TypeProjectionImpl((KotlinType)ErrorUtils.createErrorType((String)"No type recorded"));
        }
        ProtoBuf.Type type2 = type;
        return (TypeProjection)new TypeProjectionImpl(variance, TypeDeserializer.type$default(this, type2, null, 2, null));
    }

    @NotNull
    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    public TypeDeserializer(@NotNull DeserializationContext c, @Nullable TypeDeserializer parent, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @NotNull String debugName) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull(typeParameterProtos, (String)"typeParameterProtos");
        Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
        this.c = c;
        this.parent = parent;
        this.debugName = debugName;
        this.classDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeClassDescriptor(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        this.typeAliasDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassifierDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassifierDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeTypeAliasDescriptor(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        TypeDeserializer typeDeserializer = this;
        if (typeParameterProtos.isEmpty()) {
            TypeDeserializer typeDeserializer2 = typeDeserializer;
            Map map2 = MapsKt.emptyMap();
            typeDeserializer = typeDeserializer2;
            map = map2;
        } else {
            LinkedHashMap result2 = new LinkedHashMap();
            for (IndexedValue indexedValue : kotlin.collections.CollectionsKt.withIndex((Iterable)typeParameterProtos)) {
                int index = indexedValue.component1();
                ProtoBuf.TypeParameter proto = (ProtoBuf.TypeParameter)indexedValue.component2();
                Map map3 = result2;
                Integer n = proto.getId();
                DeserializedTypeParameterDescriptor deserializedTypeParameterDescriptor = new DeserializedTypeParameterDescriptor(this.c, proto, index);
                TypeDeserializer typeDeserializer3 = typeDeserializer;
                map3.put(n, deserializedTypeParameterDescriptor);
                TypeDeserializer typeDeserializer4 = typeDeserializer3;
            }
            map = result2;
        }
        typeDeserializer.typeParameterDescriptors = map;
    }

    @NotNull
    public static final /* synthetic */ DeserializationContext access$getC$p(TypeDeserializer $this) {
        return $this.c;
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$computeClassDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeClassDescriptor(fqNameIndex);
    }

    @Nullable
    public static final /* synthetic */ ClassifierDescriptor access$computeTypeAliasDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeTypeAliasDescriptor(fqNameIndex);
    }
}

