/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver;

import android.support.constraint.solver.ArrayRow;
import android.support.constraint.solver.Cache;
import android.support.constraint.solver.EquationCreation;
import android.support.constraint.solver.LinearEquation;
import android.support.constraint.solver.LinkedVariables;
import android.support.constraint.solver.SolverVariable;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import java.util.Arrays;
import java.util.HashMap;

public class LinearSystem {
    private static final boolean DEBUG = false;
    private static final int POOL_SIZE = 1000;
    private int mVariablesID = 0;
    private HashMap<String, SolverVariable> mVariables = null;
    private ArrayRow mGoal;
    private int TABLE_SIZE;
    private int mMaxColumns = this.TABLE_SIZE = 32;
    private ArrayRow[] mRows = null;
    private boolean[] mAlreadyTestedCandidates = new boolean[this.TABLE_SIZE];
    int mNumColumns = 1;
    int mNumRows = 0;
    int mMaxRows = this.TABLE_SIZE;
    private final Cache mCache;
    private SolverVariable[] mPoolVariables = new SolverVariable[1000];
    private int mPoolVariablesCount = 0;
    SolverVariable[] tempVars = new SolverVariable[256];
    private ArrayRow[] tempClientsCopy = new ArrayRow[32];

    public LinearSystem() {
        this.mRows = new ArrayRow[this.TABLE_SIZE];
        this.releaseRows();
        this.mCache = new Cache();
    }

    void increaseTableSize() {
        this.TABLE_SIZE *= 2;
        this.mRows = Arrays.copyOf(this.mRows, this.TABLE_SIZE);
        this.mCache.mIndexedVariables = Arrays.copyOf(this.mCache.mIndexedVariables, this.TABLE_SIZE);
        this.mAlreadyTestedCandidates = new boolean[this.TABLE_SIZE];
        this.mMaxColumns = this.TABLE_SIZE;
        this.mMaxRows = this.TABLE_SIZE;
        this.releaseGoal();
        this.mGoal = null;
    }

    private void releaseRows() {
        for (int i = 0; i < this.mRows.length; ++i) {
            ArrayRow row = this.mRows[i];
            if (row != null) {
                this.mCache.arrayRowPool.release(row);
            }
            this.mRows[i] = null;
        }
    }

    private void releaseGoal() {
        if (this.mGoal != null) {
            this.mCache.arrayRowPool.release(this.mGoal);
        }
    }

    public void reset() {
        int i;
        for (i = 0; i < this.mCache.mIndexedVariables.length; ++i) {
            SolverVariable variable = this.mCache.mIndexedVariables[i];
            if (variable == null) continue;
            variable.reset();
        }
        this.mCache.solverVariablePool.releaseAll((SolverVariable[])this.mPoolVariables, this.mPoolVariablesCount);
        this.mPoolVariablesCount = 0;
        Arrays.fill(this.mCache.mIndexedVariables, null);
        if (this.mVariables != null) {
            this.mVariables.clear();
        }
        this.mVariablesID = 0;
        this.releaseGoal();
        this.mGoal = null;
        this.mNumColumns = 1;
        for (i = 0; i < this.mNumRows; ++i) {
            this.mRows[i].used = false;
        }
        this.releaseRows();
        this.mNumRows = 0;
    }

    public void addConstraint(LinearEquation e) {
        ArrayRow row = EquationCreation.createRowFromEquation(this, e);
        this.addConstraint(row);
    }

    public SolverVariable createObjectVariable(Object anchor) {
        if (anchor == null) {
            return null;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = null;
        if (anchor instanceof ConstraintAnchor) {
            variable = ((ConstraintAnchor)anchor).getSolverVariable();
            if (variable == null) {
                ((ConstraintAnchor)anchor).resetSolverVariable(this.mCache);
                variable = ((ConstraintAnchor)anchor).getSolverVariable();
            }
            if (variable.id == -1 || variable.id > this.mVariablesID || this.mCache.mIndexedVariables[variable.id] == null) {
                if (variable.id != -1) {
                    variable.reset();
                }
                ++this.mVariablesID;
                ++this.mNumColumns;
                variable.id = this.mVariablesID;
                variable.mType = SolverVariable.Type.UNRESTRICTED;
                this.mCache.mIndexedVariables[this.mVariablesID] = variable;
            }
        }
        return variable;
    }

    public ArrayRow createRow() {
        ArrayRow row = this.mCache.arrayRowPool.acquire();
        if (row == null) {
            row = new ArrayRow(this.mCache);
        } else {
            row.reset();
        }
        return row;
    }

    public SolverVariable createSlackVariable() {
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(SolverVariable.Type.SLACK);
        ++this.mVariablesID;
        ++this.mNumColumns;
        variable.id = this.mVariablesID;
        this.mCache.mIndexedVariables[this.mVariablesID] = variable;
        return variable;
    }

    void addError(ArrayRow row) {
        SolverVariable error1 = this.createErrorVariable();
        SolverVariable error2 = this.createErrorVariable();
        row.addError(error1, error2);
    }

    void addSingleError(ArrayRow row, int sign) {
        SolverVariable error = this.createErrorVariable();
        row.addSingleError(error, sign);
    }

    private SolverVariable createVariable(String name, SolverVariable.Type type) {
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(type);
        variable.setName(name);
        ++this.mVariablesID;
        ++this.mNumColumns;
        variable.id = this.mVariablesID;
        if (this.mVariables == null) {
            this.mVariables = new HashMap();
        }
        this.mVariables.put(name, variable);
        this.mCache.mIndexedVariables[this.mVariablesID] = variable;
        return variable;
    }

    private SolverVariable createErrorVariable() {
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(SolverVariable.Type.ERROR);
        ++this.mVariablesID;
        ++this.mNumColumns;
        variable.id = this.mVariablesID;
        this.mCache.mIndexedVariables[this.mVariablesID] = variable;
        return variable;
    }

    private final SolverVariable acquireSolverVariable(SolverVariable.Type type) {
        SolverVariable variable = this.mCache.solverVariablePool.acquire();
        if (variable == null) {
            variable = new SolverVariable(this.mCache, type);
        }
        variable.reset();
        variable.setType(type);
        this.mPoolVariables[this.mPoolVariablesCount++] = variable;
        return variable;
    }

    public ArrayRow getGoal() {
        return this.mGoal;
    }

    public ArrayRow getRow(int n) {
        return this.mRows[n];
    }

    public float getValueFor(String name) {
        SolverVariable v = this.getVariable(name, SolverVariable.Type.UNRESTRICTED);
        if (v == null) {
            return 0.0f;
        }
        return v.computedValue;
    }

    public int getObjectVariableValue(Object anchor) {
        SolverVariable variable = ((ConstraintAnchor)anchor).getSolverVariable();
        if (variable != null) {
            return (int)(variable.computedValue + 0.5f);
        }
        return 0;
    }

    public SolverVariable getVariable(String name, SolverVariable.Type type) {
        SolverVariable variable;
        if (this.mVariables == null) {
            this.mVariables = new HashMap();
        }
        if ((variable = this.mVariables.get(name)) == null) {
            variable = this.createVariable(name, type);
        }
        return variable;
    }

    public void rebuildGoalFromErrors() {
        if (this.mGoal != null) {
            this.mGoal.reset();
        } else {
            this.mGoal = this.createRow();
        }
        for (int i = 1; i < this.mNumColumns; ++i) {
            SolverVariable variable = this.mCache.mIndexedVariables[i];
            if (variable.mType != SolverVariable.Type.ERROR) continue;
            this.mGoal.variables.put(variable, 1.0f);
        }
    }

    public void minimize() throws Exception {
        this.rebuildGoalFromErrors();
        this.minimizeGoal(this.mGoal);
    }

    public void minimizeGoal(ArrayRow goal) throws Exception {
        goal.variables.updateFromSystem(goal, this.mRows);
        boolean validGoal = goal.hasAtLeastOnePositiveVariable();
        if (!validGoal) {
            this.computeValues();
            return;
        }
        try {
            int tries = this.enforceBFS(goal);
            tries = this.optimize(goal);
            this.computeValues();
        }
        catch (Exception e) {
            this.computeValues();
            throw e;
        }
    }

    private void updateRowFromVariables(ArrayRow row) {
        if (this.mNumRows > 0) {
            row.variables.updateFromSystem(row, this.mRows);
            if (row.variables.currentSize == 0) {
                row.isSimpleDefinition = true;
            }
        }
    }

    public void addConstraint(ArrayRow row) {
        if (row == null) {
            return;
        }
        if (this.mNumRows + 1 >= this.mMaxRows || this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        this.updateRowFromVariables(row);
        row.ensurePositiveConstant();
        row.pickRowVariable();
        if (!row.hasKeyVariable()) {
            return;
        }
        if (this.mRows[this.mNumRows] != null) {
            this.mCache.arrayRowPool.release(this.mRows[this.mNumRows]);
        }
        row.updateClientEquations();
        this.mRows[this.mNumRows] = row;
        row.variable.definitionId = this.mNumRows++;
        int count = row.variable.mClientEquationsCount;
        if (count > 0) {
            while (this.tempClientsCopy.length < count) {
                this.tempClientsCopy = new ArrayRow[this.tempClientsCopy.length * 2];
            }
            ArrayRow[] clients = this.tempClientsCopy;
            System.arraycopy(row.variable.mClientEquations, 0, clients, 0, count);
            for (int i = 0; i < count; ++i) {
                ArrayRow client = clients[i];
                if (client == row) continue;
                client.variables.updateFromRow(client, row);
                client.updateClientEquations();
            }
        }
    }

    private int optimize(ArrayRow goal) {
        boolean done = false;
        int tries = 0;
        for (int i = 0; i < this.mNumColumns; ++i) {
            this.mAlreadyTestedCandidates[i] = false;
        }
        int tested = 0;
        while (!done) {
            ++tries;
            SolverVariable pivotCandidate = goal.variables.getPivotCandidate();
            if (pivotCandidate != null) {
                if (this.mAlreadyTestedCandidates[pivotCandidate.id]) {
                    pivotCandidate = null;
                } else {
                    this.mAlreadyTestedCandidates[pivotCandidate.id] = true;
                    if (++tested >= this.mNumColumns) {
                        done = true;
                    }
                }
            }
            if (pivotCandidate != null) {
                float minWeak = Float.MAX_VALUE;
                float minStrong = Float.MAX_VALUE;
                int pivotRowIndexWeak = -1;
                int pivotRowIndexStrong = -1;
                for (int i = 0; i < this.mNumRows; ++i) {
                    ArrayRow current = this.mRows[i];
                    SolverVariable variable = current.variable;
                    if (variable.mType == SolverVariable.Type.UNRESTRICTED || !current.hasVariable(pivotCandidate)) continue;
                    float C = current.constantValue;
                    float a_j = current.variables.get(pivotCandidate);
                    if (!(a_j < 0.0f)) continue;
                    float value = C * -1.0f / a_j;
                    if (pivotCandidate.mStrength == SolverVariable.Strength.STRONG) {
                        if (!(value < minStrong)) continue;
                        minStrong = value;
                        pivotRowIndexStrong = i;
                        continue;
                    }
                    if (!(value < minWeak)) continue;
                    minWeak = value;
                    pivotRowIndexWeak = i;
                }
                int pivotRowIndex = pivotRowIndexStrong > -1 ? pivotRowIndexStrong : pivotRowIndexWeak;
                if (pivotRowIndex > -1) {
                    ArrayRow pivotEquation = this.mRows[pivotRowIndex];
                    pivotEquation.variable.definitionId = -1;
                    pivotEquation.pivot(pivotCandidate);
                    pivotEquation.variable.definitionId = pivotRowIndex;
                    for (int i = 0; i < this.mNumRows; ++i) {
                        this.mRows[i].updateRowWithEquation(pivotEquation);
                    }
                    goal.updateRowWithEquation(pivotEquation);
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        return tries;
    }

    private int enforceBFS(ArrayRow goal) throws Exception {
        SolverVariable variable;
        int i;
        int tries = 0;
        boolean infeasibleSystem = false;
        for (i = 0; i < this.mNumRows; ++i) {
            variable = this.mRows[i].variable;
            if (variable.mType == SolverVariable.Type.UNRESTRICTED || !(this.mRows[i].constantValue < 0.0f)) continue;
            infeasibleSystem = true;
            break;
        }
        if (infeasibleSystem) {
            boolean done = false;
            tries = 0;
            while (!done) {
                int pivotColumnIndex;
                int pivotRowIndex;
                ++tries;
                float minWeak = Float.MAX_VALUE;
                float minStrong = Float.MAX_VALUE;
                int pivotRowIndexWeak = -1;
                int pivotRowIndexStrong = -1;
                int pivotColumnIndexStrong = -1;
                int pivotColumnIndexWeak = -1;
                for (int i2 = 0; i2 < this.mNumRows; ++i2) {
                    ArrayRow current = this.mRows[i2];
                    SolverVariable variable2 = current.variable;
                    if (variable2.mType == SolverVariable.Type.UNRESTRICTED || !(current.constantValue < 0.0f)) continue;
                    for (int j = 1; j < this.mNumColumns; ++j) {
                        SolverVariable candidate = this.mCache.mIndexedVariables[j];
                        float a_j = current.variables.get(candidate);
                        if (a_j <= 0.0f) continue;
                        float d_j = goal.variables.get(candidate);
                        float value = d_j / a_j;
                        if (variable2.mStrength == SolverVariable.Strength.STRONG) {
                            if (!(value < minStrong)) continue;
                            minStrong = value;
                            pivotRowIndexStrong = i2;
                            pivotColumnIndexStrong = j;
                            continue;
                        }
                        if (!(value < minWeak)) continue;
                        minWeak = value;
                        pivotRowIndexWeak = i2;
                        pivotColumnIndexWeak = j;
                    }
                }
                if (pivotRowIndexStrong != -1) {
                    pivotRowIndex = pivotRowIndexStrong;
                    pivotColumnIndex = pivotColumnIndexStrong;
                } else {
                    pivotRowIndex = pivotRowIndexWeak;
                    pivotColumnIndex = pivotColumnIndexWeak;
                }
                if (pivotRowIndex != -1) {
                    ArrayRow pivotEquation = this.mRows[pivotRowIndex];
                    pivotEquation.variable.definitionId = -1;
                    pivotEquation.pivot(this.mCache.mIndexedVariables[pivotColumnIndex]);
                    pivotEquation.variable.definitionId = pivotRowIndex;
                    for (int i3 = 0; i3 < this.mNumRows; ++i3) {
                        this.mRows[i3].updateRowWithEquation(pivotEquation);
                    }
                    goal.updateRowWithEquation(pivotEquation);
                    continue;
                }
                done = true;
            }
        }
        infeasibleSystem = false;
        for (i = 0; i < this.mNumRows; ++i) {
            variable = this.mRows[i].variable;
            if (variable.mType == SolverVariable.Type.UNRESTRICTED || !(this.mRows[i].constantValue < 0.0f)) continue;
            infeasibleSystem = true;
            break;
        }
        if (infeasibleSystem) {
            // empty if block
        }
        return tries;
    }

    private void computeValues() {
        for (int i = 0; i < this.mNumRows; ++i) {
            ArrayRow row = this.mRows[i];
            row.variable.computedValue = row.constantValue;
        }
    }

    void replaceVariable(ArrayRow target, SolverVariable variable) {
        int idx = variable.definitionId;
        if (idx != -1) {
            target.updateRowWithEquation(this.mRows[idx]);
        }
    }

    public void displayRows() {
        this.displaySolverVariables();
        String s = "";
        for (int i = 0; i < this.mNumRows; ++i) {
            s = s + this.mRows[i];
            s = s + "\n";
        }
        if (this.mGoal != null) {
            s = s + this.mGoal + "\n";
        }
        System.out.println(s);
    }

    public void displayReadableRows() {
        this.displaySolverVariables();
        String s = "";
        for (int i = 0; i < this.mNumRows; ++i) {
            s = s + this.mRows[i].toReadableString();
            s = s + "\n";
        }
        if (this.mGoal != null) {
            s = s + this.mGoal.toReadableString() + "\n";
        }
        System.out.println(s);
    }

    public void displayVariablesReadableRows() {
        this.displaySolverVariables();
        String s = "";
        for (int i = 0; i < this.mNumRows; ++i) {
            if (this.mRows[i].variable.mType != SolverVariable.Type.UNRESTRICTED) continue;
            s = s + this.mRows[i].toReadableString();
            s = s + "\n";
        }
        if (this.mGoal != null) {
            s = s + this.mGoal.toReadableString() + "\n";
        }
        System.out.println(s);
    }

    public int getMemoryUsed() {
        int actualRowSize = 0;
        for (int i = 0; i < this.mNumRows; ++i) {
            if (this.mRows[i] == null) continue;
            actualRowSize += this.mRows[i].sizeInBytes();
        }
        return actualRowSize;
    }

    public int getNumEquations() {
        return this.mNumRows;
    }

    public int getNumVariables() {
        return this.mVariablesID;
    }

    public void displaySystemInformations() {
        int count = 0;
        int rowSize = 0;
        for (int i = 0; i < this.TABLE_SIZE; ++i) {
            if (this.mRows[i] == null) continue;
            rowSize += this.mRows[i].sizeInBytes();
        }
        int actualRowSize = 0;
        for (int i = 0; i < this.mNumRows; ++i) {
            if (this.mRows[i] == null) continue;
            actualRowSize += this.mRows[i].sizeInBytes();
        }
        System.out.println("Linear System -> Table size: " + this.TABLE_SIZE + " (" + this.getDisplaySize(this.TABLE_SIZE * this.TABLE_SIZE) + ") -- row sizes: " + this.getDisplaySize(rowSize) + ", actual size: " + this.getDisplaySize(actualRowSize) + " rows: " + this.mNumRows + "/" + this.mMaxRows + " cols: " + this.mNumColumns + "/" + this.mMaxColumns + " " + count + " occupied cells, " + this.getDisplaySize(count) + " " + LinkedVariables.sCreation + " created Link variables");
    }

    private void displaySolverVariables() {
        String s = "Display Rows (" + this.mNumRows + "x" + this.mNumColumns + ") :\n\t | C | ";
        for (int i = 1; i <= this.mNumColumns; ++i) {
            SolverVariable v = this.mCache.mIndexedVariables[i];
            s = s + v;
            s = s + " | ";
        }
        s = s + "\n";
        System.out.println(s);
    }

    private String getDisplaySize(int n) {
        int mb = n * 4 / 1024 / 1024;
        if (mb > 0) {
            return "" + mb + " Mb";
        }
        int kb = n * 4 / 1024;
        if (kb > 0) {
            return "" + kb + " Kb";
        }
        return "" + n * 4 + " bytes";
    }

    public Cache getCache() {
        return this.mCache;
    }
}

