/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskOutputsGenerationListener;
import org.gradle.caching.BuildCache;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.BuildCacheConfigurationInternal;
import org.gradle.caching.internal.tasks.TaskOutputPacker;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginFactory;
import org.gradle.internal.time.Timer;
import org.gradle.internal.time.Timers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipCachedTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipCachedTaskExecuter.class);
    private final BuildCacheConfigurationInternal buildCacheConfiguration;
    private final TaskOutputPacker packer;
    private final TaskExecuter delegate;
    private final TaskOutputsGenerationListener taskOutputsGenerationListener;
    private final TaskOutputOriginFactory taskOutputOriginFactory;
    private BuildCache cache;

    public SkipCachedTaskExecuter(TaskOutputOriginFactory taskOutputOriginFactory, BuildCacheConfigurationInternal buildCacheConfiguration, TaskOutputPacker packer, TaskOutputsGenerationListener taskOutputsGenerationListener, TaskExecuter delegate) {
        this.taskOutputOriginFactory = taskOutputOriginFactory;
        this.buildCacheConfiguration = buildCacheConfiguration;
        this.packer = packer;
        this.taskOutputsGenerationListener = taskOutputsGenerationListener;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        BuildCacheKey cacheKey;
        TaskOutputsInternal taskOutputs;
        Timer clock;
        block24: {
            boolean cacheEnabled;
            clock = Timers.startTimer();
            taskOutputs = task.getOutputs();
            try {
                cacheEnabled = taskOutputs.isCacheEnabled();
            }
            catch (Exception t) {
                throw new GradleException(String.format("Could not evaluate TaskOutputs.cacheIf for %s.", task), (Throwable)t);
            }
            LOGGER.debug("Determining if {} is cached already", (Object)task);
            cacheKey = null;
            boolean cacheable = false;
            try {
                if (cacheEnabled) {
                    if (taskOutputs.hasDeclaredOutputs()) {
                        if (taskOutputs.isCacheAllowed()) {
                            cacheable = true;
                            TaskArtifactState taskState = context.getTaskArtifactState();
                            try {
                                cacheKey = taskState.calculateCacheKey();
                                LOGGER.info("Cache key for {} is {}", (Object)task, (Object)cacheKey);
                            }
                            catch (Exception e) {
                                throw new GradleException(String.format("Could not build cache key for %s.", task), (Throwable)e);
                            }
                            if (this.buildCacheConfiguration.isPullAllowed()) {
                                if (cacheKey != null) {
                                    if (taskState.isAllowedToUseCachedResults()) {
                                        boolean found = this.getCache().load(cacheKey, new BuildCacheEntryReader(){

                                            public void readFrom(InputStream input) {
                                                SkipCachedTaskExecuter.this.packer.unpack(taskOutputs, input, SkipCachedTaskExecuter.this.taskOutputOriginFactory.createReader(task));
                                                LOGGER.info("Unpacked output for {} from cache (took {}).", (Object)task, (Object)clock.getElapsed());
                                            }
                                        });
                                        if (found) {
                                            state.setOutcome(TaskExecutionOutcome.FROM_CACHE);
                                            this.taskOutputsGenerationListener.beforeTaskOutputsGenerated();
                                            return;
                                        }
                                    } else {
                                        LOGGER.info("Not loading {} from cache because pulling from cache is disabled for this task", (Object)task);
                                    }
                                } else {
                                    LOGGER.info("Not caching {} because no valid cache key was generated", (Object)task);
                                }
                            } else {
                                LOGGER.debug("Not loading {} from cache because pulling from cache is disabled for this build", (Object)task);
                            }
                            break block24;
                        }
                        LOGGER.info("Not caching {} because it declares multiple output files for a single output property via `@OutputFiles`, `@OutputDirectories` or `TaskOutputs.files()`", (Object)task);
                        break block24;
                    }
                    LOGGER.info("Not caching {} as task has declared no outputs", (Object)task);
                    break block24;
                }
                LOGGER.debug("Not caching {} as task output is not cacheable.", (Object)task);
            }
            finally {
                state.setCacheable(cacheable);
            }
        }
        this.delegate.execute(task, state, context);
        if (cacheKey != null) {
            if (this.buildCacheConfiguration.isPushAllowed()) {
                if (state.getFailure() == null) {
                    this.getCache().store(cacheKey, new BuildCacheEntryWriter(){

                        public void writeTo(OutputStream output) {
                            LOGGER.info("Packing {}", (Object)task.getPath());
                            SkipCachedTaskExecuter.this.packer.pack(taskOutputs, output, SkipCachedTaskExecuter.this.taskOutputOriginFactory.createWriter(task, clock.getElapsedMillis()));
                        }
                    });
                } else {
                    LOGGER.debug("Not pushing result from {} to cache because the task failed", (Object)task);
                }
            } else {
                LOGGER.debug("Not pushing results from {} to cache because pushing to cache is disabled for this build", (Object)task);
            }
        } else {
            LOGGER.info("Not pushing results from {} to cache because no valid cache key was generated", (Object)task);
        }
    }

    private synchronized BuildCache getCache() {
        if (this.cache == null) {
            this.cache = this.buildCacheConfiguration.getCache();
            LOGGER.info("Using {}", (Object)this.cache.getDescription());
        }
        return this.cache;
    }
}

