/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.FileAccess;
import org.gradle.cache.internal.FileIntegrityViolationException;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMultiProcessSafePersistentIndexedCache<K, V>
implements MultiProcessSafePersistentIndexedCache<K, V> {
    private final FileAccess fileAccess;
    private final Factory<BTreePersistentIndexedCache<K, V>> factory;
    private BTreePersistentIndexedCache<K, V> cache;

    public DefaultMultiProcessSafePersistentIndexedCache(Factory<BTreePersistentIndexedCache<K, V>> factory, FileAccess fileAccess) {
        this.factory = factory;
        this.fileAccess = fileAccess;
    }

    @Override
    public V get(final K key) {
        final PersistentIndexedCache<K, V> cache = this.getCache();
        try {
            return (V)this.fileAccess.readFile(new Factory<V>(){

                public V create() {
                    return cache.get(key);
                }
            });
        }
        catch (FileIntegrityViolationException e) {
            return null;
        }
    }

    @Override
    public void put(final K key, final V value) {
        final PersistentIndexedCache<K, V> cache = this.getCache();
        this.fileAccess.writeFile(new Runnable(){

            public void run() {
                cache.put(key, value);
            }
        });
    }

    @Override
    public void remove(final K key) {
        final PersistentIndexedCache<K, V> cache = this.getCache();
        this.fileAccess.writeFile(new Runnable(){

            public void run() {
                cache.remove(key);
            }
        });
    }

    @Override
    public void afterLockAcquire(FileLock.State currentCacheState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishWork() {
        if (this.cache != null) {
            try {
                this.fileAccess.writeFile(new Runnable(){

                    public void run() {
                        DefaultMultiProcessSafePersistentIndexedCache.this.cache.close();
                    }
                });
            }
            finally {
                this.cache = null;
            }
        }
    }

    @Override
    public void beforeLockRelease(FileLock.State currentCacheState) {
    }

    private PersistentIndexedCache<K, V> getCache() {
        if (this.cache == null) {
            this.fileAccess.writeFile(new Runnable(){

                public void run() {
                    DefaultMultiProcessSafePersistentIndexedCache.this.cache = (BTreePersistentIndexedCache)DefaultMultiProcessSafePersistentIndexedCache.this.factory.create();
                }
            });
        }
        return this.cache;
    }
}

