/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.builder.model.OptionalCompilationStep;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.sdklib.AndroidVersion;
import com.android.tools.fd.client.AppState;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.fd.client.InstantRunClient;
import com.android.tools.idea.fd.BuildCause;
import com.android.tools.idea.fd.BuildMode;
import com.android.tools.idea.fd.BuildSelection;
import com.android.tools.idea.fd.FileChangeListener;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.InstantRunTasksProvider;
import com.android.tools.idea.fd.RunAsValidator;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.run.BeforeRunBuilder;
import com.android.tools.idea.gradle.run.GradleTaskRunner;
import com.android.tools.idea.run.AndroidRunConfigContext;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.InstalledPatchCache;
import com.android.tools.idea.run.util.MultiUserUtils;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunBuilder
implements BeforeRunBuilder {
    private static final Logger LOG = Logger.getInstance(InstantRunBuilder.class);
    @Nullable
    private final IDevice myDevice;
    private final InstantRunContext myInstantRunContext;
    private final AndroidRunConfigContext myRunContext;
    private final InstantRunTasksProvider myTasksProvider;
    private final RunAsValidator myRunAsValidator;
    private final InstalledApkCache myInstalledApkCache;
    private final InstantRunClientDelegate myInstantRunClientDelegate;
    private final boolean myFlightRecorderEnabled;

    public InstantRunBuilder(@Nullable IDevice device, @NotNull InstantRunContext instantRunContext, @NotNull AndroidRunConfigContext runConfigContext, @NotNull InstantRunTasksProvider tasksProvider, @NotNull RunAsValidator runAsValidator) {
        if (instantRunContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instantRunContext", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        if (runConfigContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfigContext", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        if (tasksProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasksProvider", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        if (runAsValidator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runAsValidator", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        this(device, instantRunContext, runConfigContext, tasksProvider, InstantRunSettings.isRecorderEnabled(), runAsValidator, (InstalledApkCache)ServiceManager.getService(InstalledApkCache.class), new InstantRunClientDelegate(){});
    }

    InstantRunBuilder(@Nullable IDevice device, @NotNull InstantRunContext instantRunContext, @NotNull AndroidRunConfigContext runConfigContext, @NotNull InstantRunTasksProvider tasksProvider, boolean enableFlightRecorder, @NotNull RunAsValidator runAsValidator, @NotNull InstalledApkCache installedApkCache, @NotNull InstantRunClientDelegate delegate) {
        if (instantRunContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instantRunContext", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        if (runConfigContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfigContext", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        if (tasksProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasksProvider", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        if (runAsValidator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runAsValidator", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        if (installedApkCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installedApkCache", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        this.myDevice = device;
        this.myInstantRunContext = instantRunContext;
        this.myRunContext = runConfigContext;
        this.myTasksProvider = tasksProvider;
        this.myFlightRecorderEnabled = enableFlightRecorder;
        this.myRunAsValidator = runAsValidator;
        this.myInstalledApkCache = installedApkCache;
        this.myInstantRunClientDelegate = delegate;
    }

    @Override
    public boolean build(@NotNull GradleTaskRunner taskRunner, @NotNull List<String> commandLineArguments) throws InterruptedException, InvocationTargetException {
        if (taskRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskRunner", "com/android/tools/idea/fd/InstantRunBuilder", "build"));
        }
        if (commandLineArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArguments", "com/android/tools/idea/fd/InstantRunBuilder", "build"));
        }
        BuildSelection buildSelection = this.getBuildSelection();
        this.myInstantRunContext.setBuildSelection(buildSelection);
        if (buildSelection.mode != BuildMode.HOT) {
            LOG.info((Object)((Object)buildSelection.mode) + ": " + (Object)((Object)buildSelection.why));
        }
        ArrayList<String> args = new ArrayList<String>(commandLineArguments);
        args.addAll(this.myInstantRunContext.getCustomBuildArguments());
        FileChangeListener.Changes fileChanges = this.myInstantRunContext.getFileChangesAndReset();
        args.addAll(InstantRunBuilder.getInstantRunArguments(buildSelection.mode, fileChanges));
        args.addAll(this.getFlightRecorderArguments());
        LinkedList<String> tasks = new LinkedList<String>();
        if (buildSelection.mode == BuildMode.CLEAN) {
            tasks.addAll(this.myTasksProvider.getCleanAndGenerateSourcesTasks());
        }
        tasks.addAll(this.myTasksProvider.getFullBuildTasks());
        return taskRunner.run(tasks, null, args);
    }

    @NotNull
    private BuildSelection getBuildSelection() {
        BuildCause buildCause = this.needsCleanBuild(this.myDevice);
        if (buildCause != null) {
            BuildSelection buildSelection = new BuildSelection(BuildMode.CLEAN, buildCause, InstantRunBuilder.hasMultiUser(this.myDevice));
            if (buildSelection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "getBuildSelection"));
            }
            return buildSelection;
        }
        buildCause = this.needsFullBuild(this.myDevice);
        if (buildCause != null) {
            BuildSelection buildSelection = new BuildSelection(BuildMode.FULL, buildCause, InstantRunBuilder.hasMultiUser(this.myDevice));
            if (buildSelection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "getBuildSelection"));
            }
            return buildSelection;
        }
        buildCause = this.needsColdswapPatches(this.myDevice);
        if (buildCause != null) {
            BuildSelection buildSelection = new BuildSelection(BuildMode.COLD, buildCause, InstantRunBuilder.hasMultiUser(this.myDevice));
            if (buildSelection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "getBuildSelection"));
            }
            return buildSelection;
        }
        BuildSelection buildSelection = new BuildSelection(BuildMode.HOT, BuildCause.INCREMENTAL_BUILD);
        if (buildSelection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "getBuildSelection"));
        }
        return buildSelection;
    }

    private static boolean hasMultiUser(@Nullable IDevice device) {
        return MultiUserUtils.hasMultipleUsers(device, 200L, TimeUnit.MILLISECONDS, false);
    }

    @Nullable
    @Contract(value="null -> !null")
    private BuildCause needsCleanBuild(@Nullable IDevice device) {
        if (device == null) {
            return BuildCause.NO_DEVICE;
        }
        if (this.myRunContext.isCleanRerun()) {
            return BuildCause.USER_REQUESTED_CLEAN_BUILD;
        }
        int defaultUserId = 0;
        if (!this.isAppInstalledForUser(device, this.myInstantRunContext.getApplicationId(), defaultUserId)) {
            return BuildCause.APP_NOT_INSTALLED;
        }
        if (!this.buildTimestampsMatch(device, defaultUserId)) {
            if (this.myInstalledApkCache.getInstallState(device, this.myInstantRunContext.getApplicationId()) == null) {
                return BuildCause.FIRST_INSTALLATION_TO_DEVICE;
            }
            return BuildCause.MISMATCHING_TIMESTAMPS;
        }
        return null;
    }

    @Nullable
    private BuildCause needsFullBuild(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunBuilder", "needsFullBuild"));
        }
        AndroidVersion deviceVersion = device.getVersion();
        if (!InstantRunManager.isInstantRunCapableDeviceVersion(deviceVersion)) {
            return BuildCause.API_TOO_LOW_FOR_INSTANT_RUN;
        }
        if (!InstantRunManager.hasLocalCacheOfDeviceData(device, this.myInstantRunContext)) {
            return BuildCause.FIRST_INSTALLATION_TO_DEVICE;
        }
        if (ApplicationManager.getApplication() != null) {
            GradleInvoker.saveAllFilesSafely();
        }
        if (this.manifestResourceChanged(device)) {
            return BuildCause.MANIFEST_RESOURCE_CHANGED;
        }
        if (!this.isAppRunning(device)) {
            if (!deviceVersion.isGreaterOrEqualThan(21)) {
                return BuildCause.FREEZE_SWAP_REQUIRES_API21;
            }
            if (!this.myRunAsValidator.hasWorkingRunAs(device, this.myInstantRunContext.getApplicationId())) {
                return BuildCause.FREEZE_SWAP_REQUIRES_WORKING_RUN_AS;
            }
        }
        return null;
    }

    @Nullable
    private BuildCause needsColdswapPatches(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunBuilder", "needsColdswapPatches"));
        }
        if (!this.isAppRunning(device)) {
            return BuildCause.APP_NOT_RUNNING;
        }
        if (device.supportsFeature(IDevice.HardwareFeature.TV) || StringUtil.notNullize((String)device.getProperty("ro.product.model")).contains("sdk_google_atv_")) {
            return BuildCause.ANDROID_TV_UNSUPPORTED;
        }
        if (this.myInstantRunContext.usesMultipleProcesses()) {
            return BuildCause.APP_USES_MULTIPLE_PROCESSES;
        }
        return null;
    }

    private boolean isAppRunning(@NotNull IDevice device) {
        boolean isAppRunning;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunBuilder", "isAppRunning"));
        }
        try {
            isAppRunning = this.myInstantRunClientDelegate.isAppInForeground(device, this.myInstantRunContext);
        }
        catch (IOException e) {
            InstantRunManager.LOG.warn("IOException while attempting to determine if app is in foreground, assuming app not alive");
            isAppRunning = false;
            InstantRunManager.LOG.warn("Force killing app");
            try {
                device.executeShellCommand("am force-stop " + this.myInstantRunContext.getApplicationId(), (IShellOutputReceiver)new NullOutputReceiver());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isAppRunning && this.myRunContext.isSameExecutorAsPreviousSession();
    }

    private static List<String> getInstantRunArguments(@NotNull BuildMode buildMode, @Nullable FileChangeListener.Changes changes) {
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/fd/InstantRunBuilder", "getInstantRunArguments"));
        }
        StringBuilder sb = new StringBuilder(50);
        sb.append("-P");
        sb.append("android.optional.compilation");
        sb.append("=");
        sb.append(OptionalCompilationStep.INSTANT_DEV.name());
        if (buildMode == BuildMode.HOT) {
            InstantRunBuilder.appendChangeInfo(sb, changes);
        } else if (buildMode == BuildMode.COLD) {
            sb.append(",").append(OptionalCompilationStep.RESTART_ONLY.name());
        } else {
            sb.append(",").append("FULL_APK");
        }
        return Collections.singletonList(sb.toString());
    }

    @NotNull
    private List<String> getFlightRecorderArguments() {
        ImmutableList immutableList = this.myFlightRecorderEnabled ? ImmutableList.of((Object)"--info") : ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "getFlightRecorderArguments"));
        }
        return immutableList;
    }

    private static void appendChangeInfo(@NotNull StringBuilder sb, @Nullable FileChangeListener.Changes changes) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/android/tools/idea/fd/InstantRunBuilder", "appendChangeInfo"));
        }
        if (changes == null) {
            return;
        }
    }

    private boolean buildTimestampsMatch(@NotNull IDevice device, @Nullable Integer userId) {
        String localTimestamp;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunBuilder", "buildTimestampsMatch"));
        }
        InstantRunBuildInfo instantRunBuildInfo = this.myInstantRunContext.getInstantRunBuildInfo();
        String string = localTimestamp = instantRunBuildInfo == null ? null : instantRunBuildInfo.getTimeStamp();
        if (StringUtil.isEmpty((String)localTimestamp)) {
            InstantRunManager.LOG.info("Local build timestamp is empty!");
            return false;
        }
        if (InstantRunClient.USE_BUILD_ID_TEMP_FILE && !this.isAppInstalledForUser(device, this.myInstantRunContext.getApplicationId(), userId)) {
            return false;
        }
        String deviceBuildTimestamp = this.myInstantRunClientDelegate.getDeviceBuildTimestamp(device, this.myInstantRunContext);
        InstantRunManager.LOG.info(String.format("Build timestamps: Local: %1$s, Device: %2$s", localTimestamp, deviceBuildTimestamp));
        return localTimestamp.equals(deviceBuildTimestamp);
    }

    private boolean isAppInstalledForUser(@NotNull IDevice device, @NotNull String pkgName, @Nullable Integer userId) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunBuilder", "isAppInstalledForUser"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/fd/InstantRunBuilder", "isAppInstalledForUser"));
        }
        InstalledApkCache.InstallState installState = this.myInstalledApkCache.getInstallState(device, pkgName);
        if (installState == null) {
            InstantRunManager.LOG.info("Package " + pkgName + " was not detected on the device.");
            return false;
        }
        if (userId != null && !installState.users.isEmpty() && !installState.users.contains(userId)) {
            LOG.info("Package " + pkgName + " was not installed for default user.");
            return false;
        }
        return true;
    }

    public boolean manifestResourceChanged(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunBuilder", "manifestResourceChanged"));
        }
        InstalledPatchCache cache = this.myInstantRunContext.getInstalledPatchCache();
        HashCode currentHash = this.myInstantRunContext.getManifestResourcesHash();
        HashCode installedHash = cache.getInstalledManifestResourcesHash(device, this.myInstantRunContext.getApplicationId());
        return installedHash != null && !installedHash.equals((Object)currentHash);
    }

    static interface InstantRunClientDelegate {
        default public String getDeviceBuildTimestamp(@NotNull IDevice device, @NotNull InstantRunContext instantRunContext) {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunBuilder$InstantRunClientDelegate", "getDeviceBuildTimestamp"));
            }
            if (instantRunContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instantRunContext", "com/android/tools/idea/fd/InstantRunBuilder$InstantRunClientDelegate", "getDeviceBuildTimestamp"));
            }
            return InstantRunClient.getDeviceBuildTimestamp((IDevice)device, (String)instantRunContext.getApplicationId(), (ILogger)InstantRunManager.ILOGGER);
        }

        default public boolean isAppInForeground(@NotNull IDevice device, @NotNull InstantRunContext context) throws IOException {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunBuilder$InstantRunClientDelegate", "isAppInForeground"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/fd/InstantRunBuilder$InstantRunClientDelegate", "isAppInForeground"));
            }
            InstantRunClient instantRunClient = InstantRunManager.getInstantRunClient(context);
            try {
                return instantRunClient != null && instantRunClient.getAppState(device) == AppState.FOREGROUND;
            }
            catch (IOException e) {
                Client client = device.getClient(context.getApplicationId());
                if (client == null) {
                    InstantRunManager.LOG.info("Application not running");
                    return false;
                }
                throw e;
            }
        }
    }
}

